#include "stdafx.h"
#include "CPixelbit.h"

//	萔
const char *const DIALOG_TITLE = "RailSim II";

const int FLASHBUF_SIZE = 1024;	//	ꎞobt@TCY
const int FLASHBUF_NUM = 8;		//	ꎞobt@

//	O[o
char g_FlashBuf[FLASHBUF_NUM][FLASHBUF_SIZE];	//	ꎞobt@

int g_FlashBufSelect = 0;	//	ꎞobt@ԍ

/*
 *	ꎞobt@ɏto
 */
char *FlashIn(
	char *format,	//	
	...				//	CӃp^
){
	g_FlashBufSelect = (g_FlashBufSelect+1)%FLASHBUF_NUM;
	va_list	vl;
	va_start(vl, format);
	vsprintf(g_FlashBuf[g_FlashBufSelect], format, vl);
	va_end(vl);
	return g_FlashBuf[g_FlashBufSelect];
}

/*
 *	ꎞobt@̃AhX擾
 */
char *FlashOut(
	int n	//	ԍ (-1 őO FlashIn obt@)
){
	return g_FlashBuf[n<0 ? g_FlashBufSelect : n];
}

/*
 *	t_CAO
 */
void Dialog(
	char *format,	//	
	...				//	CӃp^
){
	g_FlashBufSelect = (g_FlashBufSelect+1)%FLASHBUF_NUM;
	va_list	vl;
	va_start(vl, format);
	vsprintf(g_FlashBuf[g_FlashBufSelect], format, vl);
	va_end(vl);
	MessageBox(GetActiveWindow(),
		g_FlashBuf[g_FlashBufSelect], DIALOG_TITLE, MB_APPLMODAL);
}

/*
 *	G[_CAO
 */
void ErrorDialog(
	char *format,	//	
	...				//	CӃp^
){
	g_FlashBufSelect = (g_FlashBufSelect+1)%FLASHBUF_NUM;
	va_list	vl;
	va_start(vl, format);
	vsprintf(g_FlashBuf[g_FlashBufSelect], format, vl);
	va_end(vl);
	ShowCursor(TRUE);
	DestroyWindow(svw.hWnd);
	MessageBox(GetActiveWindow(),
		g_FlashBuf[g_FlashBufSelect], DIALOG_TITLE, MB_APPLMODAL);
	//PostQuitMessage(0);
	ExitProcess(0);
}

/*
 *	͂E_CAO
 */
int YesNo(
	char *format,	//	
	...				//	CӃp^
){
	g_FlashBufSelect = (g_FlashBufSelect+1)%FLASHBUF_NUM;
	va_list	vl;
	va_start(vl, format);
	vsprintf(g_FlashBuf[g_FlashBufSelect], format, vl);
	va_end(vl);
	return MessageBox(GetActiveWindow(),
		g_FlashBuf[g_FlashBufSelect], DIALOG_TITLE, MB_YESNO|MB_APPLMODAL);
}

/*
 *	͂EELZ_CAO
 */
int YesNoCancel(
	char *format,	//	
	...				//	CӃp^
){
	g_FlashBufSelect = (g_FlashBufSelect+1)%FLASHBUF_NUM;
	va_list	vl;
	va_start(vl, format);
	vsprintf(g_FlashBuf[g_FlashBufSelect], format, vl);
	va_end(vl);
	return MessageBox(GetActiveWindow(),
		g_FlashBuf[g_FlashBufSelect], DIALOG_TITLE, MB_YESNOCANCEL|MB_APPLMODAL);
}

/*
 *	t@CI_CAO
 *
 *	߂l: TRUE = I𐬌AFALSE = LZAs
 */
BOOL SelectFile(
	HWND hWnd,			//	Ăяonh
	char *file,			//	t@Ci[
	int len,			//	t@C̍ő啶
	const char *filt,	//	tB^
	const char *def,	//	ftHggq
	int flag			//	TRUE = AFALSE = Ǎ
){
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(OPENFILENAME));
	memset(file, 0, sizeof(file));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = filt;
	ofn.nFilterIndex = 0;
	ofn.lpstrDefExt = def;
	ofn.nMaxFile = len;
	ofn.lpstrFile = file;
	BOOL ret;
	if(flag){
		ofn.Flags = OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;
		ret = GetSaveFileName(&ofn);
	}else{
		ofn.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
		ret = GetOpenFileName(&ofn);
	}
	return ret;
}

/*
 *	F쐬_CAO
 *
 *	߂l: TRUE = I𐬌AFALSE = LZAs
 */
BOOL ColorDialog(
	HWND hWnd,		//	Ăяonh
	PDWORD color,	//	Fi[
	DWORD init		//	F
){
	static COLORREF colorsave[16];
	CHOOSECOLOR ccs;
	int r, g, b;
	SplitColor(init, &r, &g, &b);
	ccs.lStructSize = sizeof(CHOOSECOLOR);
	ccs.hwndOwner = hWnd;
	ccs.rgbResult = RGB(r, g, b);
	ccs.lpCustColors = colorsave;
	ccs.Flags = CC_FULLOPEN|CC_RGBINIT;
	BOOL ret = ChooseColor(&ccs);
	if(!ret) return FALSE;
	*color = MakePixel(GetRValue(ccs.rgbResult),
		GetGValue(ccs.rgbResult), GetBValue(ccs.rgbResult));
	return TRUE;
}

/*
 *	GetLastError() ̏ڍׂ\
 */
void ShowLastError(){
	LPVOID lpMsgBuf;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM
		|FORMAT_MESSAGE_IGNORE_INSERTS, NULL, GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&lpMsgBuf, 0, NULL);
	MessageBox(NULL, (LPSTR)lpMsgBuf, "Error", MB_APPLMODAL);
	LocalFree(lpMsgBuf);
}

/*
 *	gq`FbN
 */
bool CheckFileExt(
	char *fname,	//	t@C
	char *ext		//	gq (sIh܂)
){
	int len1 = strlen(fname), len2 = strlen(ext);
	return len1>len2 && !strcmpi(&fname[len1-len2], ext);
}

/*
 *	gqt
 */
string FixFileExt(
	char *fname,	//	t@C
	char *ext		//	gq (sIh܂)
){
	int len = strlen(fname), next = strlen(ext);
	if(*CharPrev(fname, fname+len)=='.') return string(fname)+ext;
	if(len<next+1) return string(fname)+string(".")+ext;
	if(_strcmpi(fname+len-next, ext)) return string(fname)+string(".")+ext;
	if(*CharPrev(fname, fname+len-next)=='.') return fname;
	return string(fname)+string(".")+ext;
}

/*
 *	t@CtpXfBNĝݎo
 */
void CutPath(
	char *path	//	pXi[
){
	char *ptr = path+strlen(path);
	for(; ptr>path && *ptr!='\\'; ptr = CharPrev(path, ptr)) *ptr = 0;
}

/*
 *	t@CtpXt@Ĉݎo
 */
void CutFileName(
	char *name,	//	t@Ci[
	char *path	//	tpX
){
	char *ptr = path+strlen(path);
	while(ptr>path && *ptr!='\\') ptr = CharPrev(path, ptr);
	strcpy(name, *ptr=='\\' ? ptr+1 : ptr);
}

/*
 *	st@C̃fBNg擾
 */
void GetAppPath(
	char *path	//	pXi[
){
	GetModuleFileName(GetModuleHandle(NULL), path, 1024);
	CutPath(path);
}

/*
 *	w肳ꂽt@CpXƓꏊJgfBNgɎw
 */
void MoveToFile(
	char *path	//	pXi[
){
	char *tmp = FlashIn("%s", path);
	CutPath(tmp);
	chdir(tmp);
}

/*
 *	t@C '/' '\' ܂܂Ă邩ׂ
 */
bool CheckSlash(
	const char *chk	//	pXi[
){
	for(; *chk; chk = CharNext(chk)) if(*chk=='\\' || *chk=='/') return true;
	return false;
}

/*
 *	convert from " to ''
 */
string ExpandDoubleQuote(
	const string &str	//	Ώە
){
	string ret = str;
	int i = 0;
	while(ret[i] && i<ret.size()){
		if(ret[i]=='\"'){
			ret[i] = '\'';
			ret.insert(i, 1, '\'');
		}
		const char *cs = ret.c_str();
		i = CharNext(cs+i)-cs;
	}
	return ret;
}

/*
 *	convert from '' to "
 */
string RestoreDoubleQuote(
	const string &str	//	Ώە
){
	string ret = str;
	int i = 0;
	while(ret[i] && i<ret.size()-1){
		if(ret[i]=='\'' && ret[i+1]=='\''){
			ret[i] = '\"';
			ret.erase(i+1, 1);
		}
		const char *cs = ret.c_str();
		i = CharNext(cs+i)-cs;
	}
	return ret;
}
