#ifndef CWINDOWCTRL_H_INCLUDED
#define CWINDOWCTRL_H_INCLUDED

#include "CInterface.h"
#include "CMiniButton.h"

class CWindowCtrl;

/*
 *	EBhETCU
 */
class CWindowResizer{
public:
	virtual void WindowResized(int, int, CWindowCtrl *) = 0;
};

/*
 *	EBhERg[
 */
class CWindowCtrl: public CInterface{
protected:
	int m_State;					//	
	int m_OldX, m_OldY;				//	ړOW
	int m_DragX, m_DragY;			//	^Cgo[hbOW
	int m_MinWidth, m_MinHeight;	//	ŏTCY
	int m_MaxWidth, m_MaxHeight;	//	őTCY
	D3DCOLOR m_Color;				//	EBhEF
	CMiniButton *m_CloseButton;		//	N[Y{^
	CWindowResizer *m_Resizer;		//	TCU
public:
	CWindowCtrl();
	virtual ~CWindowCtrl();
	void Init(int, int, int, int, char *, CInterface *p, bool);
	virtual void SetSize(int, int);
	void SetResize(int, int, int, int, CWindowResizer *);
	bool CheckClose(){ return m_Visible && m_CloseButton->IsPushed(); }
	void SetColor(D3DCOLOR c){ m_Color = c; }
	void SetAutoTransparent();
	bool IsInsideTitleBar(int, int);
	bool IsInsideLeftGrab(int, int);
	bool IsInsideTopGrab(int, int);
	bool IsInsideRightGrab(int, int);
	bool IsInsideBottomGrab(int, int);
	void BeginDrag(int, int, int);
	virtual int GetWindowState(){ return 0; }
	bool ScanInput();
	virtual bool ScanInputWindow(){ return false; }
	void Render();
	virtual void RenderWindow(){}
};

//	OO[o
extern CWindowCtrl *g_ModalDialog;

#endif
