#ifndef CVIDEOMODE_H_INCLUDED
#define CVIDEOMODE_H_INCLUDED

#include "CStaticCtrl.h"
#include "CGroupBox.h"
#include "CCheckBox.h"
#include "CRadioButton.h"
#include "CPushButton.h"
#include "CInterfaceMode.h"

/*
 *	V~[Vݒ胂[h
 */
class CVideoMode: public CInterfaceMode{
private:
	CWindowCtrl m_VideoWindow;		//	
	CGroupBox m_PictureGroup;		//	XN[VbgO[v
	CStaticCtrl m_PictureExpr;		//	XN[Vbg
	CStaticCtrl m_PictureInfo;		//	XN[Vbg
	CStaticCtrl m_QualityLabel;		//	掿x
	CRadioButton m_Quality[4];		//	掿`FbN
	CGroupBox m_VideoGroup;			//	xO[v
	CStaticCtrl m_VideoExpr;		//	XN[Vbg
	CStaticCtrl m_VideoInfo;		//	XN[Vbg
	CPushButton m_StartButton;		//	^Jn{^
	CPushButton m_StopButton;		//	^~{^
	CPushButton m_RewindButton;		//	߂{^
	CPushButton m_ForwardButton;	//	{^
	CCheckBox m_ExceptPause;		//	|[YBeȂ
	CCheckBox m_OnlyPhotoMode;		//	Be[hȊOBeȂ
	CStaticCtrl m_DownsampleLabel;	//	_ETvx
	CRadioButton m_Downsample[3];	//	_ETv`FbN
	CStaticCtrl m_FormatLabel;		//	tH[}bgx
	CRadioButton m_Format[2];		//	tH[}bg`FbN
	//CCheckBox m_VideoSound;			//	^`FbN
public:
	CVideoMode();
	~CVideoMode(){}
	void WindowResized(int, int, CWindowCtrl *);
	char *LoadInterfaceSetting(char *);
	void SaveInterfaceSetting(FILE *);
	void EnterInterface();
	void ScanInputInterface();
	int GetPictureQuality();
	int GetExceptPause(){ return m_ExceptPause.GetCheck(); }
	int GetOnlyPhotoMode(){ return m_OnlyPhotoMode.GetCheck(); }
	int GetDownsample(){ return m_Downsample->GetNumber(); }
	int GetFormat(){ return m_Format->GetNumber(); }
//	int GetVideoSound(){ return m_VideoSound.GetCheck(); }
};

//	OO[o
extern CVideoMode *g_VideoMode;

#endif
