#include "stdafx.h"
#include "CPluginTree.h"

//	萔
const int PT_NAME_MAX = 64;	//	̍ő咷

//	static o
CTreeElement *CTreeElement::ms_FocusPrev;
CTreeElement *CTreeElement::ms_FocusNext;

/*
 *	RXgN^
 */
CTreeElement::CTreeElement(
	char *str,			//	
	CTreeDirElement *p,	//	e
	CPluginTree *ctrl	//	c[Rg[
){
	m_State = 0;
	m_Width = -1;
	m_ClickTime = 0;
	m_String = str;
	m_Parent = p;
	m_Brother = NULL;
	m_Owner = ctrl;
	m_EditBox = NULL;
}

/*
 *	eKw玩g폜
 */
void CTreeElement::Delete(){
	if(m_Parent) m_Parent->DeleteItem(this);
}

/*
 *	wWׂ͈͓
 */
bool CTreeElement::IsInsideItem(
	int ix, int iy,	//	
	int px, int py	//	
){
	return ix<=px && px<ix+TILE_UNIT+TREE_ICON_OFS
		+TREE_ICON_MARGIN*2+m_Width && iy<=py && py<iy+TILE_UNIT;
}

/*
 *	l[Jn
 */
void CTreeElement::BeginRename(){
	if(!IsRenamable()) return;
	m_EditBox = new CEditBox;
	m_Width = (m_String.size()+1)*FONT_WIDTH+2;
	m_EditBox->Create(0, 0, m_Width-2, PT_NAME_MAX, m_String);
	m_Owner->GiveFocus(false);
}

/*
 *	l[I
 */
void CTreeElement::EndRename(
	bool update	//	XVtO
){
	if(update){
		string newname;
		m_EditBox->GetText(newname);
		if(newname.size() && ConfirmRename(newname)){
			m_String = newname;
			m_Parent->Sort(false);
		}
	}
	DELETE_V(m_EditBox);
	m_Width = -1;
}

/*
 *	hbȌ
 */
void CTreeElement::PrepareDrag(){
	m_State = 1;
	CDragContainer::BeginDrag(DRAG_PLUGIN, m_Owner);
	CDragContainer::Insert((DWORD)this);
}

/*
 *	hbOACe\
 */
void CTreeElement::RenderDragItem(){
	POINT pos = g_Cursor.GetPos();
	Render(pos.x-TILE_UNIT/2, pos.y-TILE_UNIT/2, 0, 0, -1);
}

/*
 *	\[gpr֐
 */
int CTreeElement::Compare(
	CTreeElement *rhs	//	E
){
	int ret;
	if(IsDirectory()){
		if(rhs->IsDirectory()){
			ret = _mbsicmp(
				(PUCHAR)m_String.c_str(), (PUCHAR)rhs->m_String.c_str());
		}else{
			return -1;
		}
	}else{
		if(rhs->IsDirectory()){
			return 1;
		}else{
			ret = _mbsicmp(
				(PUCHAR)m_String.c_str(), (PUCHAR)rhs->m_String.c_str());
		}
	}
	return ret ? ret : (this<rhs ? 1 : -1);
}

/*
 *	}[W\[g
 */
void CTreeElement::MergeSort(
	CTreeElement **seed,	//	Jn|C^
	CTreeElement *end		//	I|C^
){
	int num1 = 0, num2 = 0, id = 0;
	CTreeElement *ptr = this, *mid = this, *last = this, **carrier = seed;
	while(ptr!=end){
		if(num1>num2){
			num2++;
		}else{
			num1++;
			last = mid;
			mid = mid->m_Brother;
		}
		ptr = ptr->m_Brother;
	}
	if(num1>1) MergeSort(seed, mid);
	if(num2>1) mid->MergeSort(&mid, end);
	CTreeElement *adr1 = *seed, *adr2 = mid;
	while(true){
		int *cnt;
		CTreeElement **next;
		if(num1){
			if(num2){
				if(adr1->Compare(adr2)<0){
					next = &adr1; cnt = &num1;
				}else{
					next = &adr2; cnt = &num2;
				}
			}else{
				next = &adr1; cnt = &num1;
			}
		}else{
			if(num2){
				next = &adr2; cnt = &num2;
			}else{
				break;
			}
		}
		*carrier = *next;
		carrier = &(*next)->m_Brother;
		*next = (*next)->m_Brother;
		(*cnt)--;
		id++;
	}
	*carrier = NULL;
}

/*
 *	J
 */
void CTreeElement::Open(){
	m_Owner->SetFocusItem(this);
	m_Owner->EnsureVisible();
	if(IsFile()) m_Owner->GiveFocus(false);
}
