#include "stdafx.h"
#include "RailMap.h"
#include "CSimpleDialog.h"
#include "CRailWay.h"
#include "CScene.h"
#include "CTrain.h"
#include "CTrainGroup.h"
#include "CTrainPlugin.h"
#include "CSkinPlugin.h"
#include "CListView.h"
#include "CSimulationMode.h"

/*
 *	RXgN^ (Ǎp)
 */
CTrain::CTrain(
	CTrainGroup *group	//	Ґ
){
	m_Reverse = false;
	m_Warping = m_WarpingOld = false;
	m_OldPos[0] = m_OldPos[1] = m_TiltDir = V3ZERO;
	m_Group = group;
	m_TrainPlugin = NULL;
	m_ListElement = NULL;
	m_Next = NULL;
}

/*
 *	RXgN^
 */
CTrain::CTrain(
	CTrainPlugin *tpi,	//	qvOC
	CTrainGroup *group,	//	Ґ
	bool rev			//	]tO
):
	CModelInst(tpi)	//	{NX
{
	m_Reverse = rev;
	m_Warping = m_WarpingOld = false;
	m_OldPos[0] = m_OldPos[1] = m_TiltDir = V3ZERO;
	m_Group = group;
	m_TrainPlugin = tpi;
	m_TrainPlugin->SetAxleList(this);
	m_ListElement = NULL;
	m_Next = NULL;
}

/*
 *	fXgN^
 */
CTrain::~CTrain(){
	DELETE_V(m_Next);
}

/*
 *	q]
 */
void CTrain::Reverse(){
	if(m_Group->IsSet()){
		EnqueueCommonDialog(new CSimpleDialog(lang(CannotChangeWhileTrainSet), lang(Error)));
		g_Skin->Error();
		return;
	}
	m_Reverse = !m_Reverse;
	if(m_ListElement) m_ListElement->SetString(1, m_Reverse ? lang(Yes) : lang(No));
}

/*
 *	q߂
 */
float CTrain::GetLength(){
	return m_TrainPlugin->m_Length;
}

/*
 *	qzu
 */
float CTrain::SetSetBuffer(
	float ofs,						//	ItZbg
	list<CTrainSetBuffer> *buflist	//	Xg
){
	IAxlePosture ia = m_AxleList.begin();
	for(; ia!=m_AxleList.end(); ia++){
		float sumlen = m_Reverse
			? ofs-m_TrainPlugin->m_TailLimit+ia->GetZPos()
			: ofs+m_TrainPlugin->m_FrontLimit-ia->GetZPos();
		ia->m_Rail = NULL;
		ia->m_Distance = -sumlen;
		buflist->push_back(CTrainSetBuffer(sumlen, m_Reverse, &*ia));
	}
	ofs += GetLength();
	m_WarpingOld = false;
	if(m_Next) return m_Next->SetSetBuffer(ofs, buflist);
	else return ofs;
}

/*
 *	V[擾
 */
CScene *CTrain::GetScene(){
	if(m_Warping || !m_AxleList.size()) return NULL;
	CRailWay *rail = m_AxleList.begin()->m_Rail;
	return rail ? rail->GetScene() : NULL;
}

/*
 *	V[`FbN
 */
bool CTrain::CheckScene(){
	CScene *scene = GetScene();
	if(scene){
		scene->SetSeason();
		if(scene!=g_Scene) return false;
	}
	return true;
}

/*
 *	ԎKp
 */
void CTrain::ApplyAxle(
	bool sim	//	V~[VtO
){
	IAxlePosture ia = m_AxleList.begin();
	bool oldwarp = m_WarpingOld;
	if(sim){
		m_OldPos[1] = m_OldPos[0];
		m_OldPos[0] = m_Pos;
		m_WarpingOld = m_Warping;
	}
	if(m_AxleList.size()){
		IAxlePosture ia2 = --m_AxleList.end();
		m_Pos = 0.5f*(ia->m_Pos+ia2->m_Pos);
		m_Dir = ia->m_Dir+ia2->m_Dir;
		m_Up = ia->m_Up+ia2->m_Up;
		V3NormAxis(&m_Right, &m_Up, &m_Dir);
		if(sim){
			if(oldwarp){
				ResetTilt();
			}else{
				float tiltspeed = m_TrainPlugin->m_TiltSpeed;
				m_TiltDir = (1.0f-tiltspeed)*m_TiltDir
					+tiltspeed*((m_OldPos[0]-m_OldPos[1])-(m_OldPos[1]-m_Pos));
			}
		}
		CBodyObject::SetTiltDir(m_TiltDir);
	}
	for(; ia!=m_AxleList.end(); ia++) ia->Apply();
}

/*
 *	UqZbg
 */
void CTrain::ResetTilt(){
	m_OldPos[0] = m_OldPos[1] = m_Pos;
	m_TiltDir = V3ZERO;
}

/*
 *	x\
 */
void CTrain::PrintInfo(){
	m_Group->PrintInfo();
}

/*
 *	x
 */
CModelInst *CTrain::Control(){
	return m_Group->Control(this);
}

/*
 *	^]Ȏ_ݒ
 */
void CTrain::SetCabinView(
	bool rev,	//	ttO
	VEC3 pos,	//	WItZbg
	VEC3 dir	//	ItZbg
){
	if(m_Warping) return;
	if(GetScene()!=g_Scene){
		CCamera cam = *CCamera::GetCurrentCamera();
		g_Scene = GetScene();
		*g_Scene->GetCamera() = cam;
		g_Scene->Enter(true);
		*g_Scene->GetCamera() = cam;
	}
	if(m_Reverse) rev = !rev;
	VEC3 vpos, vright, vup, vdir;
	CObjectJoint3D *joint = rev ? &m_TrainPlugin->m_TailCabin : &m_TrainPlugin->m_FrontCabin;
	if(joint->IsLinked()){
	//	m_TrainPlugin->SetSwitch(this);
	//	m_TrainPlugin->SetPartsInst(this);
	//	ApplyAxle(false);
		m_TrainPlugin->SetPartsInst(this);
		m_TrainPlugin->AttachPartsObject();
		vpos = joint->GetPos();
		vup = joint->GetUp();
		vdir = joint->GetDir();
	}else{
		vpos = GetPos()+(rev ? -0.5f : 0.5f)*GetDir()*m_TrainPlugin->m_Length;
		vup = GetUp();
		vdir = rev ? -GetDir() : GetDir();
	}
	V3NormAxis(&vright, &vup, &vdir);
	vpos += V3LocalToWorld(&pos, &vright, &vup, &vdir);
	SetView(vpos, vpos+V3LocalToWorld(&dir, &vright, &vup, &vdir), vup);
}

/*
 *	̓`FbN
 */
void CTrain::ScanInput(
	int mode,		//	[h (0: link)
	VEC3 &rect1,	//	̈n_
	VEC3 &rect2		//	̈I_
){
	if(!CheckScene()) return;
	ms_CurrentInst = this;
	m_TrainPlugin->SetSwitch(this);
	m_TrainPlugin->SetPartsInst(this);
	ApplyAxle(false);
	m_TrainPlugin->SetPartsInst(this);	//	ZbgvI
	m_TrainPlugin->ScanInput(this);
}

/*
 *	_O
 */
void CTrain::Render(){
	if(!CheckScene() || m_Warping) return;
	m_TrainPlugin->SetSwitch(this);
	m_TrainPlugin->SetPartsInst(this);
//	ApplyAxle(false);					//	ApplyAxle svH
//	m_TrainPlugin->SetPartsInst(this);	//	ZbgvI
	m_TrainPlugin->Render(this);
	if(g_MapDrawNeeded){
		float front, tail;
		if(m_Reverse){
			front = m_TrainPlugin->m_TailLimit;
			tail = m_TrainPlugin->m_FrontLimit;
		}else{
			front = m_TrainPlugin->m_FrontLimit;
			tail = m_TrainPlugin->m_TailLimit;
		}
		RailMapLine(m_Pos+front*m_Dir, 0xffff0000,
			m_Pos+tail*m_Dir, 0xffff0000, true, true);
	}
}

/*
 *	V~[gis
 */
void CTrain::SimulateModelInst(){
	CheckScene();
	if(m_Warping) StopSound();
	m_TrainPlugin->SetSwitch(this);
	m_TrainPlugin->SetPartsInst(this);
	ApplyAxle(true);
//	m_TrainPlugin->SetPartsInst(this);	//	CAxlePosture ͏ςȂ̂ŃZbg͕sv
	m_TrainPlugin->Simulate(this);
}

/*
 *	Ǎ
 */
char *CTrain::Read(
	char *str,		//	Ώە
	CTrain ***root	//	i[
){
	char *eee;
	if(!(str = BeginBlock(str, "Train"))){
		delete this;
		return NULL;
	}
	string pid;
	if(!(str = AsgnString(eee = str, "TrainPlugin", &pid))) throw CSynErr(eee);
	m_ModelPlugin = m_TrainPlugin = g_TrainPluginList->FindPlugin(pid.c_str(), true);
	if(m_TrainPlugin) m_TrainPlugin->SetAxleList(this);
	if(!(str = ReadModelInst(eee = str, true))) throw CSynErr(eee);
	if(!(str = AsgnYesNo(eee = str, "Reverse", &m_Reverse))) throw CSynErr(eee);
	if(!(str = Assignment(eee = str, "Warping"))) throw CSynErr(eee);
	if(!(str = BoolYesNo(eee = str, &m_Warping))) throw CSynErr(eee);
	if(!(str = Character2(eee = str, ','))) throw CSynErr(eee);
	if(!(str = BoolYesNo(eee = str, &m_WarpingOld))) throw CSynErr(eee);
	if(!(str = Character2(eee = str, ';'))) throw CSynErr(eee);
	if(!(str = AsgnVector3D(eee = str, "OldPos", m_OldPos, 2, false))) throw CSynErr(eee);
	if(!(str = AsgnVector3D(eee = str, "TiltDir", &m_TiltDir))) throw CSynErr(eee);
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	**root = this;
	*root = &m_Next;
	return str;
}

/*
 *	ۑ
 */
void CTrain::Save(
	FILE *df	//	t@C
){
	fprintf(df, "\t\tTrain{\n");
	fprintf(df, "\t\t\tTrainPlugin = \"%s\";\n", CheckPluginID(m_TrainPlugin));
	SaveModelInst(df, "\t\t\t", true);
	fprintf(df, "\t\t\tReverse = %s;\n", YESNO[m_Reverse]);
	fprintf(df, "\t\t\tWarping = %s, %s;\n", YESNO[m_Warping], YESNO[m_WarpingOld]);
	fprintf(df, "\t\t\tOldPos = ");
	V3Save(df, m_OldPos[0], ", "); V3Save(df, m_OldPos[1], ";\n");
	fprintf(df, "\t\t\tTiltDir = ");
	V3Save(df, m_TiltDir, ";\n");
	fprintf(df, "\t\t}\n");
}
