#include "stdafx.h"
#include "CRailPlugin.h"
#include "CTiePlugin.h"
#include "CTieSelectMode.h"

/*
 *	[h
 */
bool CTiePlugin::Load(){
	char *str = m_Script, *tmp, *eee;
	if(!ChDir() || !m_Script) return false;
	try{
		if(!(str = BeginBlock(eee = str, "TieInfo"))) throw CSynErr(eee);
		if(!(str = AsgnFloat(eee = str, "Height", &m_Height))) throw CSynErr(eee);
		if(tmp = AsgnYesNo(eee = str, "FlattenCant", &m_FlattenCant)) str = tmp;
		else m_FlattenCant = false;
		if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);

		if(!(str = ReadProfile(eee = str))) throw CSynErr(eee);

		if(*(eee = str)) throw CSynErr(eee);
	}
	catch(CSynErr err){
		HandleError(&err);
		return false;
	}
	LoadData();
	DELETE_A(m_Buffer);
	return true;
}

/*
 *	vr[ݒ
 */
void CTiePlugin::SetPreview(){
	ms_PreviewState = true;
	g_Tie = this;
	string desc = g_Tie->GetBasicInfo();
	desc += "\n"+g_Tie->GetDescription();
	g_TieSelectMode->SetProperty((char *)desc.c_str());
}

/*
 *	_v㏈
 */
void CTiePlugin::AfterDump(
	VEC3 &p1, VEC3 &u1,		//	n_ (K)
	VEC3 &ip1, VEC3 &iu1,	//	Jgn_ (K)
	VEC3 &p2, VEC3 &u2,		//	I_ (K)
	VEC3 &ip2, VEC3 &iu2	//	JgI_ (K)
){
	ip1 -= m_Height*iu1;
	ip2 -= m_Height*iu2;
	if(m_FlattenCant){
		p1 = ip1; u1 = iu1;
		p2 = ip2; u2 = iu2;
	}else{
		p1 -= m_Height*u1;
		p2 -= m_Height*u2;
	}
}

/*
 *	rݒuʒuvZ
 */
void CTiePlugin::CalcPierPos(
	VEC3 *pos,		//	ʒu
	VEC3 *right,	//	right (K)
	VEC3 *up,		//	up (K)
	VEC3 *dir		//	dir (K)
){
	if(m_FlattenCant){
		right->y = 0.0f;
		V3Norm(up, V3Cross(up, dir, V3Norm(right, right)));
	}
	*pos -= *up*m_Height;
}
