#ifndef CSTATION_H_INCLUDED
#define CSTATION_H_INCLUDED

#include "CStruct.h"
#include "CDiaInst.h"

class CStationPlugin;
class CStation;
class CRailWay;

/*
 *	vbgtH[CX^X
 */
class CPlatformInst{
private:
	float m_Length;					//	
	bool m_Stoppable;				//	ԉ\ /*CP932Ή*/
	bool m_OpenDoor[2];				//	hAJ
	CStation *m_Station;			//	w
	list<CRailWay *> m_RailList;	//	[Xg
public:
	CPlatformInst(CStation *);
	CPlatformInst(CStation *, bool, bool *);
	void AddRailWay(CRailWay *way){ m_RailList.push_back(way); }
	CRailWay *GetRailWayFront(){ return m_RailList.size() ? m_RailList.front() : NULL; }
	CRailWay *GetRailWayBack(){ return m_RailList.size() ? m_RailList.back() : NULL; }
	void DeleteRailWay(CRailWay *);
	void DeletePlatform();
	void SetPlatformParent(CDetectInfo *);
	float GetLength();
	int GetPlatformState();
	bool IsStoppable(){ return m_Stoppable; }
	bool GetOpenDoor(int s){ return m_OpenDoor[s]; }
	CStation *GetStation(){ return m_Station; }
	void Simulate();
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	q
typedef list<CPlatformInst>::iterator IPlatformInst;

/*
 *	{݃CX^X
 */
class CStation: public CStruct{
protected:
	static CStation **ms_Root;					//	ڑ[g
	CDiaInst m_DiaInst;							//	_Cݒ
	list<CPlatformInst> m_PlatformList;			//	vbgtH[Xg
	vector<CPlatformInst *> m_PlatformArray;	//	vbgtH[Xg
	CStationPlugin *m_StationPlugin;			//	{݃vOC
	CStation *m_Next;							//	
public:
	static void SetRoot(CStation **r){ ms_Root = r; }
	CStation();
	CStation(CStationPlugin *);
	CStation(CStationPlugin *, VEC3, VEC3, VEC3);
	~CStation();
	CPlatformInst *PushPlatformInst(CPlatformInst &);
	void MakePlatformArray();
	int GetPlatformCount(){ return m_PlatformArray.size(); }
	CPlatformInst *GetPlatformInst(int i){ return m_PlatformArray[i]; }
	bool IsSelectVisible();
	void Remove();
	void Delete();
	void DeleteGroup(CTrainGroup *g){ m_DiaInst.DeleteGroup(g); }
	virtual CModelInst *Control();
	virtual void SimulateStruct();
	virtual void SetSwitchStruct();
	bool IsStoppable();
	CDiaInst *GetDiaInst(){ return &m_DiaInst; }
	CMODELINST_CASTFUNC(CStation);
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	OO[o
extern CPlatformInst *g_PlatformInst;

#endif
