#ifndef CRAILWAYMODE_H_INCLUDED
#define CRAILWAYMODE_H_INCLUDED

#include "CWindowCtrl.h"
#include "CPushButton.h"
#include "CCheckBox.h"
#include "CStaticCtrl.h"
#include "CEditCtrl.h"
#include "CCamera.h"

class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;
class CPierPlugin;
class CLinePlugin;
class CPolePlugin;
class CRailBuilder;

/*
 *	H֌W[h{NX
 */
class CRailwayMode{
protected:
	static int ms_CurrentType;				//	[h^Cv
	static int ms_WindowPos[][2];			//	EBhEW
	static int ms_TrackNum;					//	
	static float ms_TrackInterval;			//	Ԋu
	static CWindowCtrl ms_RailWindow;		//	Hݒ葋
	static CPushButton ms_PluginSetButton;	//	vOCZbg{^
	static CStaticCtrl ms_TypeLabel;		//	ރx
	static CCheckBox ms_Type[];				//	ރ`FbN
	static CCheckBox ms_EnableCant;			//	Jg`FbN
	static CCheckBox ms_LiftRailSurface;	//	x␳`FbN
	static CStaticCtrl ms_MultiTrackLabel;	//	x
	static CCheckBox ms_MultiTrackCheck;	//	`FbN
	static CStaticCtrl ms_TrackNumLabel;	//	Ox
	static CEditCtrl ms_TrackNumEdit;		//	O
	static CStaticCtrl ms_TrackIntLabel;	//	OԊux
	static CEditCtrl ms_TrackIntEdit;		//	OԊu
	static CCamera ms_RailwayModeCamera;	//	J
public:
	static void InitRailwayInterface();
	static void GetPlugin(CRailPlugin **, CTiePlugin **,
		CGirderPlugin **, CPierPlugin **, CLinePlugin **, CPolePlugin **);
	static void SetRailwayOption(
		bool, bool, bool, bool, bool, bool, bool, bool, bool, int, float);
	static bool IsMultiTrack(){ return !!ms_MultiTrackCheck.GetCheck(); }
	static bool IsCantEnabled(){ return !!ms_EnableCant.GetCheck(); }
	static bool IsLiftRail(){ return !!ms_LiftRailSurface.GetCheck(); }
	static int GetTrackNum(){
		int ret; sscanf(ms_TrackNumEdit.GetText(), "%d", &ret);
		ValueArea(&ret, 1, 100); return ret;
	}
	static float GetTrackInterval(){
		float ret; sscanf(ms_TrackIntEdit.GetText(), "%f", &ret);
		ValueArea(&ret, 0.01f, 100.0f); return Round(ret*100.0f)*0.01f;
	}
	static char *LoadRailwaySetting(char *);
	static void SaveRailwaySetting(FILE *);
	static void EnterRailway(int);
	static void ScanInputRailway();
	static void ReformEditValue();
};

#endif
