#ifndef CPOLEPLUGIN_H_INCLUDED
#define CPOLEPLUGIN_H_INCLUDED

#include "CPlugin.h"

/*
 *	ːvOC
 */
class CPolePlugin: public CPlugin{
	friend class CPole;
private:
	static CObject ms_PreviewObject;	//	vr[pIuWFNg
	int m_TrackNum;			//	O
	float m_TrackInterval;	//	OԊu
	float m_ModelScale;		//	fXP[
	string m_ModelFileName;	//	ft@C
	CMesh *m_Mesh;			//	bV
public:
	CPolePlugin(char *id): CPlugin(id){}
	~CPolePlugin(){}
	char *DirName(){ return "Pole"; }
	char *TextName2(){ return "Pole2.txt"; }
	bool IsMultiTrack(){ return m_TrackNum>1; }
	int ConfirmMultiTrack(int tn, float ti){
		return tn!=m_TrackNum ? 1 : (tn>1 && ti!=m_TrackInterval ? 2 : 0);
	}
	int GetTrackNum(){ return m_TrackNum; }
	float GetTrackInterval(){ return m_TrackInterval; }
	bool Load();
	void SetPreview();
	void Preview(VEC3);
	CPLUGIN_CASTFUNC(CPolePlugin);
};

/*
 *	ːvOCXg
 */
class CPolePluginList: public CPluginList{
private:
public:
	char *DirName(){ return "Pole"; }
	char *TextName2(){ return "Pole2.txt"; }
	char *Default(){ return "Default_JRS_Single"; }
	CPlugin *NewEntry(char *id){ return new CPolePlugin(id); }
	CPLUGINLIST_CASTFUNC(CPolePlugin);
};

//	OO[o
extern CPolePlugin *g_Pole;
extern CPolePluginList *g_PolePluginList;

#endif
