#ifndef CENVPLUGIN_H_INCLUDED
#define CENVPLUGIN_H_INCLUDED

#include "CPlugin.h"
#include "CLensFlare.h"

/*
 *	CgZbeBO
 */
class CLightSetting{
	friend class CEnvPlugin;
private:
	float m_SunAlt;			//	zx
	D3DCOLOR m_Directional;	//	sF
	D3DCOLOR m_Ambient;		//	F
	D3DCOLOR m_SkyColor;	//	̐F
public:
	char *Read(char *);
	bool operator<(const CLightSetting &rhs){
		return m_SunAlt<rhs.m_SunAlt;
	}
};

//	q
typedef list<CLightSetting>::iterator ILightSetting;

/*
 *	qf[^
 */
class CMoon{
	friend class CEnvPlugin;
private:
	string m_MoonFile;			//	t@C
	CMesh *m_MoonMesh;			//	bV
	CObject m_MoonObject;		//	IuWFNg
	float m_MoonScale;			//	XP[
	float m_AxialInclination;	//	]̌X
	float m_RevolutionPeriod;	//	]
	float m_InitialPhase;		//	ʑ
	float m_RevolutionPerDay;	//	1 ]px
public:
	char *Read(char *);
	void LoadData();
	void Render(double, float, VEC3, float);
};

//	q
typedef list<CMoon>::iterator IMoon;

/*
 *	vOC
 */
class CEnvPlugin: public CPlugin{
private:
	float m_Latitude;				//	ܓx
	string m_EnvMapTexFile;			//	}bvt@C
	LPTEX8 m_EnvMapTexture;			//	}bsO
	string m_LandscapeFile;			//	iσt@C
	CMesh *m_LandscapeMesh;			//	iσbV
	CObject m_LandscapeObject;		//	iσIuWFNg
	float m_LandscapeScale;			//	iσXP[
	string m_SunFile;				//	iσt@C
	CMesh *m_SunMesh;				//	iσbV
	CObject m_SunObject;			//	iσIuWFNg
	float m_SunScale;				//	iσXP[
	float m_SunAxialInclination;	//	ňX
	CLensFlare m_SunLensFlare;		//	zYtA
	CWhiteout m_SunWhiteout;		//	zzCgAEg
	float m_NightThreshold;			//	臒l
	D3DCOLOR m_ShadowColor;			//	e̐F
	list<CLightSetting> m_Light;	//	ݒ
	list<CMoon> m_Moon;				//	Xg
public:
	CEnvPlugin(char *id): CPlugin(id){}
	~CEnvPlugin(){}
	char *DirName(){ return "Env"; }
	char *TextName2(){ return "Env2.txt"; }
	bool Load();
	bool GetHemisphere(){ return m_Latitude<0.0f; }
	void SetPreview();
	void SetEnvMapTexture(){ devSetTexture(1, m_EnvMapTexture); }
	void Render(double abstime = -1.0);
	void RenderAfter();
	D3DCOLOR GetShadowColor(){ return m_ShadowColor; }
	CPLUGIN_CASTFUNC(CEnvPlugin);
};

/*
 *	vOCXg
 */
class CEnvPluginList: public CPluginList{
private:
public:
	char *DirName(){ return "Env"; }
	char *TextName2(){ return "Env2.txt"; }
	char *Default(){ return "Default"; }
	CPlugin *NewEntry(char *id){ return new CEnvPlugin(id); }
	CPLUGINLIST_CASTFUNC(CEnvPlugin);
};

//	OO[o
extern float g_DayAlpha;
extern float g_NightAlpha;
extern D3DCOLOR g_NoLightColor;
extern CEnvPlugin *g_Env;
extern CEnvPlugin *g_DefaultEnv;
extern CEnvPluginList *g_EnvPluginList;

#endif
