#ifndef CDIAINST_H_INCLUDED
#define CDIAINST_H_INCLUDED

class CListElement;
class CListView;
class CTrainGroup;

/*
 *	_Cvf{NX
 */
class CDiaElementBase{
	friend class CDiaDialogBase;
	friend class CDiaListBase;
protected:
	CListElement *m_ListElement;	//	Xgvf
public:
	CDiaElementBase();
	virtual ~CDiaElementBase(){}
	void UpdateCaption();
	virtual string GetListCaption() = 0;
	virtual char *Label() = 0;
	virtual char *Read(char *) = 0;
	virtual void Save(FILE *, char *) = 0;
};

//	q
typedef list<CDiaElementBase *>::iterator IPDiaElementBase;

/*
 *	_CXg{NX
 */
class CDiaListBase{
	friend class CDiaDialogBase;
	friend class CDiaInstBase;
protected:
	bool m_UseDefault;					//	ftHgݒgp
	list<CDiaElementBase *> m_DiaList;	//	_CXg
public:
	CDiaListBase();
	virtual ~CDiaListBase(){}
	void Free();
	int Size(){ return m_DiaList.size(); }
	void ListElement(CListView *, int);
	int AddElement(CDiaElementBase *);
	int DeleteElement(CDiaElementBase *);
	void RotateElement(bool);
	CDiaElementBase *DequeueBase(bool);
	virtual CDiaElementBase *NewEntry() = 0;
	virtual char *Label() = 0;
	char *Read(char *, CTrainGroup **);
	void Save(FILE *, char *, CTrainGroup *);
};

//	q
typedef map<CTrainGroup *, CDiaListBase *>::iterator IPDiaListBase;

/*
 *	_C֘ACX^X{NX
 */
class CDiaInstBase{
	friend class CDiaDialogBase;
protected:
	string m_Name;									//	
	map<CTrainGroup *, CDiaListBase *> m_DiaMap;	//	_C}bv
public:
	virtual ~CDiaInstBase();
	bool IsInside(CTrainGroup *group){ return !!m_DiaMap.count(group); }
	bool IsDefault(CTrainGroup *group){
		return m_DiaMap.count(group) ? m_DiaMap[group]->m_UseDefault : true;
	}
	CDiaListBase *Search(CTrainGroup *);
	CDiaListBase *SearchEffectBase(CTrainGroup *);
	CDiaElementBase *DequeueBase(CTrainGroup *g){ return SearchEffectBase(g)->DequeueBase(true); }
	void DeleteGroup(CTrainGroup *g){ m_DiaMap.erase(g); }
	virtual CDiaListBase *NewEntry() = 0;
	virtual char *Label() = 0;
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *, char *);
};

#define CDIAINSTBASE_CASTFUNC(el, li) \
	li *SearchEffect(CTrainGroup *g){ return (li *)SearchEffectBase(g); } \
	el *Dequeue(CTrainGroup *g){ return (el *)DequeueBase(g); }

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	|Cgؑ֗vf
 */
class CPointElement: public CDiaElementBase{
	friend class CPointDialog;
private:
	int m_PointSwitch;
public:
	CPointElement();
	string GetListCaption();
	int GetValue(){ return m_PointSwitch; }
	void SetValue(int p){ m_PointSwitch = p; }
	int CalcPoint();
	char *Label(){ return "PointElement"; }
	char *Read(char *);
	void Save(FILE *, char *);
};

/*
 *	|Cgؑ֗vfXg
 */
class CPointList: public CDiaListBase{
private:
public:
	virtual CDiaElementBase *NewEntry(){ return new CPointElement; }
	char *Label(){ return "PointList"; }
};

/*
 *	|Cgؑփ}bv
 */
class CPointInst: public CDiaInstBase{
private:
public:
	virtual CDiaListBase *NewEntry(){ return new CPointList; }
	char *Label(){ return "PointInst"; }
	CDIAINSTBASE_CASTFUNC(CPointElement, CPointList);
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	_Cݒvf
 */
class CDiaElement: public CDiaElementBase{
	friend class CDiaDialog;
	friend class CTrainGroup;
private:
	int m_Action;	//	
	int m_TimeType;	//	Ԑݒ
	int m_Hour;		//	
	int m_Minute;	//	
	int m_Second;	//	b
//	int m_Joint;	//	A󂯓
	float m_Offset;	//	Ԉʒu
public:
	CDiaElement();
	string GetListCaption();
	double GetTime(){ return (m_Hour+(m_Minute+m_Second/60.0)/60.0)/24.0; }
	char *Label(){ return "DiaElement"; }
	char *Read(char *);
	void Save(FILE *, char *);
};

/*
 *	_CݒvfXg
 */
class CDiaList: public CDiaListBase{
private:
public:
	virtual CDiaElementBase *NewEntry(){ return new CDiaElement; }
	char *Label(){ return "DiaList"; }
};

/*
 *	_Cݒ}bv
 */
class CDiaInst: public CDiaInstBase{
private:
public:
	virtual CDiaListBase *NewEntry(){ return new CDiaList; }
	char *Label(){ return "DiaInst"; }
	CDIAINSTBASE_CASTFUNC(CDiaElement, CDiaList);
};

//	OO[o
extern char *g_DiaDefaultString[];

#endif
