//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "graphic.h"
#include "vertex.h"
#include "draw.h"
#include "texture.h"

//	O[o
CTexList g_TexList;		//	eNX`Xg

/*
 *	RXgN^
 */
CTexture::CTexture(){
	m_pTex = NULL;
	m_fCreate = FALSE;
}

/*
 *	fXgN^
 */
CTexture::~CTexture(){
	Free();
}

/*
 *	Ǎ
 *
 *	strFile	: t@CiBMP, PNGȂǁj
 *	cTrans	: ߐF
 *	nMipLv	: ~bv}bvku
 */
BOOL CTexture::Load(LPCSTR strFile, D3DCOLOR cTrans, int nMipLv){
	Free();	//	Ȃ
	if(!(m_pTex = g_TexList.Get(FALSE, strFile, cTrans, nMipLv))) return FALSE;
	m_pTex->GetLevelDesc(0, &m_desc);
	return TRUE;
}
//	\[Xirbg}bv̂݁j
BOOL CTexture::LoadResource(LPCSTR strRes, D3DCOLOR cTrans, int nMipLv){
	Free();	//	Ȃ
	if(!(m_pTex = g_TexList.Get(TRUE, strRes, cTrans, nMipLv))) return FALSE;
	m_pTex->GetLevelDesc(0, &m_desc);
	return TRUE;
}

/*
 *	
 */
void CTexture::Free(){
	if(!m_pTex) return;
	if(m_fCreate){
		RELEASE(m_pTex);
	}else{
		m_fCreate = FALSE;
		g_TexList.Release(m_pTex);
		m_pTex = NULL;
	}
}

/*
 *	eNX`̍쐬
 */
BOOL CTexture::Create(int w, int h){
	Free();	//	Ȃ
	m_fCreate = TRUE;

	//	eNX`̍쐬
	HRESULT hr;
	int texW = (int)pow(2, ceil(log(w)/log(2)));
	int texH = (int)pow(2, ceil(log(h)/log(2)));

	hr = sv3.pDev->CreateTexture(
		texW, texH, 1, 0, D3DFMT_A4R4G4B4,
		D3DPOOL_MANAGED, &m_pTex);
	if(FAILED(hr)) goto error;

	m_pTex->GetLevelDesc(0, &m_desc);	//	ۂ̃eNX`TCY擾
#if 0
	Debug("Allocated Texture %d x %d.\n", m_desc.Width, m_desc.Height);
#endif

error:
	return SUCCEEDED(hr);
}

/*
 *	
 *
 *	str		: iTABj
 *	font	: tHgnh
 */
BOOL CTexture::DrawInText(int x, int y, LPCSTR str,
	HFONT hFont, D3DCOLOR col, D3DCOLOR sdw, int w, int h){
	if(!m_pTex) return FALSE;

	HDC hDC = CreateCompatibleDC(NULL);

	HFONT hOldFont = (HFONT)SelectObject(hDC, hFont);

	SetMapMode(hDC, MM_TEXT);
	SetBkMode(hDC, TRANSPARENT);
	SetTextColor(hDC, 0x00ffffff);

	if(w<0){
		//	`̈̎擾
		RECT drawRect = {0, 0, 1, 1};

		DrawText(hDC, str, -1, &drawRect, DT_CALCRECT|DT_LEFT|DT_EXPANDTABS|DT_NOPREFIX);

		w = drawRect.right;
		h = drawRect.bottom;
	}

	//	DIB̍쐬
	BITMAPINFO bmi;

	ZeroMemory(&bmi.bmiHeader, sizeof(BITMAPINFOHEADER));
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = w;
	bmi.bmiHeader.biHeight = -h;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biCompression = BI_RGB;
	bmi.bmiHeader.biBitCount = 32;

	BYTE *pDIB;
	DWORD dibSize = 4*w*h;
	RECT rect = {0, 0, w, h};

	HBITMAP hBM = CreateDIBSection(
		hDC, &bmi, DIB_RGB_COLORS,
		(VOID **)&pDIB, NULL, 0);
	if(!pDIB) return FALSE;

	//	DIBɕ`
	HBITMAP hOldBM = (HBITMAP)SelectObject(hDC, hBM);
	memset(pDIB, 0, dibSize);
	DrawText(hDC, str, -1, &rect, DT_LEFT|DT_EXPANDTABS|DT_NOCLIP|DT_NOPREFIX);

	//	DIB(32bit)eNX`(16bit)֓]
	D3DLOCKED_RECT lockRect;

	HRESULT hr = m_pTex->LockRect(0, &lockRect, NULL, 0);	//	bN

	if(SUCCEEDED(hr)){
		int i, j;
		BYTE a = (col&0xff000000)>>24;
		BYTE r = (col&0x00ff0000)>>16;
		BYTE g = (col&0x0000ff00)>>8;
		BYTE b = col&0x000000ff;
		WORD color = ((a&0xf0)<<8)|((r&0xf0)<<4)|(g&0xf0)|((b&0xf0)>>4);	//	16bit

		WORD *pDst, *pSdw, *pSdw2 /* , *pSdw3 */ ;
		DWORD *pSrc = (DWORD *)pDIB;

		int cx = 0, cy = 0;
		if(x<0){ cx = -x; x = 0; }
		if(y<0){ cy = -y; y = 0; }
		int cw = w-cx, ch = h-cy;
		if(x+cw>m_desc.Width) cw = m_desc.Width-x;
		if(y+ch>m_desc.Height) ch = m_desc.Height-y;

		if(sdw){
			a = (sdw&0xff000000)>>24;
			r = (sdw&0x00ff0000)>>16;
			g = (sdw&0x0000ff00)>>8;
			b = sdw&0x000000ff;
			WORD shadow = ((a&0xf0)<<8)|((r&0xf0)<<4)|(g&0xf0)|((b&0xf0)>>4);	//	16bit
			for(i = 0; i<ch; i++){
				pDst = (WORD *)lockRect.pBits+(lockRect.Pitch/2)*(y+i)+x;
				pSdw = (WORD *)lockRect.pBits+(lockRect.Pitch/2)*(y+i+1)+x+1;
				pSdw2 = pSdw-1;
				//pSdw3 = pDst+1;
				pSrc = (DWORD *)pDIB+w*(i+cy)+cx;
				if(i){
					*pDst = 0x00000000;
				}else{
					WORD *tmp = pDst;
					for(j = 0; j<=cw; j++) *tmp++ = 0x00000000;
				}
				for(int j = 0; j<cw; j++){
					if(*pSrc){
						*pDst = color; *pSdw = *pSdw2 = /* *pSdw3 = */ shadow;
					}else{
						*pSdw = /* *pSdw2 = *pSdw3 = */ 0x00000000;
					}
					pDst++; pSdw++; pSdw2++; /* pSdw3++; */ pSrc++;
				}
			}
		}else{
			for(i = 0; i<ch; i++){
				pDst = (WORD *)lockRect.pBits+(lockRect.Pitch/2)*(y+i)+x;
				pSrc = (DWORD *)pDIB+w*(i+cy)+cx;
				for(j = 0; j<cw; j++){
					*pDst = *pSrc ? color : 0x00000000;
					pDst++; pSrc++;
				}
			}
		}
		m_pTex->UnlockRect(0);	//	bN
	}
	//	n
	SelectObject(hDC, hOldBM);
	SelectObject(hDC, hOldFont);
	DeleteObject(hBM);
	DeleteDC(hDC);

	return TRUE;
}

/*
 *	2D摜Ƃă_O
 *
 *	x, y	: `ʒu
 *	XVfoCXp[^	: eNX`
 *
 *	OɃCeBOOFFɂ邱ƁB
 */
void CTexture::Render(int x, int y){
	if(m_pTex){
		devSetTexture(0, m_pTex);
		TexMap2DRect(x, y, x+m_desc.Width, y+m_desc.Height);
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	RXgN^
 *
 *	CMeshNXRelease()Ă΂̂ŃfXgN^͕sv
 */
CTexList::CTexList(){
	m_pList = NULL;
}
/*
 *	fXgN^
 */
CTexList::~CTexList(){
	while(m_pList) Release(m_pList->pTex);
}

/*
 *	eNX`Xg猟AȂ΃[h
 */
LPTEX8 CTexList::Get(BOOL fRes, LPCSTR strName, D3DCOLOR cTrans, int nMipLv){
	//	XgeNX`[
	TEXINFO *p = m_pList;

	//	t@CȂtpXɕϊ
	char full[_MAX_PATH];
	if(!fRes){
		_fullpath(full, strName, _MAX_PATH);
		strName = full;
	}

	if(!cTrans) cTrans = CheckTexTrans(strName);

	while(p){
		//	ΎQƃJE^𑝂₵AeNX`Ԃ
		if(!_mbsicmp((PUCHAR)p->strName.c_str(), (PUCHAR)strName)
			&& p->cTrans==cTrans && p->nMipLv==nMipLv){
			//	Debug("[%s] is in texture-list.\n", strName); /*fobO*/
			p->nRef++;
			return p->pTex;
		}
		p = p->pNext;
	}
	//	Ȃ΃[h
	Debug("load(%s) ... ", strName);

	p = new TEXINFO;
	p->pTex = NULL;

	if(fRes ? FAILED(LOAD_TEXTURE_RES(&p->pTex, strName, cTrans, nMipLv))
		: FAILED(LOAD_TEXTURE(&p->pTex, strName, cTrans, nMipLv))){
		Debug("failed.\n");
		return NULL;
	}
	Debug("ok.\n");

	//	Xg̐擪ɒǉAQƃJE^ݒ肷
	TEXINFO *q = m_pList;
	m_pList = p;
	p->pNext = q;
	p->strName = strName;
	p->nRef = 1;
	p->cTrans = cTrans;
	p->nMipLv = nMipLv;

	return p->pTex;
}

/*
 *	\ȂeNX`
 */
void CTexList::Release(LPTEX8 pTex){
	//	eNX`
	TEXINFO *p = m_pList;
	TEXINFO *q = NULL;

	while(p){
		//	ΎQƃJE^炷
		if(p->pTex==pTex){
			p->nRef--;

			//	QƂȂȂ΃eNX`AXgO
			if(p->nRef==0){
				Debug("release(%s)\n", p->strName.c_str());
				RELEASE(p->pTex);

				if(p==m_pList){
					//	Xg̐擪
					m_pList = p->pNext;
					delete p;
				}else{
					//	r
					q->pNext = p->pNext;
					delete p;
				}
			}
			break;
		}
		q = p;
		p = p->pNext;
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	eNX`t@C瓧ߐF߂
 */
D3DCOLOR CheckTexTrans(LPCSTR str){
	char *ptr = (char *)str, *sharp = NULL, *dot = NULL;
	while(*ptr){
		switch(*ptr){
		case '#':
			sharp = ptr;
			break;
		case '.':
			dot = ptr;
			break;
		case '\\':
			sharp = dot = NULL;
			break;
		}
		ptr = CharNext(ptr);
	}
	if(!sharp) return 0x00000000;
	if(!dot || dot<sharp) dot = ptr;
	int len = dot-sharp;
	if(len==2){
		switch(sharp[1]){
		case 'B': case 'b': return 0xff000000;
		case 'W': case 'w': return 0xffffffff;
		}
	}else if(len==9){
		D3DCOLOR trans;
		if(sscanf(sharp+1, "%x", &trans)==1) return trans;
	}
	return 0x00000000;
}

/*
 *	`TCY̌vZ
 */
void CalcTextRect(int *w, int *h, LPCSTR str, HFONT hFont){
	if(!*str){
		*w = *h = 0;
		return;
	}
	HDC hDC = CreateCompatibleDC(NULL);
	HFONT hOldFont = (HFONT)SelectObject(hDC, hFont);
	SetMapMode(hDC, MM_TEXT);
	RECT drawRect = {0, 0, 1, 1};
	DrawText(hDC, str, -1, &drawRect, DT_CALCRECT|DT_LEFT|DT_EXPANDTABS|DT_NOPREFIX);
	*w = drawRect.right;
	*h = drawRect.bottom;
	SelectObject(hDC, hOldFont);
	DeleteDC(hDC);
}
