//	Copyright (c) 2002 Midikyou

class CNamedObject;

/*
 *	X t@C
 */
class CXFile{
	LPDIRECTXFILE			m_pXF;
	LPDIRECTXFILEENUMOBJECT	m_pPtr;

public:
	CXFile();
	~CXFile();
	BOOL Open(LPCSTR strSrc, BOOL fRes = FALSE);
	BOOL GetNextData(LPDIRECTXFILEDATA *ppDat);
	BOOL GetTopMesh(LPDIRECTXFILEDATA *ppDat);
	void Close();
};

class TTMTX{
public:
	float a[6];
	TTMTX(){}
	TTMTX(float a0, float a1, float a2, float a3, float a4, float a5){
		a[0] = a0; a[1] = a1; a[2] = a2; a[3] = a3; a[4] = a4; a[5] = a5;
	}
	MTX4 GetMTX4(){
		return MTX4(
			a[0], a[3], 0.0f, 0.0f,
			a[1], a[4], 0.0f, 0.0f,
			a[2], a[5], 1.0f, 0.0f,
			0.0f, 0.0f, 0.0f, 1.0f);
	}
};

/*
 *	bV
 */
class CMesh{
	LPD3DXMESH m_pMesh;		//	bV{
	DWORD *m_pMatFlag;		//	}eAtO (1: rendered)
	DWORD *m_pMatOrder;		//	}eA
	MAT8 *m_pMat;			//	}eAXg
	MAT8 *m_pCustomMat;		//	փ}eAXg
	LPTEX8 *m_pTex;			//	eNX`Xg
	LPTEX8 *m_pCustomTex;	//	փeNX`Xg
	TTMTX *m_pTexTrans;		//	eNX`ϊXg
	DWORD m_dwNumMat;		//	}eA
	string m_strName;		//	t@C

	//	Rs[RXgN^
	CMesh &operator=(const CMesh &){ return *this; }
public:
	VEC3 m_min;		//	E{bNX
	VEC3 m_max;		//	E{bNX
	VEC3 m_center;	//	E̒S
	float m_radius;	//	E̔a

	CMesh();
	//	CMesh(CMesh& src);
	~CMesh();

	BOOL Load(BOOL fRes, char *strFile, D3DCOLOR cTrans = 0, int nMipLv = 1);
	BOOL CreateSphere(float r, UINT sl, UINT st, D3DCOLORVALUE cv);
	BOOL CreateBox(float x, float y, float z, D3DCOLORVALUE cv);
	BOOL CreateTeapot(D3DCOLORVALUE cv);
	void Free();
	void ComputeBoundary();

	bool CheckMatNum(DWORD i){ return 0<=i && i<m_dwNumMat; }
	void ResetMatFlag(DWORD);
	void MaskMatFlag(DWORD);
	DWORD GetMatFlag(DWORD i){ return m_pMatFlag[i]; }
	void SetMatFlag(DWORD i, DWORD v){ m_pMatFlag[i] |= v; }
	MAT8 GetDefaultMaterial(DWORD i){ return m_pMat[i]; }
	void SetCustomMaterial(DWORD i, MAT8 &mat){ m_pCustomMat[i] = mat; }
	void SetCustomTexture(DWORD i, LPTEX8 tex){ m_pCustomTex[i] = tex; }
	void SetTexTrans(DWORD i, TTMTX &mtx){ m_pTexTrans[i] = mtx; }

	void RenderCustom(MTX4 *pMtx, CNamedObject *nobj);
	void Render(MTX4 *pMtx);
	void RenderAmb(MTX4 *pMtx);
	void RenderT(MTX4 *pMtx, LPTEX8 pTex);
	void RenderA(MTX4 *pMtx, float alpha);
	void RenderAP(MTX4 *pMtx, float aplus);
	void RenderSC(MTX4 *pMtx, MAT8 *pMat);

	/*
	 *	IuWFNg̎擾
	 */
	LPD3DXMESH GetObject(){ return m_pMesh; }
};

//	bVXg̗vf
struct MESHINFO{
	CMesh m_Mesh;
	string strName;
	int nRef;
	D3DCOLOR cTrans;
	int nMipLv;
	MESHINFO *pNext;
};

/*
 *	bVXgENX
 *	EbVdɃ[hȂ悤ɂB
 *	EQƐĎAgpĂȂbVB
 */
class CMeshList{
	MESHINFO *m_pList;	//	Xg̐擪
public:
	CMeshList();
	~CMeshList();
	CMesh *Get(BOOL fRes, LPCSTR strName, D3DCOLOR cTrans = 0, int nMipLv = 1);
	void Release(CMesh *);
};

//	OO[o
extern bool g_RenderBlink;
