//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "frame.h"
#include "graphic.h"
#include "view.h"
#include "render.h"
#include "texture.h"
#include "vertex.h"
#include "draw.h"
#include "effect.h"

//	OO[o
extern int g_DispWidth;
extern int g_DispHeight;

/*
 *	obNobt@̃sNZF擾
 *
 *	x, y	: sNZʒu
 *	߂l: X8R8G8B8tH[}bg̐F
 *
 *	ׂߕpɂɎgpȂ
 */
D3DCOLOR GetPixelColor(int x, int y){
	//	ʊO
	if(x<0 || x>=sv3.width || y<0 || y>=sv3.height)
		return 0;

	//	obNobt@T[tFCX̃Rs[
	LPSURF8		pSrc, pDst;
	D3DFORMAT	fmt = sv3.d3dpp.BackBufferFormat;
	RECT		rect = {x, y, x+3, y+3};
	POINT		point = {0, 0};

	sv3.pDev->GetRenderTarget(&pSrc);
	sv3.pDev->CreateImageSurface(4, 4, fmt, &pDst);
	sv3.pDev->CopyRects(pSrc, &rect, 1, pDst, &point);

	//	T[tFCXbN
	D3DLOCKED_RECT	lrect;
	DWORD			pixel;
	D3DCOLOR		c;

	pDst->LockRect(&lrect, NULL, D3DLOCK_READONLY);
	pixel = *((DWORD *)lrect.pBits);	//	ŏ̃sNZ擾
	c = GetXRGB32(pixel, fmt);	//	X8R8G8B8ɃtH[}bgϊ
	pDst->UnlockRect();

	RELEASE(pSrc);
	RELEASE(pDst);
	return c;
}

/*
 *	YtA`
 *
 *	pos	: ̈ʒu
 *	size	: tATCY
 *	fWhite: zCgAEgON/OFF
 *
 *	XVfoCXp[^F[hϊsAuh[hAeNX`[
 */
void RenderLensFlare(VEC3 pos, float size, BOOL fWhite){
	devBLEND_ADD2();	//	Z[h

	//	̃_O
	//devTransBillboard(pos);
	//TexMap3DRect(VEC3(0, 0, 0), size, size, 0xc0ffe080+(Rand(0x40)<<24));

	VEC3 vLight = pos-GetVPos();		//	Jւ̃xNg
	VEC3 vCamera = GetVDir();			//	J̌
	VEC3 vDist = vLight/5-vCamera*5;	//	tÅԊuiKłj

	//	̓ˊpvZ
	D3DXVec3Normalize(&vCamera, &vCamera);
	D3DXVec3Normalize(&vLight, &vLight);

	float angle = D3DXVec3Dot(&vLight, &vCamera);

	if(angle>0.9f){
		//	tA̕`
		DWORD aplus = (DWORD)(max(0.0f, (angle-0.9f)*FRand2(1400.0f, 2200.0f)))<<24;
		devSetTexture(0, NULL);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DCircle(VEC3(0, 0, 0), size/10, 0x00000000+aplus, 0x00804000+aplus);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DHex( VEC3(0, 0, 0), size/8, 0x00000000+aplus, 0x00806000+aplus);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DCircle(VEC3(0, 0, 0), size/13, 0x00000000+aplus, 0x00001040+aplus);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DCircle(VEC3(0, 0, 0), size/7, 0x00000000+aplus, 0x00006020+aplus);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DCircle(VEC3(0, 0, 0), size/20, 0x00008040+aplus, 0x00000000+aplus);

		pos -= vDist;
		devTransBillboard(pos);
		Fill3DCircle(VEC3(0, 0, 0), size/5, 0x00000000, 0x00002000+aplus);

		devBLEND_ALPHA();	//	[h

		//	zCgAEg
		if(fWhite && angle>0.9f){
			aplus = (DWORD)(max(0.0f, (angle-0.9f)*1000.0f))<<24;
			Fill2DRect(0, 0, g_DispWidth, g_DispHeight, aplus|0x00ffffff);
		}
	}else{
		devBLEND_ALPHA();	//	[h
	}
}
