/**
 * @file    comm.h
 * @brief   UDX extension : Comm - DirectPlay ɂʐM@\񋟂D
 */

/**
 * @mainpage
 *
 * @section s01 ͂߂
 * UDX extension : Comm ́C
 * UDX Library  DirectPlay ɂʐM@\񋟂邽߂
 * UDX gvOŁC
 * comm.h  comm.cpp ̓̃t@Cō\D
 * 
 * @section s02 Kv
 * Comm gp邽߂Ɏ̊KvƂȂD
 * - UDX Library 1.46 final
 * - DirectX 8.0 SDK or later
 *
 * @section s03 ֘Ay[W
 * - @ref p01
 * - @ref p02
 *
 * @section s04 ̑
 * @author  T.Tsuruoka <tsuruoka@macrobilis.com>
 * @since   2004-08-09
 * @version 0.1
 */

/**
 * @page p01 Install
 *
 * @section s11 ̎菇
 * -# UDX Library Ɠ̃fBNg comm.h  comm.cpp zuD
 * -# UDX Library ɑ΂Ď̂悤ɃvOǉD
 *
 * - udx.h
 * @code
 * #include"movie.h"
 * 
 * #include"comm.h"        //  ǉ (UDX extension)
 * 
 * #endif _UDX_H
 * @endcode
 *
 * - sysvalue.h
 * @code
 * SYSVALUE_M svm;     //Music
 * SYSVALUE_V svv;     //Video
 * 
 * SYSVALUE_C svc;     //Comm       ǉ (UDX extension)
 * 
 * CFrame g_frame;
 * @endcode
 *
 * - main.cpp \c CApp::Init 
 * @code
 * #ifndef NO_MOVIE
 *     if(!InitDirectShow())   return FALSE;
 * #endif
 * 
 *     //  ȉ 3 sǉ (UDX extension)
 * #ifndef NO_COMM
 *     if(!InitDirectPlay())   return FALSE;
 * #endif
 * 
 *     InitFrame();        //FPSǗ@\̏
 * @endcode
 *
 * - main.cpp \c CApp::~CApp 
 * @code
 *     //DirectX֘Ả
 * 
 *     //  ȉ 3 sǉ (UDX extension)
 * #ifndef NO_COMM
 *     FreeDirectPlay();
 * #endif
 * 
 * #ifndef NO_MOVIE
 *     FreeDirectShow();
 * #endif
 * @endcode
 */

/**
 * @page p02 How to Use
 *
 * @section s20 ʐM̂߂̃vO쐬̗
 * - @ref s21
 * - @ref s22
 * - @ref s23
 * - @ref s24
 * - @ref s25
 *
 * @section s21 AvP[V GUID ݒ
 * guidgen.exe Ȃǂ GUID 𐶐邱ƂłD
 * @code
 * // AvP[Vʂ邽߂ GUID
 * // {4C7B0386-6137-402e-BB12-84A3FD080481}
 * const GUID g_guidApp = 
 * { 0x4c7b0386, 0x6137, 0x402e, { 0xbb, 0x12, 0x84, 0xa3, 0xfd, 0x8, 0x4, 0x81 } };
 * @endcode
 * 
 * @section s22 ZbVăzXgɂȂ
 * CreateSession() ɂZbVD
 * ZbVvC͎IɃzXgƂȂD
 * CreateSession() găZbV̓IȗD
 * -# GUIDCZbVCzXg̃|[gw肷@
 * @code
 * CreateSession(&g_guidApp, "sample_session", 2501);
 * @endcode
 * -# GUIDCZbV݂̂w肷@
 * @code
 * CreateSession(&g_guidApp, "sample_session", NULL);
 * @endcode
 * zXg̃|[gԍNULLɂƁCIɃ|[gԍ蓖ĂD
 * 
 * @section s23 ZbVɎQ
 * ZbVɎQ邽߂ɂ̓ZbVǗĂzXgɐڑȂ΂ȂȂD
 * ̂߁CZbVɎQvĆC
 * zXg IP AhXƃ|[gԍmĂKvD
 * JoinSession() gāCZbVɎQ̓IȗD
 * -# GUIDCzXg IPCzXg̃|[gԍCgi[J́j|[gԍw肷@
 * @code
 * JoinSession(&g_guidApp, "192.168.1.1", 2501, 2502);
 * @endcode
 * zXg̃|[gԍ CreateSession() Ŏw肵|[gԍƓԍw肵C
 * zXg̃|[gԍƎg|[gԍ͈قȂԍw肵Ȃ΂ȂȂD
 * -# GUIDCg|[gԍ݂̂w肷@
 * @code
 * JoinSession(&g_guidApp, NULL, NULL, 2502);
 * @endcode
 * zXg̏񂪕sĂƂCzXg̏͂邽߂̃_CAO\D
 * "192.168.1.1:2501" ̂悤ɃȒOɃzXg IP AhXC
 * ŘɃzXg̃|[gԍw肷D
 * 
 * @section s24 f[^𑗐M
 * f[^𑗐Mɂ́C SendToAll() gD
 * SendToAll() ͎܂ރZbVɎQĂvCSɃf[^𑗐MD
 * @code
 * struct COMM_INFO    // Mf[^i[\
 * {
 *     ....
 * };
 *     ....
 * COMM_INFO commInfo;
 *     ....
 * SendToAll(&commInfo, sizeof(commInfo));
 * @endcode
 *
 * @section s25 Mp̊֐쐬ēo^
 * Mp̊֐ #PFN_RECEIVE ^̊֐ŁCĂɃf[^͂ƂɌĂ΂D
 * ֐ SetReceiveFunc() gēo^ĂKvD
 * @code 
 * void Receive(RECEIVE_DATA* pData, DWORD dwSize, LPARAM lParam)
 * {
 *     COMM_INFO* pCommInfo = (COMM_INFO*)pData;
 *     ...
 * }
 *     ...
 * SetReceiveFunc(&Receive, NULL);
 * @endcode
 * SetReceiveFunc()  2Ԗڂ̈́C
 * Mp̊֐ 3Ԗڂ̈ \a lParam ƂēnD
 * 
 */

/**
 * @example commtest.cpp
 *
 * @section e01 ͂߂
 * Comm gpvO̗D
 * ̃vO̓[Ji1PCjŁC
 * 2ȏN邱ƂŁCʐM̓mF邱ƂłD
 * 
 * @section e02 g
 * -# vO1ND
 * -# [F1]L[ āCZbV쐬D̃vO̓zXgƂȂD
 * -# vO1ND
 * -# [F2]L[ āCZbVɎQD
 * -# 2vÖ̃EBhEōhbOsȂƁC
 *    Ƃ̃EBhEɃf[^D
 */


#pragma once

#include <dplay8.h>
#pragma comment(lib, "dplayx.lib")

#include <dxerr8.h>
#pragma comment(lib, "dxerr8.lib")

#define MAX_SESSIONNAME 512


typedef BYTE RECEIVE_DATA;

/** 
 * @brief M֐
 * @param pData Mf[^ւ̃|C^
 * @param dwSize Mf[^̃TCYiPʁFBytej
 * @param lParam SetReceiveFunc ֐ɂݒ肳ꂽ 32bitl
 */
typedef void (*PFN_RECEIVE)(RECEIVE_DATA* pData, DWORD dwSize, LPARAM lParam);


/**
 * @brief O[oƂĕێ DirectPlay ֘A̍\
 */
struct SYSVALUE_C
{
	IDirectPlay8Peer*       pDP;
	IDirectPlay8Address*    pDeviceAddress;
	IDirectPlay8Address*    pHostAddress;
	DPNID                   idLocalPlayer;      // g ID
	BOOL                    bHost;              // zXgǂ
	PFN_RECEIVE             pReceiveFunc;       // MƂɌĂ΂֐ւ̃|C^
	LPARAM                  lReceiveParam;      // M֐ɓn32bitl
};

extern SYSVALUE_C svc;  // ̂ sysvalue.h

BOOL InitDirectPlay();
void FreeDirectPlay();

void SetReceiveFunc(PFN_RECEIVE pReceiveFunc, LPARAM lParam);
BOOL CreateSession(const GUID* pguidApp, LPCTSTR lpszSessionName, DWORD dwPort);
BOOL JoinSession(const GUID* pguidApp, LPCTSTR lpszHostIP, DWORD dwHostPort, DWORD dwLocalPort);
BOOL CloseSession();
BOOL EnumHosts(const GUID* pguidApp, LPCTSTR lpszIP);
BOOL SendToAll(const PVOID pData, DWORD dwSize);
BOOL SendTo(DPNID dest, const PVOID pData, DWORD dwSize);
DPNID GetLocalPlayerID();
BOOL IsHost();

