#ifndef CVERTEXDUMP_H_INCLUDED
#define CVERTEXDUMP_H_INCLUDED

#define LINE_DUMP_MAX (sv3.capsMaxPrim/2)	//	_vől
#define QUAD_DUMP_MAX (sv3.capsMaxPrim/6)	//	lp`_vől

/*
 *	fBt[Y|C^
 */
class CDiffusePointer{
private:
	D3DCOLOR *m_Pointer;	//	|C^
	D3DCOLOR m_Default;		//	ftHgl
public:
	CDiffusePointer(D3DCOLOR *p){ m_Default = *(m_Pointer = p); }
	void Restore(){ *m_Pointer = m_Default; }
	void Set(D3DCOLOR c){ *m_Pointer = c; }
};

//	q
typedef list<CDiffusePointer>::iterator IDiffusePointer;

/*
 *	o[ebNX_p
 */
class CVertexDump{
protected:
public:
};

/*
 *	_v (CeBOρEWϊς)
 */
class CLineDumpTL: public CVertexDump{
private:
	int m_LineNum;		//	
	int m_Count;		//	JE^
	VTX_TL *m_Buffer;	//	obt@
	CVertex m_Vertex;	//	o[ebNX
	CLineDumpTL *m_Next;	//	
public:
	CLineDumpTL(int);
	CLineDumpTL(CLineDumpTL *);
	~CLineDumpTL();
	int GetCount(){ return m_Count; }
	void Feed();
	void Add(VEC2, D3DCOLOR, VEC2, D3DCOLOR);
	void Preview(VEC2, D3DCOLOR, VEC2, D3DCOLOR);
	void PrepareVertex();
	void Render(bool drawup);
};

/*
 *	_v (CeBO)
 */
class CLineDumpL: public CVertexDump{
private:
	int m_LineNum;		//	
	int m_Count;		//	JE^
	VTX_L *m_Buffer;	//	obt@
	CVertex m_Vertex;	//	o[ebNX
	CLineDumpL *m_Next;	//	
public:
	CLineDumpL(int);
	CLineDumpL(CLineDumpL *);
	~CLineDumpL();
	int GetCount(){ return m_Count; }
	void Feed();
	void Add(VEC3, D3DCOLOR, VEC3, D3DCOLOR);
	void Preview(VEC3, D3DCOLOR, VEC3, D3DCOLOR);
	void PrepareVertex();
	void Render(bool drawup);
};

/*
 *	_v (CeBO)
 */
class CLineDumpN: public CVertexDump{
private:
	int m_LineNum;		//	
	int m_Count;		//	JE^
	VTX_N *m_Buffer;	//	obt@
	CVertex m_Vertex;	//	o[ebNX
	CLineDumpN *m_Next;	//	
public:
	CLineDumpN(int);
	CLineDumpN(CLineDumpN *);
	~CLineDumpN();
	int GetCount(){ return m_Count; }
	void Feed();
	void Add(VEC3, D3DCOLOR, VEC3, D3DCOLOR);
	void Preview(VEC3, D3DCOLOR, VEC3, D3DCOLOR);
	void PrepareVertex();
	void Render(bool drawup);
};

/*
 *	lp`_v (eNX`Ȃ)
 */
class CQuadDumpN: public CVertexDump{
private:
	int m_QuadNum;		//	lp`
	int m_Count;		//	JE^
	VTX_N *m_Buffer;	//	obt@
	CVertex m_Vertex;	//	o[ebNX
	CQuadDumpN *m_Next;	//	
public:
	CQuadDumpN(int);
	CQuadDumpN(CQuadDumpN *);
	~CQuadDumpN();
	int GetCount(){ return m_Count; }
	void Feed();
	void Add(
		VEC3, VEC3, D3DCOLOR, VEC3, VEC3, D3DCOLOR,
		VEC3, VEC3, D3DCOLOR, VEC3, VEC3, D3DCOLOR);
	void Preview(
		VEC3, VEC3, D3DCOLOR, VEC3, VEC3, D3DCOLOR,
		VEC3, VEC3, D3DCOLOR, VEC3, VEC3, D3DCOLOR);
	void PrepareVertex();
	void Render(bool drawup);
};

/*
 *	lp`_v (eNX`)
 */
class CQuadDumpNX: public CVertexDump{
private:
	int m_QuadNum;			//	lp`
	int m_Count;			//	JE^
	VTX_NX *m_Buffer;		//	obt@
	CVertex m_Vertex;		//	o[ebNX
	LPTEX8 m_Texture;		//	eNX`|C^
	CQuadDumpNX *m_Next;	//	
public:
	CQuadDumpNX(int, LPTEX8);
	CQuadDumpNX(CQuadDumpNX *);
	~CQuadDumpNX();
	int GetCount(){ return m_Count; }
	void Feed();
	void Add(
		VEC3, VEC3, D3DCOLOR, float, float, VEC3, VEC3, D3DCOLOR, float, float,
		VEC3, VEC3, D3DCOLOR, float, float, VEC3, VEC3, D3DCOLOR, float, float);
	void Preview(
		VEC3, VEC3, D3DCOLOR, float, float, VEC3, VEC3, D3DCOLOR, float, float,
		VEC3, VEC3, D3DCOLOR, float, float, VEC3, VEC3, D3DCOLOR, float, float);
	void PrepareVertex();
	void Render(bool drawup);
};

#endif
