#include "stdafx.h"
#include "CCamera.h"
#include "CStructPlugin.h"
#include "CStruct.h"
#include "CStructSelectMode.h"
#include "CSimulationMode.h"
#include "CConfigMode.h"
#include "CSaveFile.h"

//	OO[o
extern bool g_MoverEnabled;

//	O[o
CStructPlugin *g_Struct = NULL;

/*
 *	[static]
 *	vr[
 */
void CStructPlugin::RenderPreview(
	VEC3 pos,	//	ʒu
	VEC3 dir,	//	dir
	VEC3 up		//	up
){
	CNamedObjectAfterRenderer::SetCurrentInst(NULL);
	g_SaveFile->ResetSwitch();
	if(ms_PreviewState && g_Struct){
		g_SystemObject[SYS_OBJ_LOCAL].SetPreviewPosture(pos, dir, up);
		SetCamDistSwitch(pos);
		g_Struct->Preview();
	}
}

/*
 *	fXgN^
 */
CStructPlugin::~CStructPlugin(){
}

/*
 *	[h
 */
bool CStructPlugin::Load(){
	char *str = m_Script, *tmp, *eee;
	if(!ChDir() || !m_Script) return false;
	g_NamedObjectMipMap = g_StructMipMap;
	CNamedObject::SetCastShadowDefault(true);
	try{
		if(!(str = LoadStruct(eee = str))) throw CSynErr(eee);

		if(!(str = ReadModelSwitch(eee = str))) throw CSynErr(eee);

		if(!(str = BeginBlock(eee = str, "PrimaryAssembly"))) throw CSynErr(eee);
		CFreeObject3D freeobj;
		while(tmp = freeobj.Read(str, this)){
			str = tmp;
			m_FreeObject.push_back(freeobj);
		}
		if(!(str = ReadEffect(eee = str))) throw CSynErr(eee);
		if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);

		if(*(eee = str)) throw CSynErr(eee);
	}
	catch(CSynErr err){
		HandleError(&err);
		return false;
	}
	IFreeObject3D ifo = m_FreeObject.begin();
	for(; ifo!=m_FreeObject.end(); ifo++) ifo->LoadModel(this);
	LoadData();
	DELETE_A(m_Buffer);
	return true;
}

/*
 *	[h
 */
char *CStructPlugin::LoadStruct(
	char *str	//	Ώە
){
	char *eee;
	if(!(str = BeginBlock(eee = str, "StructInfo"))) throw CSynErr(eee);
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	return str;
}

/*
 *	[h
 */
bool CStructPlugin::LoadOldForm(){
	if(!ChDir()) return false;
	g_NamedObjectMipMap = g_StructMipMap;
	CNamedObject::SetCastShadowDefault(true);
	FILE *file = fopen(TextName(), "rt");
	char *dummy = FlashOut();
	float sc;
	fscanf(file, "%s %s %f", dummy, dummy, &sc);
	fclose(file);
	float oldscale = 2.0f/sc;
	m_FreeObject.push_back(CFreeObject3D("MainObject", "Model.x", oldscale));
	m_FreeObject.begin()->LoadModel(this);
	m_PartsNum = 1;
	return true;
}

/*
 *	vr[ݒ
 */
void CStructPlugin::SetPreview(){
	ms_PreviewState = true;
	g_Struct = this;
	string desc = g_Struct->GetBasicInfo();
	desc += "\n"+g_Struct->GetDescription();
	g_StructSelectMode->SetProperty((char *)desc.c_str());
}

/*
 *	vr[
 */
void CStructPlugin::Preview(){
	SetPartsInst(NULL);
	SetMoverState(NULL);
	SetPosture();
	Render(NULL);
	PreviewStruct();
}

/*
 *	IuWFNg
 */
CNamedObject *CStructPlugin::FindObject(
	const string &name	//	IuWFNg
){
	CNamedObject *ret;
	IFreeObject3D ifo = m_FreeObject.begin();
	for(; ifo!=m_FreeObject.end(); ifo++) if(ret = ifo->Check(name)) return ret;
	return NULL;
}

/*
 *	TEhLǂ
 */
bool CStructPlugin::IsSoundEnabled(){
	return !!g_ConfigMode->GetStructSound();
}

/*
 *	pݒ
 */
void CStructPlugin::SetPosture(){
	IFreeObject3D ifo = m_FreeObject.begin();
	for(; ifo!=m_FreeObject.end(); ifo++) ifo->SetPostureFreeObject();
}

/*
 *	̓`FbN
 */
void CStructPlugin::ScanInput(
	CStruct *strct	//	{݃CX^X
){
	strct->SetLocalAxis();
	SetCamDistSwitch(strct->GetPos());
	g_PreSimulationFlag = false;
	IFreeObject3D ifo = m_FreeObject.begin();
	for(; ifo!=m_FreeObject.end(); ifo++) ifo->CheckDetect();
}

/*
 *	_O
 */
void CStructPlugin::Render(
	CStruct *strct	//	{݃CX^X
){
	SetAnimation(strct);
	if(strct){
		strct->SetLocalAxis();
		SetCamDistSwitch(strct->GetPos());
	}
	g_PreSimulationFlag = false;
	CNamedObject::SetSetMaterial(m_Version>=2.00f);
	if(strct && !g_SimulationMode->GetSimSpeed()){
		g_MoverEnabled = false;
		SetMoverState(strct);
		SetPosture();
		SetPartsInst(strct);
		g_MoverEnabled = true;
	}
	IFreeObject3D ifo = m_FreeObject.begin();
	for(; ifo!=m_FreeObject.end(); ifo++) ifo->Render();
	SimulateEffect(strct);
}

/*
 *	V~[Vis
 */
void CStructPlugin::Simulate(
	CStruct *strct	//	{݃CX^X
){
	SetMoverState(strct);
	strct->SetLocalAxis();
	SetCamDistSwitch(strct->GetPos());
	g_PreSimulationFlag = true;
	SetPosture();
	SimulateEffect(strct);
}
