#ifndef CSTATIONPLUGIN_H_INCLUDED
#define CSTATIONPLUGIN_H_INCLUDED

#include "CStructPlugin.h"

class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;
class CPierPlugin;
class CLinePlugin;
class CPolePlugin;
class CStationPlugin;
class CRailBuilder;
class CPlatformInst;
class CStation;

/*
 *	vbgtH[
 */
class CPlatform{
private:
	static CRailPlugin *ms_PlatformRail;		//	Jg[vOC
	static CTiePlugin *ms_PlatformTie;			//	Jg؃vOC
	static CGirderPlugin *ms_PlatformGirder;	//	JgvOC
	static CPierPlugin *ms_PlatformPier;		//	JgrvOC
	static CLinePlugin *ms_PlatformLine;		//	JgːvOC
	static CPolePlugin *ms_PlatformPole;		//	JgːvOC
	int m_TrackNum;					//	O
	float m_TrackInterval;			//	OԊu
	bool m_Stoppable;				//	ԉ\ /*CP932Ή*/
	bool m_OpenDoor[2];				//	hAJ (left, right)
	bool m_RailPluginValid;			//	[vOCLtO
	bool m_TiePluginValid;			//	؃vOCLtO
	bool m_GirderPluginValid;		//	vOCLtO
	bool m_PierPluginValid;			//	rvOCLtO
	bool m_LinePluginValid;			//	ːvOCLtO
	bool m_PolePluginValid;			//	ːvOCLtO
	CRailPlugin *m_RailPlugin;		//	[vOC
	CTiePlugin *m_TiePlugin;		//	؃vOC
	CGirderPlugin *m_GirderPlugin;	//	vOC
	CPierPlugin *m_PierPlugin;		//	rvOC
	CLinePlugin *m_LinePlugin;		//	ːvOC
	CPolePlugin *m_PolePlugin;		//	ːvOC
	bool m_LiftRailSurface;			//	[\ʎグ
	bool m_EnableCant;				//	JgL
	list<VEC3> m_CoordList;			//	_Xg
public:
	static void ResetPlatformPlugin();
	CPlatform();
	char *Read(char *);
	void PushCoord(VEC3 v){ m_CoordList.push_back(v); }
	int GetCoordNum(){ return m_CoordList.size(); }
	void SetPlatformPlugin();
	CRailBuilder *SetBuilder(MTX4 *);
	void Preview(MTX4 *, CLineDumpL *);
	void Build(MTX4 *, CStation *);
};

//	q
typedef list<CPlatform>::iterator IPlatform;

/*
 *	wɃvOC
 */
class CStationPlugin: public CStructPlugin{
	friend class CStation;
protected:
	list<CPlatform> m_Platform;	//	vbgtH[
public:
	static void RenderPreview(VEC3, VEC3, VEC3);
	CStationPlugin(char *id): CStructPlugin(id){}
	~CStationPlugin();
	char *DirName(){ return "Station"; }
	char *TextName(){ return "Station.txt"; }
	char *TextName2(){ return "Station2.txt"; }
	char *LoadStruct(char *);
	bool LoadOldForm();
	void SetPreview();
	void PreviewStruct();
	void BuildPlatform(CStation *);
	CPLUGIN_CASTFUNC(CStationPlugin);
};

/*
 *	{݃vOCXg
 */
class CStationPluginList: public CStructPluginList{
private:
public:
	char *DirName(){ return "Station"; }
	char *TextName(){ return "Station.txt"; }
	char *TextName2(){ return "Station2.txt"; }
	char *Default(){ return "MM02"; }
	CPlugin *NewEntry(char *id){ return new CStationPlugin(id); }
	CPLUGINLIST_CASTFUNC(CStationPlugin);
};

//	OO[o
extern CStationPlugin *g_Station;
extern CStationPluginList *g_StationPluginList;

#endif
