#ifndef CSOUNDEFFECTOR_H_INCLUDED
#define CSOUNDEFFECTOR_H_INCLUDED

class CNamedObject;
class CModelPlugin;
class CSoundEffector;
class CScene;

/*
 *	TEhGtFN^
 */
class CSoundState{
	friend class CSoundEffector;
private:
	int m_State;		//	
	bool m_ApplyFlag;	//	KptO
	CWave m_Wave;		//	TEhf[^
public:
	CSoundState(){ Reset(); }
	~CSoundState();
	void Reset(){ m_State = 0; }
	void Confirm(CSoundEffector *, bool);
};

//	q
typedef list<CSoundState>::iterator ISoundState;
typedef set<CSoundState *>::iterator ISPSoundState;

/*
 *	TEhGtFN^
 */
class CSoundEffector{
private:
	static set<CSoundState *> ms_PlayList;	//	vCXg
	string m_WaveFileName;		//	wave t@C
	CNamedObject *m_Link;		//	ڑIuWFNg
	VEC3 m_SourceCoord;			//	ʒu
	int m_Volume;				//	
	bool m_Loop;				//	[v
	CSoundState *m_LinkState;	//	ԕϐ
public:
	static void InitPlayList();
	static void DeleteSound(CSoundState *ss){ ms_PlayList.erase(ss); }
	char *Read(char *, CModelPlugin *);
	void LoadData(CSoundState *);
	void SetPos(CSoundState *);
	void PlayWave(CSoundState *);
	void Link(CSoundState *);
	void Register(CScene *);
};

//	q
typedef list<CSoundEffector>::iterator ISoundEffector;

#endif
