#include "stdafx.h"
#include "CModelPlugin.h"
#include "CConfigMode.h"

/*
 *	fXgN^
 */
CSoundState::~CSoundState(){
	CSoundEffector::DeleteSound(this);
}

/*
 *	ۑ
 */
void CSoundState::Confirm(
	CSoundEffector *eff,	//	GtFN^
	bool enabled			//	ĐLtO
){
	if(m_ApplyFlag && enabled){
		eff->SetPos(this);
		if(!m_State){
			m_State = 1;
			eff->PlayWave(this);
		}
	}else{
		if(m_State){
			m_State = 0;
			m_Wave.Stop();
			CSoundEffector::DeleteSound(this);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

//	O[o
set<CSoundState *> CSoundEffector::ms_PlayList;

/*
 *	[static]
 *	Xg
 */
void CSoundEffector::InitPlayList(){
	ISPSoundState isps = ms_PlayList.begin();
	for(; isps!=ms_PlayList.end(); isps++){
		(*isps)->m_State = 0;
		(*isps)->m_Wave.Stop();
	}
	ms_PlayList.clear();
}

/*
 *	Ǎ
 */
char *CSoundEffector::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	qvOC
){
	char *tmp, *eee;
	string obj;
	if(!(str = BeginBlock(str, "SoundEffect"))) return NULL;
	if(!(str = AsgnString(eee = str, "WaveFileName", &m_WaveFileName))) throw CSynErr(eee);
	if(!(str = AsgnString(eee = str, "AttachObject", &obj))) throw CSynErr(eee);
	if(!(m_Link = mpi->FindObject(obj)))
		throw CSynErr(eee, "%s: \"%s\"", lang(UndefinedObject), obj.c_str());
	if(!(str = AsgnVector3D(eee = str, "SourceCoord", &m_SourceCoord))) throw CSynErr(eee);
	if(tmp = AsgnInteger(eee = str, "Volume", &m_Volume)) str = tmp;
	else m_Volume = 0;
	if(tmp = AsgnYesNo(eee = str, "Loop", &m_Loop)) str = tmp;
	else m_Loop = true;
	ValueArea(&m_Volume, DSBVOLUME_MIN, DSBVOLUME_MAX);
	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	m_LinkState = NULL;
	return str;
}

/*
 *	f[^Ǎ
 */
void CSoundEffector::LoadData(
	CSoundState *ss	//	Xe[g
){
	ss->m_Wave.Load((char *)m_WaveFileName.c_str());
}

/*
 *	ʐݒ
 */
void CSoundEffector::SetPos(
	CSoundState *ss	//	Xe[g
){
	CObject *obj = m_Link->GetObject();
	VEC3 oright = obj->GetRight(), oup = obj->GetUp(), odir = obj->GetDir();
	V3Norm(&oright, &oright);
	V3Norm(&oup, &oup);
	V3Norm(&odir, &odir);
	ss->m_Wave.SetPos(obj->GetPos()+V3LocalToWorld(&m_SourceCoord, &oright, &oup, &odir));
}

/*
 *	obt@Đ
 */
void CSoundEffector::PlayWave(
	CSoundState *ss	//	Xe[g
){
	ss->m_Wave.SetVolume(m_Volume);
	ss->m_Wave.Play(m_Loop ? -1 : 0);
	ms_PlayList.insert(ss);
}

/*
 *	ԕϐA^b`
 */
void CSoundEffector::Link(
	CSoundState *stt	//	ԕϐ
){
	m_LinkState = stt;
	m_LinkState->m_ApplyFlag = false;
}

/*
 *	_OXgɓo^
 */
void CSoundEffector::Register(
	CScene *scene	//	V[
){
	if(!m_LinkState || !scene) return;
	m_LinkState->m_ApplyFlag = true;
}
