#ifndef CSKINPLUGIN_H_INCLUDED
#define CSKINPLUGIN_H_INCLUDED

#include "CWaveArray.h"
#include "CPlugin.h"

/*
 *	XLvOC
 */
class CSkinPlugin: public CPlugin{
public:
	struct _CURSORDATA{		//	J[\ݒ
		int m_Frame, m_Anim;		//	Aj[VJE^
		string m_TexFileName;		//	eNX`t@C
		int m_ImageSize[2];			//	摜TCY
		int m_Cursor2DSize[2];		//	J[\TCY
		int m_Cursor2DHotSpot[2];	//	zbgX|bgW
		int m_Cursor2DAnimNumber;	//	Aj[V
		int *m_Cursor2DAnimFrame;	//	Ajt[
		LPTEX8 m_CursorTexture;		//	J[\eNX`
	public:
		_CURSORDATA(){ m_Frame = m_Anim = 0; }
		char *Read(char *, char *);
		void LoadData();
		void Render(POINT, float);
	} m_NormalCursorData, m_ResizeCursorData[4];
	struct _INTERFACEDATA{	//	C^[tFCXݒ
		string m_TexFileName;			//	eNX`t@C
		string m_FontName;				//	tHg
		HFONT m_hFont;					//	tHgnh
		D3DCOLOR m_TitleBarFontColor;	//	^Cgo[tHgF
		D3DCOLOR m_ButtonFontColor;		//	{^tHgF
		D3DCOLOR m_StaticFontColor;		//	X^eBbNtHgF
		D3DCOLOR m_FocusFrameColor;		//	tH[JXgF
	} m_InterfaceData;
	struct _BACKGROUNDDATA{	//	wiݒ
		string m_TexFileName;		//	eNX`t@C
		D3DCOLOR m_BackgroundColor;	//	wiF
		int m_ImageSize[2];			//	摜TCY
	} m_BackgroundData;
	struct _FRAMEDATA{	//	t[ݒ
		string m_FrameTexFileName;			//	eNX`t@C
		string m_IconTexFileName[MODE_NUM];	//	ACRt@C
		D3DCOLOR m_LabelFontColor;			//	^Cgo[tHgF
		D3DCOLOR m_InfoFontColor;			//	tHgF
		D3DCOLOR m_FloatFontColor;			//	t[gtHgF
	} m_FrameData;
	struct _EDITCTRLDATA{	//	GfBbgRg[ݒ
		D3DCOLOR m_DefaultFontColor;		//	tHgF
		D3DCOLOR m_EditBaseColor[4];		//	wiF
		D3DCOLOR m_EditFontColor;			//	ҏWtHgF
		D3DCOLOR m_ConvertFontColor;		//	ϊtHgF
		D3DCOLOR m_ConvertClauseColor[2];	//	ϊ߉F
		D3DCOLOR m_SelectedBaseColor[4];	//	I𒆔wiF
	} m_EditCtrlData;
	struct _LISTVIEWDATA{	//	Xg{bNXݒ
		D3DCOLOR m_DefaultBaseColorOdd[4];	//	wiF
		D3DCOLOR m_DefaultBaseColorEven[4];	//	wiF
		D3DCOLOR m_DefaultFontColor;		//	tHgF
		D3DCOLOR m_SelectedBaseColor[4];	//	IwiF
		D3DCOLOR m_SelectedFontColor;		//	ItHgF
		D3DCOLOR m_FocusFrameColor;			//	tH[JXgF
	} m_ListViewData;
	struct _PLUGINTREEDATA{	//	vOCXgݒ
		D3DCOLOR m_DefaultBaseColor[4];		//	wiF
		D3DCOLOR m_DefaultFontColor;		//	tHgF
		D3DCOLOR m_SelectedBaseColor[4];	//	IwiF
		D3DCOLOR m_SelectedFontColor;		//	ItHgF
		D3DCOLOR m_FocusFrameColor;			//	tH[JXgF
	} m_PluginTreeData;
	struct _POPUPMENUDATA{	//	|bvAbvj[ݒ
		D3DCOLOR m_DefaultFontColor;		//	tHgF
		D3DCOLOR m_DisabledFontColor;		//	tHgF
		D3DCOLOR m_DisabledShadowColor;		//	AeF
		D3DCOLOR m_SelectedBaseColor[4];	//	IwiF
		D3DCOLOR m_SelectedFontColor;		//	ItHgF
	} m_PopupMenuData;
	struct _MODELDATA{	//	e탂fݒ
		string m_ArrowModelFileName;		//	󃂃ft@C
		string m_LinkModelFileName;			//	ڑ_ft@C
		string m_SegmentModelFileName;		//	ZOgft@C
		string m_CompassModelFileName[2];	//	RpXft@C
		string m_WindDirModelFileName;		//	RpXft@C
		float m_ArrowModelScale;			//	󃂃fXP[
		float m_LinkModelScale;				//	ڑ_fXP[
		float m_SegmentModelScale;			//	ZOgfXP[
		float m_CompassModelScale[2];		//	RpXfXP[
		float m_WindDirModelScale;			//	RpXfXP[
	} m_ModelData;
	struct _SOUNDDATA{	//	TEhݒ
		string m_MouseDownWaveFileName;	//	}EX wav t@C
		string m_MouseUpWaveFileName;	//	}EX wav t@C
		string m_ErrorWaveFileName;		//	G[ wav t@C
		string m_ScreenShotWaveFileName;		//	XN[VbgBe wav t@C
		string m_VideoStartWaveFileName;		//	rfIBeJn wav t@C
		string m_VideoStopWaveFileName;		//	rfIBe~ wav t@C
	} m_SoundData;
	LPTEX8 m_InterfaceTexture;		//	C^[tFCXeNX`
	LPTEX8 m_FrameTexture;			//	t[eNX`
	LPTEX8 m_IconTexture[MODE_NUM];	//	ACReNX`
	LPTEX8 m_WallpaperTexture;		//	ǎeNX`
	CMesh *m_ArrowMesh;				//	󃁃bV
	CMesh *m_LinkMesh;				//	ڑ_bV
	CMesh *m_SegmentMesh;			//	ZOgbV
	CMesh *m_CompassMesh[2];		//	RpX
	CMesh *m_WindDirMesh;			//	v
	CWaveArray m_MouseDown;			//	}EXʉ
	CWaveArray m_MouseUp;			//	NbN
	CWaveArray m_Error;				//	G[
	CWaveArray m_ScreenShot;		//	XN[VbgBe
	CWaveArray m_VideoStart;		//	rfIBeJn
	CWaveArray m_VideoStop;			//	rfIBe~
public:
	CSkinPlugin(char *);
	~CSkinPlugin();
	char *DirName(){ return "Skin"; }
	char *TextName2(){ return "Skin2.txt"; }
	bool Load();
	void SetPreview();
	void SetInterfaceTexture(){ devSetTexture(0, m_InterfaceTexture); }
	void SetFrameTexture(){ devSetTexture(0, m_FrameTexture); }
	void SetIconTexture(int i){ devSetTexture(0, m_IconTexture[i]); }
	HFONT GetFont(){ return m_InterfaceData.m_hFont; }
	HFONT GetLabelFont(){ return m_InterfaceData.m_hFont; }
	void MouseDown();
	void MouseUp();
	void Error();
	void ScreenShot();
	void VideoStart();
	void VideoStop();
	void DrawBackground(bool);
	void ScaleCompass(float);
	CPLUGIN_CASTFUNC(CSkinPlugin);
};

/*
 *	XLvOCXg
 */
class CSkinPluginList: public CPluginList{
private:
public:
	char *DirName(){ return "Skin"; }
	char *TextName2(){ return "Skin2.txt"; }
	char *Default(){ return "Default_Blue"; }
	CPlugin *NewEntry(char *id){ return new CSkinPlugin(id); }
	CPLUGINLIST_CASTFUNC(CSkinPlugin);
};

//	OO[o
extern CObject g_ArrowObject;
extern CObject g_LinkObject;
extern CObject g_SegmentObject;
extern CObject g_CompassObject[];
extern CObject g_WindDirObject;
extern CSkinPlugin *g_Skin;
extern CSkinPluginList *g_SkinPluginList;

#endif
