#ifndef CSCENE_H_INCLUDED
#define CSCENE_H_INCLUDED

#include "CCamera.h"
#include "CStruct.h"

class CListElement;
class CRailConnector;
class CRailWay;
class CPier;
class CLine;
class CPole;
class CPoleLink;
class CStation;
class CPierPlugin;
class CLinePlugin;
class CPolePlugin;
class CSurfacePlugin;
class CEnvPlugin;

/*
 *	V[
 */
class CScene: public CStruct{
	friend class CSceneEditMode;
private:
	int m_Serial;						//	VAio[
	string m_Name;						//	V[
	VEC3 m_ArrowPos;					//	ҏWW
	CListElement *m_ListElement;		//	Xgvf
	CCamera m_Camera;					//	J
	CRailConnector *m_RailConnector;	//	RlN^
	CRailWay *m_RailWay;				//	[
	CPier *m_Pier;						//	r
	CLine *m_Line;						//	ː
	CPole *m_Pole;						//	ː
	CStation *m_Station;				//	w
	CStruct *m_Struct;					//	{
	CSurfacePlugin *m_SurfacePlugin;	//	n`vOC
	CEnvPlugin *m_EnvPlugin;			//	vOC
	CScene *m_Next;						//	
public:
	CScene();
	CScene(CSurfacePlugin *, CEnvPlugin *, char *);
	~CScene();
	char *GetName(){ return (char *)m_Name.c_str(); }
	char *GetNumberedName();
	void SetName(char *name){ m_Name = name; }
	VEC3 *GetArrowPos(){ return &m_ArrowPos; }
	int GetSerial(){ return m_Serial; }
	void SetSerial(int s){ m_Serial = s; }
	void SetListElement(CListElement *le){ m_ListElement = le; }
	CListElement *GetListElement(){ return m_ListElement; }
	CCamera *GetCamera(){ return &m_Camera; }
	CSurfacePlugin *GetSurface(){ return m_SurfacePlugin; }
	CEnvPlugin *GetEnv(){ return m_EnvPlugin; }
	void SetEnv(CEnvPlugin *epi){ m_EnvPlugin = epi; }
	void SetSeason();
	void Enter(bool);
	void SetGlobalAxis();
	void ResetRailRoot();
	void Delete();
	void DeleteGroup(CTrainGroup *);
	void DeletePierLink(CPier *);
	void DeletePoleLink(CPole *);
	bool DeleteRailWay();
	bool SetRailBlock(char *);
	bool SetSpeedLimit(int);
	bool DeleteRailConnector();
	bool DeletePier(CPier *);
	bool DeleteLine(CLine *);
	bool DeletePole(CPole *);
	bool DeleteStation(CStation *);
	bool DeleteStruct(CStruct *);
	void ScanInputRailWay(int, VEC3, VEC3, bool);
	void ScanInputRailConnector(int, VEC3, VEC3);
	void ScanInputPier(int, VEC3, VEC3);
	void ScanInputLine(int, VEC3, VEC3);
	void ScanInputPole(int, VEC3, VEC3);
	void ScanInputStation(int, VEC3, VEC3, bool init = false);
	void ScanInputStruct(int, VEC3, VEC3, bool init = false);
	CLine *FindLine(CPoleLink *, CPoleLink *);
	void BuildLine(CPierPlugin *, CLinePlugin *, CPolePlugin *);
	bool PickScene(VEC3, VEC3, VEC3 *, VEC3 *tri = NULL, int inv = 1);
	bool ClipAlt(VEC3 *, VEC3 *, VEC3 *, int);
	void Dump();
	void RenderScene();
	void RenderAfter();
	void SimulateScene();
	CScene *GetScene(){ return this; }
	void RestoreAddress();
	char *Read(char *, CScene ***);
	void Save(FILE *);
	CMODELINST_CASTFUNC(CScene);
};

//	OO[o
extern CScene *g_Scene;
extern map<void *, void *> g_AddressMap;

//	֐錾
void *ReplaceAdr(void *);

/*
 *	JgV[̒n`擾
 */
inline CSurfacePlugin *Surface(){ return g_Scene->GetSurface(); }

#endif
