#ifndef CPIER_H_INCLUDED
#define CPIER_H_INCLUDED

class CPierPlugin;

/*
 *	rCX^X
 */
class CPier{
private:
	static CPier **ms_Root;		//	ڑ[g
	static float ms_MinDist;	//	ŏo
	static CPier *ms_Detect;	//	o
	int m_Selected;				//	ItO
	bool m_Valid;				//	ݗLtO
	float m_SurfaceAlt;			//	n`ox
	float m_PierArea;			//	r
	VEC3 m_SurfaceHit;			//	n\eW
	CObject m_JointObject;		//	WCgIuWFNg
	CObject m_HeadObject;		//	wbhIuWFNg
	CObject m_BaseObject;		//	bIuWFNg
	VEC3 m_PierBegin;			//	rJnW
	VEC3 m_PierEnd;				//	rIW
	VEC3 m_PierRight;			//	r right
	VEC3 m_PierUp;				//	r up
	VEC3 m_PierDir;				//	r dir
	CPierPlugin *m_PierPlugin;	//	rvOC
	CPier *m_Next;				//	Xg
public:
	static void SetRoot(CPier **r){ ms_Root = r; }
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static CPier *GetDetect(){ return ms_Detect; }
	CPier();
	CPier(VEC3, VEC3, VEC3, float, CPierPlugin *);
	~CPier();
	void SetMesh();
	bool Init(float *);
	void Delete();
	CPier *Next(){ return m_Next; }
	CPier **NextAdr(){ return &m_Next; }
	bool Confirm();
	int GetSelectFlag(){ return m_Selected; }
	void AddSelectFlag(int s){ m_Selected |= s; }
	void ScanInput(int, VEC3 &, VEC3 &);
	void Dump(int prev = 4);
	void Render();
	char *Read(char *);
	void Save(FILE *);
};

#endif
