#ifndef CINTERFACEMODE_H_INCLUDED
#define CINTERFACEMODE_H_INCLUDED

#include "CGameMode.h"
#include "CWindowCtrl.h"
#include "CMultiStatic.h"
#include "CListView.h"
#include "CPopMenu.h"
#include "CPluginTree.h"

/*
 *	vOCXgr[
 */
class CPluginListView: public CIconListView{
	friend class CTreeDirElement;
private:
	CTreeDirElement *m_ShowDir;	//	\fBNg
public:
	bool IsRenamable(CListElement *);
	bool IsDroppable(CListElement *);
	bool ConfirmRename(CListElement *, string &);
	void EndRename(CListElement *);
	void Drop();
	void DoubleClick();
	CTreeDirElement *GetShowDir(){ return m_ShowDir; }
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	C^[tFCX[h
 */
class CInterfaceMode: public CGameMode{
protected:
	CCamera *m_Camera;	//	J
public:
	CInterfaceMode();
	virtual ~CInterfaceMode(){}
	virtual bool DrawBackground(){ return false; }
	char *LoadSetting(char *str){ return LoadInterfaceSetting(str); }
	virtual char *LoadInterfaceSetting(char *str){ return str; }
	void SaveSetting(FILE *file){ SaveInterfaceSetting(file); }
	virtual void SaveInterfaceSetting(FILE *){}
	void EnterGame();
	virtual void EnterInterface() = 0;
	void SpinGame();
	virtual void ModalFuncInterface(){}
	virtual void ScanInputInterface() = 0;
	virtual void RenderInterface(){}
};

/*
 *	vOC[h
 */
class CPluginMode: public CInterfaceMode, public CWindowResizer, public CMenuCommander{
protected:
	static bool ms_ShowProperty;			//	vpeB\tO
	static CPopMenu *ms_DirMenu;			//	fBNgj[
	static CWindowCtrl *ms_LastInfoWindow;	//	ŌɎgp
	CWindowCtrl m_ListWindow;				//	Xg
	CPluginListView m_PluginListView;		//	Xg
	CPluginTree m_PluginTree;				//	c[
	CWindowCtrl m_InfoWindow;				//	vOC
	CMultiStatic m_InfoStatic;				//	vOC\
	CPopMenu *m_PluginMenu;					//	c[j[
	CPopMenu *m_PreviewMenu;				//	vr[j[
public:
	static void InitMenu();
	static void FreeMenu();
	CPluginMode(char *);
	virtual ~CPluginMode();
	virtual void WindowResized(int, int, CWindowCtrl *);
	virtual CPopMenu *Dispatch(CMDTYPE, DWORD) = 0;
	virtual void DoubleClick(CMDTYPE, DWORD){}
	virtual bool DrawBackground(){ return false; }
	CPluginTree *GetTree(){ return &m_PluginTree; }
	void ViewProperty();
	void SetProperty(char *text){ m_InfoStatic.SetText(text); }
	virtual char *PluginDirName() = 0;
	virtual CPluginList *GetPluginList() = 0;
	CPlugin *FindPluginBase(char *, char *);
	virtual CPlugin *FindPlugin(char *, char *){ return NULL; }
	char *LoadInterfaceSetting(char *);
	virtual char *LoadPluginSetting(char *str){ return str; }
	void SaveInterfaceSetting(FILE *);
	void SetPreviewMenuPlugin();
	void EnterInterface();
	virtual void EnterPlugin() = 0;
	void ModalFuncInterface(){ ModalFuncPlugin(); }
	virtual void ModalFuncPlugin(){}
	void ScanInputInterface();
	virtual void ScanInputPlugin() = 0;
	void RenderInterface();
	virtual void RenderPlugin(){}
};

#endif
