#ifndef CEXPRESSION_H_INCLUDED
#define CEXPRESSION_H_INCLUDED

class CModelSwitch;
class CModelPlugin;

/*
 *	NX
 */
class CExpression{
public:
	virtual ~CExpression(){}
	virtual CExpression *Duplicate() = 0;
	virtual int CalcInt() = 0;
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	ϐQƃNX
 */
class CVariableReference: public CExpression{
private:
	CModelSwitch *m_Link;	//	XCb`
public:
	CVariableReference(CModelSwitch *sw){ m_Link = sw; }
	CExpression *Duplicate(){ return new CVariableReference(*this); }
	int CalcInt();
};

/*
 *	萔NX
 */
class CConstInteger: public CExpression{
private:
	int m_Constant;	//	l
public:
	CConstInteger(int cons){ m_Constant = cons; }
	CExpression *Duplicate(){ return new CConstInteger(*this); }
	int CalcInt();
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	PZq
 */
class CMonomialOperator: public CExpression{
protected:
	CExpression *m_Child;	//	
public:
	CMonomialOperator(){ m_Child = NULL; }
	CMonomialOperator(CExpression *child){ m_Child = child; }
	virtual ~CMonomialOperator();
	void CopyOperand(const CMonomialOperator *);
	virtual CExpression *Duplicate() = 0;
	virtual int CalcInt() = 0;
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	񍀉Zq
 */
class CBinomialOperator: public CExpression{
protected:
	CExpression *m_Left;	//	
	CExpression *m_Right;	//	E
public:
	CBinomialOperator(){ m_Left = m_Right = NULL; }
	CBinomialOperator(CExpression *left, CExpression *right){
		m_Left = left; m_Right = right;
	}
	virtual ~CBinomialOperator();
	void CopyOperand(const CBinomialOperator *);
	virtual CExpression *Duplicate() = 0;
	virtual int CalcInt() = 0;
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	OZq
 */
class CTrinomialOperator: public CExpression{
protected:
	CExpression *m_Condition;	//	
	CExpression *m_TrueExpr;	//	^
	CExpression *m_FalseExpr;	//	U
public:
	CTrinomialOperator(){ m_Condition = m_TrueExpr = m_FalseExpr = NULL; }
	CTrinomialOperator(CExpression *cond, CExpression *te, CExpression *fe){
		m_Condition = cond; m_TrueExpr = te; m_FalseExpr = fe;
	}
	virtual ~CTrinomialOperator();
	void CopyOperand(const CTrinomialOperator *);
	virtual CExpression *Duplicate(){ return new CTrinomialOperator(*this); }
	virtual int CalcInt();
};

//	֐錾
char *Expression(char *, CExpression **);

//	OO[o
extern CModelPlugin *g_SwitchOwner;

#endif
