#ifndef CEFFECTOR_H_INCLUDED
#define CEFFECTOR_H_INCLUDED

class CHeadlight;
class CParticle;
class CSoundEffector;
class CModelPlugin;
class CScene;

//	^CvtO
const int EFCT_MISCELLANEOUS = 0x0001;
const int EFCT_PARTICLEAPPLIER = 0x0002;

/*
 *	GtFN^{NX
 */
class CEffectorBase{
protected:
public:
	virtual ~CEffectorBase(){}
	virtual CEffectorBase *Duplicate() = 0;
	virtual void LoadDataEffector(CModelPlugin *){}
	virtual int GetTypeFlagEffector(){ return EFCT_MISCELLANEOUS; }
	virtual void ApplyEffector(CScene *){}
};

/*
 *	GtFN^Rei
 */
class CEffectorContainer{
private:
	CEffectorBase *m_Effector;	//	GtFN^
public:
	CEffectorContainer();
	CEffectorContainer(const CEffectorContainer &);
	~CEffectorContainer();
	char *Read(char *, CModelPlugin *);
	void LoadData(CModelPlugin *mpi){ m_Effector->LoadDataEffector(mpi); }
	int GetTypeFlag(){ return m_Effector->GetTypeFlagEffector(); }
	void Apply(CScene *scene){ m_Effector->ApplyEffector(scene); }
};

//	q
typedef list<CEffectorContainer>::iterator IEffectorContainer;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	wbhCgKpq
 */
class CHeadlightApplier: public CEffectorBase{
private:
	CHeadlight *m_Headlight;	//	wbhCg
public:
	CHeadlightApplier(){ m_Headlight = NULL; }
	CEffectorBase *Duplicate(){ return new CHeadlightApplier(*this); }
	char *Read(char *, CModelPlugin *);
	void LoadDataEffector(CModelPlugin *);
	void ApplyEffector(CScene *);
};

/*
 *	p[eBNKpq
 */
class CParticleApplier: public CEffectorBase{
private:
	CParticle *m_Particle;	//	p[eBN
public:
	CParticleApplier(){ m_Particle = NULL; }
	CEffectorBase *Duplicate(){ return new CParticleApplier(*this); }
	char *Read(char *, CModelPlugin *);
	void LoadDataEffector(CModelPlugin *);
	int GetTypeFlagEffector(){ return EFCT_PARTICLEAPPLIER; }
	void ApplyEffector(CScene *);
};

/*
 *	TEhKpq
 */
class CSoundApplier: public CEffectorBase{
private:
	CSoundEffector *m_SoundEffector;	//	TEhGtFN^
public:
	CSoundApplier(){ m_SoundEffector = NULL; }
	CEffectorBase *Duplicate(){ return new CSoundApplier(*this); }
	char *Read(char *, CModelPlugin *);
	void ApplyEffector(CScene *);
};

#endif
