#ifndef CDIADIALOG_H_INCLUDED
#define CDIADIALOG_H_INCLUDED

#include "CWindowCtrl.h"
#include "CCheckBox.h"
#include "CRadioButton.h"
#include "CStaticCtrl.h"
#include "CGroupBox.h"
#include "CEditCtrl.h"
#include "CTrainListView.h"

class CRailConnector;
class CStation;
class CDiaElementBase;
class CDiaListBase;
class CDiaInstBase;
class CPointElement;
class CDiaElement;

/*
 *	_C֘A_CAO{NX
 */
class CDiaDialogBase: public CWindowCtrl, public CWindowResizer, public CMenuCommander{
protected:
	int m_ExtHeight;				//	g̈捂
	CStaticCtrl	m_NameLabel;		//	̃x
	CEditCtrl m_NameEdit;			//	̃GfBbg
	CGroupListView m_GroupListView;	//	ҐXg
	CPopMenu *m_GroupMenu;			//	Ґj[
	CCheckBox m_UseDefault;			//	ftHgݒgp
	CStaticCtrl m_DefaultLabel;		//	ftHgIx
	CListView m_RoutineListView;	//	[`Xg
	CPopMenu *m_RoutineMenu;		//	[`j[
	CPushButton m_RoutineAdd;		//	ǉ
	CPushButton m_RoutineDelete;	//	폜
	CPushButton m_RoutinePrev;		//	ЂƂ߂
	CPushButton m_RoutineNext;		//	ЂƂ
	CGroupBox m_DiaGroup;			//	ݒO[v
	CPushButton m_ApplyButton;		//	Kp{^
	CDiaInstBase *m_DiaInst;		//	_CCX^X
	CDiaListBase *m_DiaList;		//	[`
	CDiaElementBase *m_DiaElement;	//	ҏW_Cvf
public:
	CDiaDialogBase();
	~CDiaDialogBase();
	void Init(int, int, int, int, char *,  CInterface *, char *, int);
	void InitFoot();
	void WindowResized(int, int, CWindowCtrl *);
	virtual void ResizeDiaDialogBase(int, int) = 0;
	CPopMenu *Dispatch(CMDTYPE, DWORD);
	void Enter(CDiaInstBase *);
	void SetTrainGroup(CTrainGroup *);
	void SetDiaElementBase(CDiaElementBase *);
	void ScanInputDia();
	void AddRoutine();
	void DeleteRoutine();
	void RotateRoutine(bool);
	virtual void ScanInputDiaDialogBase() = 0;
	void RenderWindow(){ RenderDiaDialogBase(); }
	virtual void RenderDiaDialogBase(){}
	virtual void SetElementValue(CDiaElementBase *) = 0;
};

#define CDIADIALOGBASE_CASTFUNC(el) \
	el *GetElement(){ return m_DiaElement ? (el *)m_DiaElement : NULL; }

/*
 *	|Cgؑփ_CAO
 */
class CPointDialog: public CDiaDialogBase{
private:
	CRadioButton m_Point[3];	//	|CgWI
public:
	void Init(CInterface *);
	void ResizeDiaDialogBase(int, int);
	void ScanInputDiaDialogBase();
	void SetElementValue(CDiaElementBase *);
	CDIADIALOGBASE_CASTFUNC(CPointElement);
};

/*
 *	_Cݒ_CAO
 */
class CDiaDialog: public CDiaDialogBase{
private:
	int m_OffsetSlide;			//	ItZbgXC_
	CRadioButton m_Action[3];	//	색WI
	CRadioButton m_TimeType[2];	//	ԃWI
	CEditCtrl m_HourEdit;		//	x
	CStaticCtrl m_HourLabel;	//	GfBbg
	CEditCtrl m_MinuteEdit;		//	GfBbg
	CStaticCtrl m_MinuteLabel;	//	x
	CEditCtrl m_SecondEdit;		//	bGfBbg
	CStaticCtrl m_SecondLabel;	//	bx
//	CCheckBox m_JointCheck;		//	A`FbN
public:
	void Init(CInterface *);
	void ResizeDiaDialogBase(int, int);
	void ScanInputDiaDialogBase();
	void RenderDiaDialogBase();
	void SetElementValue(CDiaElementBase *);
	CDIADIALOGBASE_CASTFUNC(CDiaElement);
};

#endif
