#ifndef CCUSTOMIZERMISC_H_INCLUDED
#define CCUSTOMIZERMISC_H_INCLUDED

#include "CCustomizer.h"

/*
 *	fύXq
 */
class CModelChanger: public CCustomizerBase{
private:
	string m_AltModelName;	//	փft@C
	CMesh *m_AltModel;		//	փf
	float m_AltModelScale;	//	փXP[
public:
	CModelChanger();
	CCustomizerBase *Duplicate(){ return new CModelChanger(*this); }
	char *Read(char *);
	void LoadDataCustomizer(CModelPlugin *);
	int GetTypeFlagCustomizer(){ return CSTM_MODELCHANGER; }
	CMesh *GetMeshCustomizer(float *);
};

/*
 *	e}wq
 */
class CShadowInhibitor: public CCustomizerBase{
private:
	bool m_NoCastShadow;		//	e𗎂ƂȂ
	bool m_NoReceiveShadow;		//	e󂯂Ȃ
	bool m_Transparent;			//	ߎw
	vector<int> m_MaterialID;	//	}eAԍ
public:
	CCustomizerBase *Duplicate(){ return new CShadowInhibitor(*this); }
	char *Read(char *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	}bvwq
 */
class CEnvMapper: public CCustomizerBase{
private:
	vector<int> m_MaterialID;	//	}eAԍ
public:
	CCustomizerBase *Duplicate(){ return new CEnvMapper(*this); }
	char *Read(char *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	eXgwq
 */
class CAlphaTester: public CCustomizerBase{
private:
	vector<int> m_MaterialID;	//	}eAԍ
public:
	CCustomizerBase *Duplicate(){ return new CAlphaTester(*this); }
	char *Read(char *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	eNX`ύXq
 */
class CTextureChanger: public CCustomizerBase{
private:
	int m_MaterialID;			//	}eAԍ
	string m_AltTextureName;	//	փeNX`t@C
	LPTEX8 m_AltTexture;		//	փeNX`
public:
	CCustomizerBase *Duplicate(){ return new CTextureChanger(*this); }
	char *Read(char *);
	void LoadDataCustomizer(CModelPlugin *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	eNX`gXtH[}
 */
class CTextureTransformer: public CCustomizerBase{
private:
	int m_TransformType;	//	ϊ^Cv
	int m_MaterialID;		//	}eAԍ
	TTMTX m_Matrix;			//	ϊs
public:
	CCustomizerBase *Duplicate(){ return new CTextureTransformer(*this); }
	char *Read(char *, bool);
	void SetUpMatrix(int, float *);
	void ApplyCustomizer(CMesh *);
	void SetMaterialID(int matid){ m_MaterialID = matid; }
};

/*
 *	Aj[VKpq
 */
class CAnimationApplier: public CCustomizerBase{
private:
	int m_MaterialID;				//	}eAԍ
	CTextureAnimation *m_Animation;	//	Aj[V
public:
	CCustomizerBase *Duplicate(){ return new CAnimationApplier(*this); }
	char *Read(char *, CModelPlugin *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	At@ύXq
 */
class CAlphaChanger: public CCustomizerBase{
private:
	int m_MaterialID;	//	}eAԍ
	float m_AltAlpha;	//	փAt@
public:
	CCustomizerBase *Duplicate(){ return new CAlphaChanger(*this); }
	char *Read(char *);
	void ApplyCustomizer(CMesh *);
};

/*
 *	}eAύXq
 */
class CMaterialChanger: public CCustomizerBase{
private:
	vector<int> m_MaterialID;	//	}eAԍ
	MAT8 m_Material;			//	}eA
public:
	CCustomizerBase *Duplicate(){ return new CMaterialChanger(*this); }
	char *Read(char *);
	void ApplyCustomizer(CMesh *);
};

#endif
