/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.NativeString;

class DefaultMediaMeta
implements MediaMeta {
    private final AtomicBoolean released = new AtomicBoolean();
    private final LibVlc libvlc;
    private final libvlc_media_t media;
    private BufferedImage artwork;

    DefaultMediaMeta(LibVlc libvlc, libvlc_media_t media) {
        this.libvlc = libvlc;
        this.media = media;
        libvlc.libvlc_media_retain(media);
    }

    @Override
    public final void parse() {
        Logger.debug("parse()", new Object[0]);
        this.libvlc.libvlc_media_parse(this.media);
    }

    @Override
    public final String getTitle() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Title);
    }

    @Override
    public final void setTitle(String title) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Title, title);
    }

    @Override
    public final String getArtist() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Artist);
    }

    @Override
    public final void setArtist(String artist) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Artist, artist);
    }

    @Override
    public final String getGenre() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Genre);
    }

    @Override
    public final void setGenre(String genre) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Genre, genre);
    }

    @Override
    public final String getCopyright() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Copyright);
    }

    @Override
    public final void setCopyright(String copyright) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Copyright, copyright);
    }

    @Override
    public final String getAlbum() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Album);
    }

    @Override
    public final void setAlbum(String album) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Album, album);
    }

    @Override
    public final String getTrackNumber() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackNumber);
    }

    @Override
    public final void setTrackNumber(String trackNumber) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackNumber, trackNumber);
    }

    @Override
    public final String getDescription() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Description);
    }

    @Override
    public final void setDescription(String description) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Description, description);
    }

    @Override
    public final String getRating() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Rating);
    }

    @Override
    public final void setRating(String rating) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Rating, rating);
    }

    @Override
    public final String getDate() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Date);
    }

    @Override
    public final void setDate(String date) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Date, date);
    }

    @Override
    public final String getSetting() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Setting);
    }

    @Override
    public final void setSetting(String setting) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Setting, setting);
    }

    @Override
    public final String getUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_URL);
    }

    @Override
    public final void setUrl(String url) {
        this.setMeta(libvlc_meta_t.libvlc_meta_URL, url);
    }

    @Override
    public final String getLanguage() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Language);
    }

    @Override
    public final void setLanguage(String language) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Language, language);
    }

    @Override
    public final String getNowPlaying() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_NowPlaying);
    }

    @Override
    public final void setNowPlaying(String nowPlaying) {
        this.setMeta(libvlc_meta_t.libvlc_meta_NowPlaying, nowPlaying);
    }

    @Override
    public final String getPublisher() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_Publisher);
    }

    @Override
    public final void setPublisher(String publisher) {
        this.setMeta(libvlc_meta_t.libvlc_meta_Publisher, publisher);
    }

    @Override
    public final String getEncodedBy() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_EncodedBy);
    }

    @Override
    public final void setEncodedBy(String encodedBy) {
        this.setMeta(libvlc_meta_t.libvlc_meta_EncodedBy, encodedBy);
    }

    @Override
    public final String getArtworkUrl() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_ArtworkURL);
    }

    @Override
    public final void setArtworkUrl(String artworkUrl) {
        this.setMeta(libvlc_meta_t.libvlc_meta_ArtworkURL, artworkUrl);
    }

    @Override
    public final String getTrackId() {
        return this.getMeta(libvlc_meta_t.libvlc_meta_TrackID);
    }

    @Override
    public final void setTrackId(String trackId) {
        this.setMeta(libvlc_meta_t.libvlc_meta_TrackID, trackId);
    }

    @Override
    public final BufferedImage getArtwork() {
        String artworkUrl;
        Logger.debug("getArtwork()", new Object[0]);
        if (this.artwork == null && (artworkUrl = this.getArtworkUrl()) != null && artworkUrl.length() > 0) {
            try {
                URL url = new URL(artworkUrl);
                Logger.debug("url={}", url);
                this.artwork = ImageIO.read(url);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load artwork", e);
            }
        }
        return this.artwork;
    }

    @Override
    public final long getLength() {
        return this.libvlc.libvlc_media_get_duration(this.media);
    }

    @Override
    public final void save() {
        Logger.debug("save()", new Object[0]);
        this.libvlc.libvlc_media_save_meta(this.media);
    }

    @Override
    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.libvlc.libvlc_media_release(this.media);
        }
    }

    protected void finalize() throws Throwable {
        Logger.debug("finalize()", new Object[0]);
        Logger.debug("Meta data has been garbage collected", new Object[0]);
        super.finalize();
    }

    private String getMeta(libvlc_meta_t metaType) {
        Logger.trace("getMeta(metaType={},media={})", new Object[]{metaType, this.media});
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(this.media, metaType.intValue()));
    }

    private void setMeta(libvlc_meta_t metaType, String value) {
        Logger.trace("setMeta(metaType={},media={},value={})", new Object[]{metaType, this.media, value});
        this.libvlc.libvlc_media_set_meta(this.media, metaType.intValue(), value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("title=").append(this.getTitle()).append(',');
        sb.append("artist=").append(this.getArtist()).append(',');
        sb.append("genre=").append(this.getGenre()).append(',');
        sb.append("copyright=").append(this.getCopyright()).append(',');
        sb.append("album=").append(this.getAlbum()).append(',');
        sb.append("trackNumber=").append(this.getTrackNumber()).append(',');
        sb.append("description=").append(this.getDescription()).append(',');
        sb.append("rating=").append(this.getRating()).append(',');
        sb.append("date=").append(this.getDate()).append(',');
        sb.append("setting=").append(this.getSetting()).append(',');
        sb.append("url=").append(this.getUrl()).append(',');
        sb.append("language=").append(this.getLanguage()).append(',');
        sb.append("nowPlaying=").append(this.getNowPlaying()).append(',');
        sb.append("publisher=").append(this.getPublisher()).append(',');
        sb.append("encodedBy=").append(this.getEncodedBy()).append(',');
        sb.append("artworkUrl=").append(this.getArtworkUrl()).append(',');
        sb.append("trackId=").append(this.getTrackId()).append(',');
        sb.append("length=").append(this.getLength()).append(']');
        return sb.toString();
    }
}

