/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;
import org.eclipse.swt.internal.cocoa.id;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            fArray[n10] = n + n7 * n9;
            fArray[n10 + 1] = n4;
            fArray[n10 + 2] = fArray[n10] + (float)(n7 / 2);
            fArray[n10 + 3] = n2;
            ++n9;
        }
        fArray[n5 - 2] = n + n7 * n8;
        fArray[n5 - 1] = n4;
        return fArray;
    }

    void computeRuns() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        if (this.lineBounds != null) {
            return;
        }
        String string = this.getSegmentsText();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithCharacters(cArray, cArray.length);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
        nSString.release();
        nSMutableAttributedString.beginEditing();
        Font font = this.font != null ? this.font : this.device.systemFont;
        NSRange nSRange = new NSRange();
        nSRange.length = nSMutableAttributedString.length();
        nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
        nSMutableAttributedString.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), nSRange);
        font.addTraits(nSMutableAttributedString, nSRange);
        NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int n3 = 0;
        if (this.wrapWidth != -1) {
            if (this.justify) {
                n3 = 3;
            } else {
                switch (this.alignment) {
                    case 0x1000000: {
                        n3 = 2;
                        break;
                    }
                    case 131072: {
                        n3 = 1;
                    }
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            nSMutableParagraphStyle.setBaseWritingDirection(1);
        } else {
            nSMutableParagraphStyle.setBaseWritingDirection(0);
        }
        nSMutableParagraphStyle.setAlignment(n3);
        nSMutableParagraphStyle.setLineSpacing(this.spacing);
        nSMutableParagraphStyle.setFirstLineHeadIndent(this.indent);
        nSMutableParagraphStyle.setHeadIndent(this.wrapIndent);
        nSMutableParagraphStyle.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            n2 = this.tabs.length;
            if (n2 == 1) {
                nSMutableParagraphStyle.setDefaultTabInterval(this.tabs[0]);
            } else {
                int n4 = 0;
                n = 0;
                while (n < n2) {
                    n4 = this.tabs[n];
                    NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
                    nSTextTab = nSTextTab.initWithType(0, n4);
                    nSMutableParagraphStyle.addTabStop(nSTextTab);
                    nSTextTab.release();
                    ++n;
                }
                int n5 = this.tabs[n2 - 1] - this.tabs[n2 - 2];
                while (n < 32) {
                    object4 = (NSTextTab)new NSTextTab().alloc();
                    object4 = ((NSTextTab)object4).initWithType(0, n4 += n5);
                    nSMutableParagraphStyle.addTabStop((NSTextTab)object4);
                    ((NSObject)object4).release();
                    ++n;
                }
            }
        }
        nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
        nSMutableParagraphStyle.release();
        n2 = nSMutableAttributedString.length();
        n = 0;
        while (n < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[n];
            if (styleItem.style != null) {
                Object object5;
                Color color;
                TextStyle textStyle = styleItem.style;
                nSRange.location = n2 != 0 ? this.translateOffset(styleItem.start) : 0;
                nSRange.length = this.translateOffset(this.styles[n + 1].start) - nSRange.location;
                object4 = textStyle.font;
                if (object4 != null) {
                    nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, ((Font)object4).handle, nSRange);
                    ((Font)object4).addTraits(nSMutableAttributedString, nSRange);
                }
                if ((color = textStyle.foreground) != null) {
                    object3 = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0f);
                    nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object3, nSRange);
                }
                if ((object3 = textStyle.background) != null) {
                    object5 = NSColor.colorWithDeviceRed(((Color)object3).handle[0], ((Color)object3).handle[1], ((Color)object3).handle[2], 1.0f);
                    nSMutableAttributedString.addAttribute(OS.NSBackgroundColorAttributeName, (id)object5, nSRange);
                }
                if (textStyle.strikeout) {
                    nSMutableAttributedString.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), nSRange);
                    object5 = textStyle.strikeoutColor;
                    if (object5 != null) {
                        object2 = NSColor.colorWithDeviceRed(((Color)object5).handle[0], ((Color)object5).handle[1], ((Color)object5).handle[2], 1.0f);
                        nSMutableAttributedString.addAttribute(OS.NSStrikethroughColorAttributeName, (id)object2, nSRange);
                    }
                }
                if (this.isUnderlineSupported(textStyle)) {
                    int n6 = 0;
                    switch (textStyle.underlineStyle) {
                        case 0: {
                            n6 = 1;
                            break;
                        }
                        case 1: {
                            n6 = 9;
                            break;
                        }
                        case 65536: {
                            n6 = 2;
                            break;
                        }
                        case 4: {
                            n6 = 1;
                            if (color != null) break;
                            object2 = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0f);
                            nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object2, nSRange);
                        }
                    }
                    if (n6 != 0) {
                        nSMutableAttributedString.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(n6), nSRange);
                        object2 = textStyle.underlineColor;
                        if (object2 != null) {
                            object = NSColor.colorWithDeviceRed(((Color)object2).handle[0], ((Color)object2).handle[1], ((Color)object2).handle[2], 1.0f);
                            nSMutableAttributedString.addAttribute(OS.NSUnderlineColorAttributeName, (id)object, nSRange);
                        }
                    }
                }
                if (textStyle.rise != 0) {
                    nSMutableAttributedString.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(textStyle.rise), nSRange);
                }
                if (textStyle.metrics != null) {
                    this.initClasses();
                    char[] cArray2 = new char[nSRange.length];
                    int n7 = 0;
                    while (n7 < cArray2.length) {
                        cArray2[n7] = 65532;
                        ++n7;
                    }
                    object2 = (NSString)new NSString().alloc();
                    object2 = ((NSString)object2).initWithCharacters(cArray2, cArray2.length);
                    nSMutableAttributedString.replaceCharactersInRange(nSRange, (NSString)object2);
                    ((NSObject)object2).release();
                    styleItem.jniRef = OS.NewGlobalRef(styleItem);
                    if (styleItem.jniRef == 0) {
                        SWT.error(2);
                    }
                    styleItem.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
                    OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, styleItem.jniRef);
                    object = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
                    ((NSTextAttachment)object).setAttachmentCell(styleItem.cell);
                    nSMutableAttributedString.addAttribute(OS.NSAttachmentAttributeName, (id)object, nSRange);
                    ((NSObject)object).release();
                }
            }
            ++n;
        }
        nSMutableAttributedString.endEditing();
        NSSize nSSize = new NSSize();
        nSSize.width = this.wrapWidth != -1 ? (float)this.wrapWidth : 5000000.0f;
        nSSize.height = 5000000.0f;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(nSSize);
            this.textContainer.setLineFragmentPadding(0.0f);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(nSSize);
        }
        this.textStorage.setAttributedString(nSMutableAttributedString);
        nSMutableAttributedString.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        int n8 = this.layoutManager.numberOfGlyphs();
        int n9 = OS.malloc(NSRange.sizeof);
        object3 = new NSRange();
        int n10 = 0;
        int n11 = 0;
        while (n11 < n8) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n11, n9, true);
            OS.memmove((NSRange)object3, n9, NSRange.sizeof);
            n11 = ((NSRange)object3).location + ((NSRange)object3).length;
            ++n10;
        }
        if (n10 == 0) {
            ++n10;
        }
        int[] nArray = new int[n10 + 1];
        object2 = new NSRect[n10];
        n10 = 0;
        n11 = 0;
        while (n11 < n8) {
            object2[n10] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n11, n9, true);
            if (n10 < ((NSRect[])object2).length - 1) {
                ((NSRect)object2[n10]).height -= (float)this.spacing;
            }
            OS.memmove((NSRange)object3, n9, NSRange.sizeof);
            nArray[n10] = ((NSRange)object3).location;
            n11 = ((NSRange)object3).location + ((NSRange)object3).length;
            ++n10;
        }
        if (n10 == 0) {
            object = this.font != null ? this.font : this.device.systemFont;
            NSFont nSFont = ((Font)object).handle;
            object2[0] = new NSRect();
            ((NSRect)object2[0]).height = Math.max(this.layoutManager.defaultLineHeightForFont(nSFont), (float)(this.ascent + this.descent));
        }
        OS.free(n9);
        nArray[n10] = this.textStorage.length();
        this.lineOffsets = nArray;
        this.lineBounds = object2;
    }

    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = gC.checkGC(3073);
        try {
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            this.computeRuns();
            int n6 = this.translateOffset(this.text.length());
            if (n6 == 0 && n5 == 0) {
                Object var43_11 = null;
                gC.uncheckGC(nSAutoreleasePool);
                return;
            }
            gC.handle.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            NSRange nSRange = new NSRange();
            int n7 = this.layoutManager.numberOfGlyphs();
            if (n7 > 0) {
                nSRange.location = 0;
                nSRange.length = n7;
                this.layoutManager.drawBackgroundForGlyphRange(nSRange, nSPoint);
            }
            boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
            if (bl || (n5 & 0x100000) != 0 && (n5 & 0x30000) != 0) {
                if (color2 == null) {
                    color2 = this.device.getSystemColor(26);
                }
                object3 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], color2.handle[3]);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                object2 = new NSRect();
                if (bl) {
                    nSRange.location = this.translateOffset(n3);
                    nSRange.length = this.translateOffset(n4 - n3 + 1);
                    object = new int[1];
                    int n8 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, (int[])object);
                    int n9 = 0;
                    while (n9 < object[0]) {
                        OS.memmove((NSRect)object2, n8, NSRect.sizeof);
                        this.fixRect((NSRect)object2);
                        ((NSRect)object2).x += nSPoint.x;
                        ((NSRect)object2).y += nSPoint.y;
                        ((NSRect)object2).height = Math.max(((NSRect)object2).height, (float)(this.ascent + this.descent));
                        nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                        ++n9;
                        n8 += NSRect.sizeof;
                    }
                }
                if ((n5 & 0x30000) != 0 && (n5 & 0x100000) != 0) {
                    object = this.lineBounds[this.lineBounds.length - 1];
                    ((NSRect)object2).x = nSPoint.x + ((NSRect)object).x + ((NSRect)object).width;
                    ((NSRect)object2).y = (float)n2 + ((NSRect)object).y;
                    ((NSRect)object2).width = (n5 & 0x10000) != 0 ? 2.1474836E9f : ((NSRect)object).height / 3.0f;
                    ((NSRect)object2).height = Math.max(((NSRect)object).height, (float)(this.ascent + this.descent));
                    nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                }
                object3.setFill();
                nSBezierPath.fill();
            }
            if (n7 > 0) {
                boolean bl3;
                nSRange.location = 0;
                nSRange.length = n7;
                object3 = gC.data.foreground;
                boolean bl4 = bl3 = object3[0] == 0.0f && object3[1] == 0.0f && object3[2] == 0.0f && object3[3] == 1.0f && gC.data.alpha == 255;
                if (!bl3) {
                    int n10 = 0;
                    while (n10 < this.stylesCount - 1) {
                        object = this.styles[n10];
                        if (!(((StyleItem)object).style != null && ((StyleItem)object).style.foreground != null || ((StyleItem)object).style != null && ((StyleItem)object).style.underline && ((StyleItem)object).style.underlineStyle == 4)) {
                            nSRange.location = n6 != 0 ? this.translateOffset(((StyleItem)object).start) : 0;
                            nSRange.length = this.translateOffset(this.styles[n10 + 1].start) - nSRange.location;
                            this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gC.data.fg, nSRange);
                        }
                        ++n10;
                    }
                }
                nSRange.location = 0;
                nSRange.length = n7;
                this.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
                if (!bl3) {
                    nSRange.location = 0;
                    nSRange.length = n6;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, nSRange);
                }
                object2 = new NSPoint();
                int n11 = 0;
                while (n11 < this.stylesCount) {
                    StyleItem styleItem = this.styles[n11];
                    TextStyle textStyle = styleItem.style;
                    if (textStyle != null) {
                        boolean bl5 = textStyle.underline && !this.isUnderlineSupported(textStyle);
                        bl5 = bl5 && (n11 + 1 == this.stylesCount || !textStyle.isAdherentUnderline(this.styles[n11 + 1].style));
                        boolean bl6 = textStyle.borderStyle != 0;
                        boolean bl7 = bl6 = bl6 && (n11 + 1 == this.stylesCount || !textStyle.isAdherentBorder(this.styles[n11 + 1].style));
                        if (bl5 || bl6) {
                            int n12 = n11 + 1 < this.stylesCount ? this.translateOffset(this.styles[n11 + 1].start - 1) : n6;
                            int n13 = 0;
                            while (n13 < this.lineOffsets.length - 1) {
                                NSBezierPath nSBezierPath;
                                NSRect nSRect;
                                int n14;
                                int n15;
                                int n16 = this.untranslateOffset(this.lineOffsets[n13]);
                                int n17 = this.untranslateOffset(this.lineOffsets[n13 + 1] - 1);
                                if (bl5) {
                                    n15 = styleItem.start;
                                    int n18 = n11;
                                    while (n18 > 0 && textStyle.isAdherentUnderline(this.styles[n18 - 1].style)) {
                                        n15 = this.styles[n18 - 1].start;
                                        --n18;
                                    }
                                    if ((n15 = this.translateOffset(n15)) <= n17 && n12 >= n16) {
                                        nSRange.location = Math.max(n16, n15);
                                        nSRange.length = Math.min(n17, n12) + 1 - nSRange.location;
                                        if (nSRange.length > 0) {
                                            int[] nArray = new int[1];
                                            n14 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, nArray);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            float f = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, n16);
                                            float[] fArray = null;
                                            if (textStyle.underlineColor != null) {
                                                fArray = textStyle.underlineColor.handle;
                                            }
                                            if (fArray == null && textStyle.foreground != null) {
                                                fArray = textStyle.foreground.handle;
                                            }
                                            if (fArray != null) {
                                                NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]).setStroke();
                                            }
                                            int n19 = 0;
                                            while (n19 < nArray[0]) {
                                                OS.memmove(nSRect, n14, NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                float f2 = nSPoint.x + nSRect.x;
                                                float f3 = nSPoint.y + nSRect.y + nSRect.height - f + 1.0f;
                                                nSBezierPath = NSBezierPath.bezierPath();
                                                switch (textStyle.underlineStyle) {
                                                    case 2: {
                                                        nSBezierPath.setLineWidth(2.0f);
                                                        nSBezierPath.setLineCapStyle(1);
                                                        nSBezierPath.setLineJoinStyle(1);
                                                        nSBezierPath.setLineDash(new float[]{1.0f, 3.0f}, 2, 0.0f);
                                                        ((NSPoint)object2).x = f2;
                                                        ((NSPoint)object2).y = f3 + 0.5f;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        ((NSPoint)object2).x = f2 + nSRect.width;
                                                        ((NSPoint)object2).y = f3 + 0.5f;
                                                        nSBezierPath.lineToPoint((NSPoint)object2);
                                                        break;
                                                    }
                                                    case 3: {
                                                        gC.handle.setShouldAntialias(false);
                                                        nSBezierPath.setLineWidth(1.0f);
                                                        nSBezierPath.setLineCapStyle(0);
                                                        nSBezierPath.setLineJoinStyle(0);
                                                        float f4 = nSPoint.y + nSRect.y + nSRect.height;
                                                        float f5 = 1.0f;
                                                        float f6 = 2.0f * f5;
                                                        float f7 = Math.min(f3 - f6 / 2.0f, f4 - f6 - 1.0f);
                                                        float[] fArray2 = this.computePolyline((int)f2, (int)f7, (int)(f2 + nSRect.width), (int)(f7 + f6));
                                                        ((NSPoint)object2).x = fArray2[0] + 0.5f;
                                                        ((NSPoint)object2).y = fArray2[1] + 0.5f;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        int n20 = 2;
                                                        while (n20 < fArray2.length) {
                                                            ((NSPoint)object2).x = fArray2[n20] + 0.5f;
                                                            ((NSPoint)object2).y = fArray2[n20 + 1] + 0.5f;
                                                            nSBezierPath.lineToPoint((NSPoint)object2);
                                                            n20 += 2;
                                                        }
                                                        break;
                                                    }
                                                }
                                                nSBezierPath.stroke();
                                                ++n19;
                                                n14 += NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                if (bl6) {
                                    n15 = styleItem.start;
                                    int n21 = n11;
                                    while (n21 > 0 && textStyle.isAdherentBorder(this.styles[n21 - 1].style)) {
                                        n15 = this.styles[n21 - 1].start;
                                        --n21;
                                    }
                                    if ((n15 = this.translateOffset(n15)) <= n17 && n12 >= n16) {
                                        nSRange.location = Math.max(n16, n15);
                                        nSRange.length = Math.min(n17, n12) + 1 - nSRange.location;
                                        if (nSRange.length > 0) {
                                            int[] nArray = new int[1];
                                            n14 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, nArray);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            float[] fArray = null;
                                            if (textStyle.borderColor != null) {
                                                fArray = textStyle.borderColor.handle;
                                            }
                                            if (fArray == null && textStyle.foreground != null) {
                                                fArray = textStyle.foreground.handle;
                                            }
                                            if (fArray != null) {
                                                NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]).setStroke();
                                            }
                                            boolean bl8 = true;
                                            float[] fArray3 = null;
                                            switch (textStyle.borderStyle) {
                                                case 1: {
                                                    break;
                                                }
                                                case 2: {
                                                    fArray3 = bl8 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                                    break;
                                                }
                                                case 4: {
                                                    fArray3 = bl8 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                                    break;
                                                }
                                            }
                                            float[] fArray4 = null;
                                            if (fArray3 != null) {
                                                fArray4 = new float[fArray3.length];
                                                int n22 = 0;
                                                while (n22 < fArray4.length) {
                                                    fArray4[n22] = !bl8 ? fArray3[n22] : fArray3[n22] * (float)bl8;
                                                    ++n22;
                                                }
                                            }
                                            int n23 = 0;
                                            while (n23 < nArray[0]) {
                                                OS.memmove(nSRect, n14, NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                nSRect.x += nSPoint.x + 0.5f;
                                                nSRect.y += nSPoint.y + 0.5f;
                                                nSRect.width -= 0.5f;
                                                nSRect.height -= 0.5f;
                                                nSBezierPath = NSBezierPath.bezierPath();
                                                nSBezierPath.setLineDash(fArray4, fArray4 != null ? fArray4.length : 0, 0.0f);
                                                nSBezierPath.appendBezierPathWithRect(nSRect);
                                                nSBezierPath.stroke();
                                                ++n23;
                                                n14 += NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                ++n13;
                            }
                        }
                    }
                    ++n11;
                }
            }
            gC.handle.restoreGraphicsState();
            Object var43_13 = null;
            gC.uncheckGC(nSAutoreleasePool);
            return;
        }
        catch (Throwable throwable) {
            Object var43_12 = null;
            gC.uncheckGC(nSAutoreleasePool);
            throw throwable;
        }
    }

    void fixRect(NSRect nSRect) {
        float f = -1.0f;
        int n = 0;
        while (n < this.lineBounds.length) {
            NSRect nSRect2 = this.lineBounds[n];
            if (nSRect.y <= nSRect2.y && nSRect2.y <= nSRect.y + nSRect.height) {
                f = Math.max(f, nSRect2.x + nSRect2.width);
            }
            ++n;
        }
        if (f != -1.0f && nSRect.x + nSRect.width > f) {
            nSRect.width = f - nSRect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        int n = 0;
        while (n < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[n];
            if (styleItem.cell != null) {
                OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, 0);
                styleItem.cell.release();
                styleItem.cell = null;
                OS.DeleteGlobalRef(styleItem.jniRef);
                styleItem.jniRef = 0;
            }
            ++n;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        Rectangle rectangle;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect nSRect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    nSRect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    Font font = this.font != null ? this.font : this.device.systemFont;
                    NSFont nSFont = font.handle;
                    nSRect.height = this.layoutManager.defaultLineHeightForFont(nSFont);
                }
                nSRect.height = Math.max(nSRect.height, (float)(this.ascent + this.descent)) + (float)this.spacing;
                rectangle = new Rectangle(0, 0, (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle;
        block10: {
            int n3;
            NSAutoreleasePool nSAutoreleasePool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            n3 = this.text.length();
                            if (n3 != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var14_8 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        return rectangle3;
                    }
                    if (n <= n2) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var14_9 = null;
                    if (nSAutoreleasePool == null) break block9;
                    nSAutoreleasePool.release();
                }
                return rectangle2;
            }
            try {
                n = Math.min(Math.max(0, n), n3 - 1);
                n2 = Math.min(Math.max(0, n2), n3 - 1);
                n = this.translateOffset(n);
                n2 = this.translateOffset(n2);
                NSRange nSRange = new NSRange();
                nSRange.location = n;
                nSRange.length = n2 - n + 1;
                int[] nArray = new int[1];
                int n4 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, nArray);
                NSRect nSRect = new NSRect();
                int n5 = Integer.MAX_VALUE;
                int n6 = 0;
                int n7 = Integer.MAX_VALUE;
                int n8 = 0;
                int n9 = 0;
                while (n9 < nArray[0]) {
                    OS.memmove(nSRect, n4, NSRect.sizeof);
                    this.fixRect(nSRect);
                    n5 = Math.min(n5, (int)nSRect.x);
                    n6 = Math.max(n6, (int)Math.ceil(nSRect.x + nSRect.width));
                    n7 = Math.min(n7, (int)nSRect.y);
                    n8 = Math.max(n8, (int)Math.ceil(nSRect.y + nSRect.height));
                    ++n9;
                    n4 += NSRect.sizeof;
                }
                rectangle = new Rectangle(n5, n7, n6 - n5, n8 - n7);
                Object var14_10 = null;
                if (nSAutoreleasePool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var14_11 = null;
                    if (nSAutoreleasePool == null) break block11;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int n) {
        byte by;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n2 = this.text.length();
                if (n < 0 || n > n2) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                int n3 = this.layoutManager.glyphIndexForCharacterAtIndex(n);
                NSRange nSRange = new NSRange();
                nSRange.location = n3;
                nSRange.length = 1;
                byte[] byArray = new byte[1];
                this.layoutManager.getGlyphsInRange(nSRange, 0, 0, 0, 0, byArray);
                by = byArray[0];
                Object var7_8 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_9 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return by;
    }

    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] nArray2 = new int[this.lineOffsets.length];
                int n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = this.untranslateOffset(this.lineOffsets[n]);
                    ++n;
                }
                nArray = nArray2;
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int n) {
        int n2;
        NSAutoreleasePool nSAutoreleasePool;
        block7: {
            int n3;
            this.checkLayout();
            nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n4 = this.text.length();
                if (n < 0 || n > n4) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                int n5 = 0;
                while (true) {
                    if (n5 >= this.lineOffsets.length - 1) {
                        n2 = this.lineBounds.length - 1;
                        break block7;
                    }
                    if (this.lineOffsets[n5 + 1] > n) {
                        n3 = n5;
                        Object var5_7 = null;
                        if (nSAutoreleasePool == null) return n3;
                        break;
                    }
                    ++n5;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (nSAutoreleasePool == null) throw throwable;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return n3;
        }
        Object var5_8 = null;
        if (nSAutoreleasePool == null) return n2;
        nSAutoreleasePool.release();
        return n2;
    }

    public Rectangle getLineBounds(int n) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (n < 0 || n >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect nSRect = this.lineBounds[n];
                int n2 = Math.max((int)Math.ceil(nSRect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSRect.width), n2);
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getLineCount() {
        int n;
        block3: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n = this.lineOffsets.length - 1;
                Object var2_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var2_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    public FontMetrics getLineMetrics(int n) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int n2;
                        this.computeRuns();
                        int n3 = this.getLineCount();
                        if (n < 0 || n >= n3) {
                            SWT.error(6);
                        }
                        if ((n2 = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        int n4 = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                        int n5 = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - n4;
                        n4 = Math.max(n4, this.ascent);
                        n5 = Math.max(n5, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(n4, n5, 0, 0, n4 + n5);
                        Object var8_12 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var8_14 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return fontMetrics2;
            }
            Rectangle rectangle = this.getLineBounds(n);
            int n6 = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[n]);
            fontMetrics = FontMetrics.cocoa_new(rectangle.height - n6, n6, 0, 0, rectangle.height);
            Object var8_13 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return fontMetrics;
    }

    public Point getLocation(int n, boolean bl) {
        Point point;
        block13: {
            NSAutoreleasePool nSAutoreleasePool;
            block11: {
                Point point2;
                block12: {
                    int n2;
                    block9: {
                        Point point3;
                        block10: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            try {
                                this.computeRuns();
                                n2 = this.text.length();
                                if (n < 0 || n > n2) {
                                    SWT.error(6);
                                }
                                if (n2 != 0) break block9;
                                point3 = new Point(0, 0);
                                Object var15_8 = null;
                                if (nSAutoreleasePool == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var15_11 = null;
                                    if (nSAutoreleasePool == null) break block14;
                                    nSAutoreleasePool.release();
                                }
                                throw throwable;
                            }
                            nSAutoreleasePool.release();
                        }
                        return point3;
                    }
                    if (n != n2) break block11;
                    NSRect nSRect = this.lineBounds[this.lineBounds.length - 1];
                    point2 = new Point((int)(nSRect.x + nSRect.width), (int)nSRect.y);
                    Object var15_9 = null;
                    if (nSAutoreleasePool == null) break block12;
                    nSAutoreleasePool.release();
                }
                return point2;
            }
            n = this.translateOffset(n);
            int n3 = this.layoutManager.glyphIndexForCharacterAtIndex(n);
            NSRect nSRect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(n3, 0);
            NSPoint nSPoint = this.layoutManager.locationForGlyphAtIndex(n3);
            boolean bl2 = false;
            NSRange nSRange = new NSRange();
            nSRange.location = n3;
            nSRange.length = 1;
            byte[] byArray = new byte[1];
            int n4 = this.layoutManager.getGlyphsInRange(nSRange, 0, 0, 0, 0, byArray);
            if (n4 > 0) {
                boolean bl3 = bl2 = (byArray[0] & 1) != 0;
            }
            if (bl != bl2) {
                int[] nArray = new int[1];
                int n5 = this.layoutManager.rectArrayForGlyphRange(nSRange, nSRange, this.textContainer, nArray);
                if (nArray[0] > 0) {
                    NSRect nSRect2 = new NSRect();
                    OS.memmove(nSRect2, n5, NSRect.sizeof);
                    this.fixRect(nSRect2);
                    nSPoint.x += nSRect2.width;
                }
            }
            point = new Point((int)nSPoint.x, (int)nSRect.y);
            Object var15_10 = null;
            if (nSAutoreleasePool == null) break block13;
            nSAutoreleasePool.release();
        }
        return point;
    }

    public int getNextOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, true);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        switch (n2) {
            case 2: {
                char c;
                if ((n += n3) < 0 || n >= n4 || '\udc00' > (c = this.text.charAt(n)) || c > '\udfff' || n <= 0 || '\ud800' > (c = this.text.charAt(n - 1)) || c > '\udbff') return n;
                n += n3;
                return n;
            }
            case 4: {
                n = this.translateOffset(n);
                n = this.textStorage.nextWordFromIndex(n, bl);
                return this.untranslateOffset(n);
            }
            case 8: {
                n = this.translateOffset(n);
                if (bl) {
                    n = this.textStorage.nextWordFromIndex(n, true);
                    return this.untranslateOffset(n);
                } else {
                    n4 = this.translateOffset(n4);
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = this.textStorage.nextWordFromIndex(n6, true);
                        if (n7 >= n) {
                            n = n6;
                            return this.untranslateOffset(n);
                        }
                        n6 = n7;
                    }
                }
                return this.untranslateOffset(n);
            }
            case 16: {
                n = this.translateOffset(n);
                if (bl) {
                    int n8 = this.translateOffset(n4);
                    while (n8 > 0) {
                        int n9 = this.textStorage.nextWordFromIndex(n8, false);
                        if (n9 <= n) {
                            n = n8;
                            return this.untranslateOffset(n);
                        }
                        n8 = n9;
                    }
                    return this.untranslateOffset(n);
                }
                n = this.textStorage.nextWordFromIndex(n, false);
                return this.untranslateOffset(n);
            }
        }
        return n;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        block9: {
            int n4;
            NSAutoreleasePool nSAutoreleasePool;
            block7: {
                block8: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (nArray != null && nArray.length < 1) {
                            SWT.error(5);
                        }
                        if ((n4 = this.text.length()) != 0) break block7;
                        Object var11_6 = null;
                        if (nSAutoreleasePool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var11_8 = null;
                            if (nSAutoreleasePool == null) break block10;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return 0;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            float[] fArray = new float[1];
            int n5 = this.layoutManager.glyphIndexForPoint(nSPoint, this.textContainer, fArray);
            int n6 = this.layoutManager.characterIndexForGlyphAtIndex(n5);
            n6 = Math.min(this.untranslateOffset(n6), n4 - 1);
            if (nArray != null) {
                char c;
                nArray[0] = Math.round(fArray[0]);
                if ((double)fArray[0] >= 0.5 && '\ud800' <= (c = this.text.charAt(n6)) && c <= '\udbff' && n6 + 1 < n4 && '\udc00' <= (c = this.text.charAt(n6 + 1)) && c <= '\udfff') {
                    nArray[0] = nArray[0] + 1;
                }
            }
            n3 = n6;
            Object var11_7 = null;
            if (nSAutoreleasePool == null) break block9;
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, false);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return this.text;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return this.text;
            }
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n4 < n2) {
            if (n5 < n3 && n4 == this.segments[n5]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
                cArray2[n4 + n5++] = n;
                continue;
            }
            cArray2[n4 + n5] = cArray[n4++];
        }
        while (n5 < n3) {
            this.segments[n5] = n4;
            n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
            cArray2[n4 + n5++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.stylesCount) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String string = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(string) != 0) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        int n = textLayoutCallback2.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        int n2 = OS.CALLBACK_cellBaselineOffset(n);
        int n3 = OS.CALLBACK_NSTextAttachmentCell_cellSize(n);
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] byArray2 = byArray;
        int n4 = C.PTR_SIZEOF;
        int n5 = C.PTR_SIZEOF == 4 ? 2 : 3;
        int n6 = OS.objc_allocateClassPair(OS.class_NSCell, string, 0);
        OS.class_addIvar(n6, SWT_OBJECT, n4, (byte)n5, byArray2);
        OS.class_addProtocol(n6, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(n6, OS.sel_cellSize, n3, "@:");
        OS.class_addMethod(n6, OS.sel_cellBaselineOffset, n2, "@:");
        OS.objc_registerClassPair(n6);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle textStyle) {
        if (textStyle != null && textStyle.underline) {
            int n = textStyle.underlineStyle;
            return n == 0 || n == 1 || n == 4 || n == 65536;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void setAlignment(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setAscent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setDescent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setFont(Font var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 100->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setIndent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setWrapIndent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setJustify(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setOrientation(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSegments(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSegmentsChars(char[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSpacing(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 77->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setStyle(TextStyle var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 731->735)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setTabs(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setText(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 132->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setWidth(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 82->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static int textLayoutProc(int n, int n2) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (nArray[0] == 0) {
            return 0;
        }
        StyleItem styleItem = (StyleItem)OS.JNIGetObject(nArray[0]);
        if (styleItem == null) {
            return 0;
        }
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return 0;
        }
        GlyphMetrics glyphMetrics = textStyle.metrics;
        if (glyphMetrics == null) {
            return 0;
        }
        if (n2 == OS.sel_cellSize) {
            NSSize nSSize = new NSSize();
            nSSize.width = glyphMetrics.width;
            nSSize.height = glyphMetrics.ascent + glyphMetrics.descent;
            int n3 = OS.malloc(NSSize.sizeof);
            OS.memmove(n3, nSSize, NSSize.sizeof);
            return n3;
        }
        if (n2 == OS.sel_cellBaselineOffset) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.y = -glyphMetrics.descent;
            int n4 = OS.malloc(NSPoint.sizeof);
            OS.memmove(n4, nSPoint, NSPoint.sizeof);
            return n4;
        }
        return 0;
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

