/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        Image image;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        NSPoint nSPoint = new NSPoint();
        int n = OS.malloc(NSPoint.sizeof);
        OS.memmove(n, nSPoint, NSPoint.sizeof);
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        NSTableView nSTableView = (NSTableView)this.control.view;
        NSImage nSImage = nSTableView.dragImageForRowsWithIndexes(nSTableView.selectedRowIndexes(), nSTableView.tableColumns(), nSEvent, n);
        OS.memmove(nSPoint, n, NSPoint.sizeof);
        OS.free(n);
        this.dragSourceImage = image = Image.cocoa_new(this.control.getDisplay(), 0, nSImage);
        nSImage.retain();
        dragSourceEvent.offsetX = (int)nSPoint.x;
        dragSourceEvent.offsetY = (int)nSPoint.y;
        return image;
    }
}

