/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui.notify;

import bl.radio.ui.notify.NotificationType;
import bl.radio.ui.notify.cache.ColorCache;
import bl.radio.ui.notify.cache.FontCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class NotifierDialog {
    private static final int MIN_HEGIHT = 80;
    private static final int DISPLAY_TIME = 4500;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private static Color _titleFgColor = ColorCache.getColor(255, 128, 35);
    private static Color _fgColor = ColorCache.getColor(255, 255, 255);
    private static Color _bgFgGradient = ColorCache.getColor(33, 33, 33);
    private static Color _bgBgGradient = ColorCache.getColor(33, 33, 33);
    private static Color _borderColor = ColorCache.getColor(33, 33, 33);
    private static List<Shell> _activeShells = new ArrayList<Shell>();
    private static Image _oldImage;
    private static Shell _shell;

    public static void notify(String string, String string2, NotificationType notificationType) {
        Point point;
        String string32;
        _shell = new Shell(Display.getDefault().getActiveShell(), 540684);
        _shell.setLayout((Layout)new FillLayout());
        _shell.setForeground(_fgColor);
        _shell.setBackgroundMode(1);
        _shell.setImage(NotificationType.RADIOKARAS.getImage());
        _shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                _activeShells.remove(_shell);
            }
        });
        Composite composite = new Composite((Composite)_shell, 0x40000000);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 5;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 5;
        gridLayout.marginBottom = 5;
        composite.setLayout((Layout)gridLayout);
        _shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                try {
                    Rectangle rectangle = _shell.getClientArea();
                    Image image = new Image((Device)Display.getDefault(), Math.max(1, rectangle.width), rectangle.height);
                    GC gC = new GC((Drawable)image);
                    gC.setForeground(_bgFgGradient);
                    gC.setBackground(_bgBgGradient);
                    gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    gC.setLineWidth(2);
                    gC.setForeground(_borderColor);
                    gC.drawRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                    gC.dispose();
                    _shell.setBackgroundImage(image);
                    if (_oldImage != null) {
                        _oldImage.dispose();
                    }
                    _oldImage = image;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        GC gC = new GC((Drawable)_shell);
        String[] stringArray = string2.split("\n");
        Point point2 = null;
        int n = gC.stringExtent((String)"X").y;
        for (String string32 : stringArray) {
            point = gC.stringExtent(string32);
            if (point2 == null) {
                point2 = point;
                continue;
            }
            if (point.x <= point2.x) continue;
            point2 = point;
        }
        gC.dispose();
        int n2 = n * stringArray.length;
        CLabel cLabel = new CLabel(composite, 0);
        cLabel.setLayoutData((Object)new GridData(34));
        cLabel.setImage(notificationType.getImage());
        CLabel cLabel2 = new CLabel(composite, 0);
        cLabel2.setLayoutData((Object)new GridData(772));
        cLabel2.setText(string);
        cLabel2.setForeground(_titleFgColor);
        string32 = cLabel2.getFont();
        point = string32.getFontData()[0];
        point.setStyle(1);
        point.height = 11.0f;
        cLabel2.setFont(FontCache.getFont((FontData)point));
        Label label = new Label(composite, 64);
        Font font = label.getFont();
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(1);
        fontData.height = 8.0f;
        label.setFont(FontCache.getFont(fontData));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setForeground(_fgColor);
        label.setText(string2);
        n2 = 80;
        _shell.setSize(350, n2);
        Display display = Display.getDefault();
        Monitor[] monitorArray = display.getMonitors();
        Rectangle rectangle = monitorArray[0].getClientArea();
        int n3 = rectangle.x + rectangle.width - 352;
        int n4 = rectangle.y + rectangle.height - (n2 + 2);
        if (!_activeShells.isEmpty()) {
            ArrayList<Shell> arrayList = new ArrayList<Shell>(_activeShells);
            Collections.reverse(arrayList);
            for (Shell shell : arrayList) {
                Point point3 = shell.getLocation();
                shell.setLocation(point3.x, point3.y - n2);
                if (point3.y - n2 >= 0) continue;
                _activeShells.remove(shell);
                shell.dispose();
            }
        }
        _shell.setLocation(n3, n4);
        _shell.setAlpha(0);
        _shell.setVisible(true);
        _activeShells.add(_shell);
        NotifierDialog.fadeIn(_shell);
    }

    private static void fadeIn(final Shell shell) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int n = shell.getAlpha();
                    if ((n += 30) > 225) {
                        shell.setAlpha(225);
                        NotifierDialog.startTimer(shell);
                        return;
                    }
                    shell.setAlpha(n);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, runnable);
    }

    private static void startTimer(final Shell shell) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    NotifierDialog.fadeOut(shell);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(4500, runnable);
    }

    private static void fadeOut(final Shell shell) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int n = shell.getAlpha();
                    if ((n -= 8) <= 0) {
                        shell.setAlpha(0);
                        if (_oldImage != null) {
                            _oldImage.dispose();
                        }
                        shell.dispose();
                        _activeShells.remove(shell);
                        return;
                    }
                    shell.setAlpha(n);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, runnable);
    }
}

