/*
 * Decompiled with CFR 0.152.
 */
package bl.radio;

import bl.radio.config.Configuration;
import bl.radio.config.ListedProperty;
import bl.radio.config.Properties;
import bl.radio.config.Property;
import bl.radio.config.StationModel;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.core.ValueRequiredException;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;

public class ConfigBox {
    private static Logger logger = (Logger)LoggerFactory.getLogger(ConfigBox.class);
    private static ConfigBox configBox = null;
    private Configuration config;
    private String applicationPath = new File(".").getAbsoluteFile().getParent();
    private File conf = new File(this.applicationPath, "rkConf.xml");
    private MediaPlayerFactory mediaPlayerFactory;

    private ConfigBox() throws Exception {
        this.loadConfig();
        this.mediaPlayerFactory = new MediaPlayerFactory();
    }

    public static ConfigBox getInstance() throws Exception {
        if (configBox == null) {
            configBox = new ConfigBox();
        }
        return configBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() throws Exception {
        ConfigBox configBox = this;
        synchronized (configBox) {
            try {
                Persister persister = new Persister();
                this.config = (Configuration)persister.read(Configuration.class, this.conf);
            }
            catch (ValueRequiredException valueRequiredException) {
                logger.error("loadConfig...", (Throwable)valueRequiredException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws Exception {
        ConfigBox configBox = this;
        synchronized (configBox) {
            try {
                Persister persister = new Persister();
                persister.write((Object)this.config, this.conf);
            }
            catch (ValueRequiredException valueRequiredException) {
                logger.error("saveConfig...", (Throwable)valueRequiredException);
            }
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ListedProperty getListedProperty(String string, String string2) throws Exception {
        List list = (List)PropertyUtils.getProperty((Object)this.config, (String)"config");
        for (Properties properties : list) {
            if (!string.equals(properties.getName())) continue;
            for (ListedProperty listedProperty : properties.getList()) {
                if (!string2.equals(listedProperty.getName())) continue;
                return listedProperty;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListedProperty(String string, String string2, ListedProperty listedProperty) throws Exception {
        ConfigBox configBox = this;
        synchronized (configBox) {
            List list = (List)PropertyUtils.getProperty((Object)this.config, (String)"config");
            for (Properties properties : list) {
                if (!string.equals(properties.getName())) continue;
                for (ListedProperty listedProperty2 : properties.getList()) {
                    if (!string2.equals(listedProperty2.getName())) continue;
                    listedProperty2 = listedProperty;
                }
            }
        }
    }

    public Object getConfigValue(String string, String string2) throws Exception {
        List list = (List)PropertyUtils.getProperty((Object)this.config, (String)"config");
        for (Properties properties : list) {
            if (!string.equals(properties.getName())) continue;
            List<Property> list2 = properties.getProperty();
            for (Property property : list2) {
                if (!string2.equals(property.getName())) continue;
                return property.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigValue(String string, String string2, Object object) throws Exception {
        ConfigBox configBox = this;
        synchronized (configBox) {
            List list = (List)PropertyUtils.getProperty((Object)this.config, (String)"config");
            for (Properties properties : list) {
                if (!string.equals(properties.getName())) continue;
                List<Property> list2 = properties.getProperty();
                for (Property property : list2) {
                    if (!string2.equals(property.getName())) continue;
                    property.setValue(object.toString());
                }
            }
        }
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public String getStringVal(String string, String string2) throws Exception {
        return this.getConfigValue(string, string2).toString();
    }

    public int getIntVal(String string, String string2) throws Exception {
        return Integer.parseInt(this.getConfigValue(string, string2).toString());
    }

    public float getFloatVal(String string, String string2) throws Exception {
        return Float.parseFloat(this.getConfigValue(string, string2).toString());
    }

    public boolean getBoolVal(String string, String string2) throws Exception {
        return Boolean.parseBoolean(this.getConfigValue(string, string2).toString());
    }

    public List<StationModel> getStationModels() throws Exception {
        ArrayList<StationModel> arrayList = new ArrayList<StationModel>();
        ListedProperty listedProperty = this.getListedProperty("radioKaras", "stations");
        for (Property property : listedProperty.getProperties()) {
            StationModel stationModel = new StationModel();
            stationModel.setName(property.getName());
            ListedProperty listedProperty2 = property.getList().get(0);
            for (Property property2 : listedProperty2.getProperties()) {
                if (property2.getName().equals("url")) {
                    stationModel.setUrl(property2.getValue());
                }
                if (property2.getName().equals("displayName")) {
                    stationModel.setDisplayName(property2.getValue());
                }
                if (property2.getName().equals("clowler")) {
                    stationModel.setClowler(property2.getValue());
                }
                if (property2.getName().equals("isDirectDb")) {
                    stationModel.setDirectDb(new Boolean(property2.getValue()));
                }
                if (property2.getName().equals("hasGenre")) {
                    stationModel.setHasGenre(new Boolean(property2.getValue()));
                }
                if (!property2.getName().equals("isEnabled")) continue;
                stationModel.setEnabled(new Boolean(property2.getValue()));
            }
            if (!stationModel.isEnabled()) continue;
            arrayList.add(stationModel);
        }
        return arrayList;
    }

    public MediaPlayerFactory getMediaPlayerFactory() {
        if (this.mediaPlayerFactory == null) {
            this.mediaPlayerFactory = new MediaPlayerFactory();
        }
        return this.mediaPlayerFactory;
    }
}

