/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    int transparentPixel = -1;
    int transparentColor = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    ImageData data;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        device = this.device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBounds();
        this.type = image.type;
        block0 : switch (n) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        int n2 = device.internal_new_GC(null);
                        int n3 = OS.CreateCompatibleDC(n2);
                        int n4 = OS.CreateCompatibleDC(n2);
                        int n5 = OS.SelectObject(n3, image.handle);
                        BITMAP bITMAP = new BITMAP();
                        OS.GetObject(image.handle, BITMAP.sizeof, bITMAP);
                        this.handle = OS.CreateCompatibleBitmap(n3, rectangle.width, bITMAP.bmBits != 0 ? -rectangle.height : rectangle.height);
                        if (this.handle == 0) {
                            SWT.error(2);
                        }
                        int n6 = OS.SelectObject(n4, this.handle);
                        OS.BitBlt(n4, 0, 0, rectangle.width, rectangle.height, n3, 0, 0, 0xCC0020);
                        OS.SelectObject(n3, n5);
                        OS.SelectObject(n4, n6);
                        OS.DeleteDC(n3);
                        OS.DeleteDC(n4);
                        device.internal_dispose_GC(n2, null);
                        this.transparentPixel = image.transparentPixel;
                        this.alpha = image.alpha;
                        if (image.alphaData == null) break block0;
                        this.alphaData = new byte[image.alphaData.length];
                        System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        if (OS.IsWinCE) {
                            this.init(image.data);
                            break;
                        }
                        this.handle = OS.CopyImage(image.handle, 1, rectangle.width, rectangle.height, 0);
                        if (this.handle != 0) break block0;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                RGB[] rGBArray = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData imageData2 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                imageData2.alpha = imageData.alpha;
                imageData2.alphaData = imageData.alphaData;
                imageData2.maskData = imageData.maskData;
                imageData2.maskPad = imageData.maskPad;
                if (imageData.transparentPixel != -1) {
                    imageData2.transparentPixel = 0;
                }
                int[] nArray = new int[rectangle.width];
                int[] nArray2 = null;
                ImageData imageData3 = null;
                if (imageData.maskData != null) {
                    imageData3 = imageData.getTransparencyMask();
                }
                if (imageData3 != null) {
                    nArray2 = new int[rectangle.width];
                }
                int n7 = paletteData.redMask;
                int n8 = paletteData.greenMask;
                int n9 = paletteData.blueMask;
                int n10 = paletteData.redShift;
                int n11 = paletteData.greenShift;
                int n12 = paletteData.blueShift;
                int n13 = 0;
                while (n13 < rectangle.height) {
                    int n14 = n13 * imageData2.bytesPerLine;
                    imageData.getPixels(0, n13, rectangle.width, nArray, 0);
                    if (imageData3 != null) {
                        imageData3.getPixels(0, n13, rectangle.width, nArray2, 0);
                    }
                    int n15 = 0;
                    while (n15 < rectangle.width) {
                        int n16 = nArray[n15];
                        if (!(imageData.transparentPixel != -1 && n16 == imageData.transparentPixel || imageData3 != null && nArray2[n15] == 0)) {
                            int n17;
                            int n18;
                            int n19;
                            if (paletteData.isDirect) {
                                n19 = n16 & n7;
                                n19 = n10 < 0 ? n19 >>> -n10 : n19 << n10;
                                n18 = n16 & n8;
                                n18 = n11 < 0 ? n18 >>> -n11 : n18 << n11;
                                n17 = n16 & n9;
                                n17 = n12 < 0 ? n17 >>> -n12 : n17 << n12;
                            } else {
                                n19 = paletteData.colors[n16].red;
                                n18 = paletteData.colors[n16].green;
                                n17 = paletteData.colors[n16].blue;
                            }
                            int n20 = n19 * n19 + n18 * n18 + n17 * n17;
                            imageData2.data[n14] = n20 < 98304 ? 1 : 2;
                        }
                        ++n14;
                        ++n15;
                    }
                    ++n13;
                }
                this.init(imageData2);
                break;
            }
            case 2: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                ImageData imageData4 = imageData;
                if (!paletteData.isDirect) {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n21 = 0;
                    while (n21 < rGBArray.length) {
                        if (imageData.transparentPixel != n21) {
                            int n22;
                            RGB rGB = rGBArray[n21];
                            int n23 = rGB.red;
                            int n24 = rGB.green;
                            int n25 = rGB.blue;
                            rGB.green = rGB.blue = (n22 = n23 + n23 + n24 + n24 + n24 + n24 + n24 + n25 >> 3);
                            rGB.red = rGB.blue;
                        }
                        ++n21;
                    }
                    imageData4.palette = new PaletteData(rGBArray);
                } else {
                    RGB[] rGBArray = new RGB[256];
                    int n26 = 0;
                    while (n26 < rGBArray.length) {
                        rGBArray[n26] = new RGB(n26, n26, n26);
                        ++n26;
                    }
                    imageData4 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                    imageData4.alpha = imageData.alpha;
                    imageData4.alphaData = imageData.alphaData;
                    imageData4.maskData = imageData.maskData;
                    imageData4.maskPad = imageData.maskPad;
                    if (imageData.transparentPixel != -1) {
                        imageData4.transparentPixel = 254;
                    }
                    int[] nArray = new int[rectangle.width];
                    int n27 = paletteData.redMask;
                    int n28 = paletteData.greenMask;
                    int n29 = paletteData.blueMask;
                    int n30 = paletteData.redShift;
                    int n31 = paletteData.greenShift;
                    int n32 = paletteData.blueShift;
                    int n33 = 0;
                    while (n33 < rectangle.height) {
                        int n34 = n33 * imageData4.bytesPerLine;
                        imageData.getPixels(0, n33, rectangle.width, nArray, 0);
                        int n35 = 0;
                        while (n35 < rectangle.width) {
                            int n36 = nArray[n35];
                            if (n36 != imageData.transparentPixel) {
                                int n37 = n36 & n27;
                                n37 = n30 < 0 ? n37 >>> -n30 : n37 << n30;
                                int n38 = n36 & n28;
                                n38 = n31 < 0 ? n38 >>> -n31 : n38 << n31;
                                int n39 = n36 & n29;
                                n39 = n32 < 0 ? n39 >>> -n32 : n39 << n32;
                                int n40 = n37 + n37 + n38 + n38 + n38 + n38 + n38 + n39 >> 3;
                                if (imageData4.transparentPixel == n40) {
                                    n40 = 255;
                                }
                                imageData4.data[n34] = (byte)n40;
                            } else {
                                imageData4.data[n34] = -2;
                            }
                            ++n34;
                            ++n35;
                        }
                        ++n33;
                    }
                }
                this.init(imageData4);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        Image.init(this.device, this, imageData, imageData2);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        this.initNative(string);
        if (this.handle == 0) {
            this.init(new ImageData(string));
        }
        this.init();
    }

    void initNative(String string) {
        boolean bl = true;
        try {
            this.device.checkGDIP();
        }
        catch (SWTException sWTException) {
            bl = false;
        }
        if (bl && OS.PTR_SIZEOF == 8 && string.toLowerCase().endsWith(".gif")) {
            bl = false;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1) && string.toLowerCase().endsWith(".gif")) {
            bl = false;
        }
        if (bl) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n2 = Gdip.Bitmap_new(cArray, false);
            if (n2 != 0) {
                int n3 = 2;
                int n4 = Gdip.Image_GetLastStatus(n2);
                if (n4 == 0) {
                    if (string.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        int[] nArray = new int[1];
                        n4 = Gdip.Bitmap_GetHICON(n2, nArray);
                        this.handle = nArray[0];
                    } else {
                        this.type = 0;
                        int n5 = Gdip.Image_GetWidth(n2);
                        int n6 = Gdip.Image_GetHeight(n2);
                        int n7 = Gdip.Image_GetPixelFormat(n2);
                        switch (n7) {
                            case 135173: 
                            case 135174: {
                                this.handle = Image.createDIB(n5, n6, 16);
                                break;
                            }
                            case 8207: 
                            case 137224: {
                                this.handle = Image.createDIB(n5, n6, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                this.handle = Image.createDIB(n5, n6, 32);
                            }
                        }
                        if (this.handle != 0) {
                            int n8 = this.device.internal_new_GC(null);
                            int n9 = OS.CreateCompatibleDC(n8);
                            int n10 = OS.SelectObject(n9, this.handle);
                            int n11 = Gdip.Graphics_new(n9);
                            if (n11 != 0) {
                                Rect rect = new Rect();
                                rect.Width = n5;
                                rect.Height = n6;
                                n4 = Gdip.Graphics_DrawImage(n11, n2, rect, 0, 0, n5, n6, 2, 0, 0, 0);
                                if (n4 != 0) {
                                    n3 = 40;
                                    OS.DeleteObject(this.handle);
                                    this.handle = 0;
                                }
                                Gdip.Graphics_delete(n11);
                            }
                            OS.SelectObject(n9, n10);
                            OS.DeleteDC(n9);
                            this.device.internal_dispose_GC(n8, null);
                        } else {
                            int n12 = Gdip.BitmapData_new();
                            if (n12 != 0) {
                                n4 = Gdip.Bitmap_LockBits(n2, 0, 0, n7, n12);
                                if (n4 == 0) {
                                    BitmapData bitmapData = new BitmapData();
                                    Gdip.MoveMemory(bitmapData, n12);
                                    int n13 = bitmapData.Stride;
                                    int n14 = bitmapData.Scan0;
                                    int n15 = 0;
                                    int n16 = 4;
                                    int n17 = -1;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: {
                                            n15 = 1;
                                            break;
                                        }
                                        case 197634: {
                                            n15 = 4;
                                            break;
                                        }
                                        case 198659: {
                                            n15 = 8;
                                            break;
                                        }
                                        case 135173: 
                                        case 135174: 
                                        case 397319: {
                                            n15 = 16;
                                            break;
                                        }
                                        case 137224: {
                                            n15 = 24;
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            n15 = 32;
                                        }
                                    }
                                    if (n15 != 0) {
                                        int n18;
                                        PaletteData paletteData = null;
                                        switch (bitmapData.PixelFormat) {
                                            case 196865: 
                                            case 197634: 
                                            case 198659: {
                                                int n19 = Gdip.Image_GetPaletteSize(n2);
                                                int n20 = OS.GetProcessHeap();
                                                n18 = OS.HeapAlloc(n20, 8, n19);
                                                if (n18 == 0) {
                                                    SWT.error(2);
                                                }
                                                Gdip.Image_GetPalette(n2, n18, n19);
                                                ColorPalette colorPalette = new ColorPalette();
                                                Gdip.MoveMemory(colorPalette, n18, ColorPalette.sizeof);
                                                int[] nArray = new int[colorPalette.Count];
                                                OS.MoveMemory(nArray, n18 + 8, nArray.length * 4);
                                                OS.HeapFree(n20, 0, n18);
                                                RGB[] rGBArray = new RGB[colorPalette.Count];
                                                paletteData = new PaletteData(rGBArray);
                                                int n21 = 0;
                                                while (n21 < nArray.length) {
                                                    if ((nArray[n21] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                        n17 = n21;
                                                    }
                                                    rGBArray[n21] = new RGB((nArray[n21] & 0xFF0000) >> 16, (nArray[n21] & 0xFF00) >> 8, (nArray[n21] & 0xFF) >> 0);
                                                    ++n21;
                                                }
                                                break;
                                            }
                                            case 135173: 
                                            case 397319: {
                                                paletteData = new PaletteData(31744, 992, 31);
                                                break;
                                            }
                                            case 135174: {
                                                paletteData = new PaletteData(63488, 2016, 31);
                                                break;
                                            }
                                            case 137224: {
                                                paletteData = new PaletteData(255, 65280, 0xFF0000);
                                                break;
                                            }
                                            case 139273: 
                                            case 2498570: {
                                                paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                            }
                                        }
                                        byte[] byArray = new byte[n13 * n6];
                                        byte[] byArray2 = null;
                                        OS.MoveMemory(byArray, n14, byArray.length);
                                        switch (bitmapData.PixelFormat) {
                                            case 397319: {
                                                byArray2 = new byte[n5 * n6];
                                                n18 = 1;
                                                int n22 = 0;
                                                while (n18 < byArray.length) {
                                                    byArray2[n22] = (byte)((byArray[n18] & 0x80) != 0 ? 255 : 0);
                                                    n18 += 2;
                                                    ++n22;
                                                }
                                                break;
                                            }
                                            case 2498570: {
                                                byArray2 = new byte[n5 * n6];
                                                n18 = 3;
                                                int n23 = 0;
                                                while (n18 < byArray.length) {
                                                    byArray2[n23] = byArray[n18];
                                                    n18 += 4;
                                                    ++n23;
                                                }
                                                break;
                                            }
                                        }
                                        ImageData imageData = new ImageData(n5, n6, n15, paletteData, n16, byArray);
                                        imageData.transparentPixel = n17;
                                        imageData.alphaData = byArray2;
                                        this.init(imageData);
                                    }
                                    Gdip.Bitmap_UnlockBits(n2, n12);
                                } else {
                                    n3 = 40;
                                }
                                Gdip.BitmapData_delete(n12);
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete(n2);
                if (n4 == 0 && this.handle == 0) {
                    SWT.error(n3);
                }
            }
        }
    }

    int createDIBFromDDB(int n, int n2, int n3, int n4) {
        int[] nArray;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        int n9;
        int n10 = OS.GetDeviceCaps(n, 12);
        int n11 = n10 * (n9 = OS.GetDeviceCaps(n, 14));
        boolean bl = n11 > 8;
        RGB[] rGBArray = null;
        if (!bl) {
            n8 = 1 << n11;
            object = new byte[4 * n8];
            OS.GetPaletteEntries(this.device.hPalette, 0, n8, (byte[])object);
            rGBArray = new RGB[n8];
            int n12 = 0;
            while (n12 < n8) {
                rGBArray[n12] = new RGB((int)(object[n12] & 0xFF), (int)(object[n12 + 1] & 0xFF), (int)(object[n12 + 2] & 0xFF));
                ++n12;
            }
        }
        n8 = OS.IsWinCE && (n11 == 16 || n11 == 32) ? 1 : 0;
        object = new BITMAPINFOHEADER();
        ((BITMAPINFOHEADER)object).biSize = BITMAPINFOHEADER.sizeof;
        ((BITMAPINFOHEADER)object).biWidth = n3;
        ((BITMAPINFOHEADER)object).biHeight = -n4;
        ((BITMAPINFOHEADER)object).biPlanes = 1;
        ((BITMAPINFOHEADER)object).biBitCount = (short)n11;
        ((BITMAPINFOHEADER)object).biCompression = n8 != 0 ? 3 : 0;
        byte[] byArray = bl ? new byte[BITMAPINFOHEADER.sizeof + (n8 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + rGBArray.length * 4];
        OS.MoveMemory(byArray, (BITMAPINFOHEADER)object, BITMAPINFOHEADER.sizeof);
        int n13 = BITMAPINFOHEADER.sizeof;
        if (bl) {
            if (n8 != 0) {
                n7 = 0;
                n6 = 0;
                n5 = 0;
                switch (n11) {
                    case 16: {
                        n7 = 31744;
                        n6 = 992;
                        n5 = 31;
                        byArray[n13] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n13 + 1] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n13 + 2] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n13 + 3] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n13 + 4] = (byte)((n6 & 0xFF) >> 0);
                        byArray[n13 + 5] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n13 + 6] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n13 + 7] = (byte)((n6 & 0xFF000000) >> 24);
                        byArray[n13 + 8] = (byte)((n5 & 0xFF) >> 0);
                        byArray[n13 + 9] = (byte)((n5 & 0xFF00) >> 8);
                        byArray[n13 + 10] = (byte)((n5 & 0xFF0000) >> 16);
                        byArray[n13 + 11] = (byte)((n5 & 0xFF000000) >> 24);
                        break;
                    }
                    case 32: {
                        n7 = 65280;
                        n6 = 0xFF0000;
                        n5 = -16777216;
                        byArray[n13] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n13 + 1] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n13 + 2] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n13 + 3] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n13 + 4] = (byte)((n6 & 0xFF000000) >> 24);
                        byArray[n13 + 5] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n13 + 6] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n13 + 7] = (byte)((n6 & 0xFF) >> 0);
                        byArray[n13 + 8] = (byte)((n5 & 0xFF000000) >> 24);
                        byArray[n13 + 9] = (byte)((n5 & 0xFF0000) >> 16);
                        byArray[n13 + 10] = (byte)((n5 & 0xFF00) >> 8);
                        byArray[n13 + 11] = (byte)((n5 & 0xFF) >> 0);
                        break;
                    }
                    default: {
                        SWT.error(38);
                        break;
                    }
                }
            }
        } else {
            n7 = 0;
            while (n7 < rGBArray.length) {
                byArray[n13] = (byte)rGBArray[n7].blue;
                byArray[n13 + 1] = (byte)rGBArray[n7].green;
                byArray[n13 + 2] = (byte)rGBArray[n7].red;
                byArray[n13 + 3] = 0;
                n13 += 4;
                ++n7;
            }
        }
        if ((n6 = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        n5 = OS.CreateCompatibleDC(n);
        int n14 = OS.CreateCompatibleDC(n);
        int n15 = OS.SelectObject(n5, n2);
        int n16 = OS.SelectObject(n14, n6);
        OS.BitBlt(n14, 0, 0, n3, n4, n5, 0, 0, 0xCC0020);
        OS.SelectObject(n5, n15);
        OS.SelectObject(n14, n16);
        OS.DeleteDC(n5);
        OS.DeleteDC(n14);
        return n6;
    }

    int[] createGdipImage() {
        switch (this.type) {
            case 0: {
                if (this.alpha != -1 || this.alphaData != null || this.transparentPixel != -1) {
                    int n;
                    int n2;
                    int n3;
                    byte[] byArray;
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                    int n4 = bITMAP.bmWidth;
                    int n5 = bITMAP.bmHeight;
                    int n6 = this.device.internal_new_GC(null);
                    int n7 = OS.CreateCompatibleDC(n6);
                    int n8 = OS.SelectObject(n7, this.handle);
                    int n9 = OS.CreateCompatibleDC(n6);
                    int n10 = Image.createDIB(n4, n5, 32);
                    if (n10 == 0) {
                        SWT.error(2);
                    }
                    int n11 = OS.SelectObject(n9, n10);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(n10, BITMAP.sizeof, bITMAP2);
                    int n12 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(n9, 0, 0, n4, n5, n7, 0, 0, 0xCC0020);
                    byte by = 0;
                    byte by2 = 0;
                    byte by3 = 0;
                    if (this.transparentPixel != -1) {
                        if (bITMAP.bmBitsPixel <= 8) {
                            byArray = new byte[4];
                            OS.GetDIBColorTable(n7, this.transparentPixel, 1, byArray);
                            by3 = byArray[0];
                            by2 = byArray[1];
                            by = byArray[2];
                        } else {
                            switch (bITMAP.bmBitsPixel) {
                                case 16: {
                                    int n13 = 31;
                                    n3 = ImageData.getChannelShift(n13);
                                    byte[] byArray2 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n13, n3)];
                                    by3 = byArray2[(this.transparentPixel & n13) >> n3];
                                    n2 = 992;
                                    n = ImageData.getChannelShift(n2);
                                    byte[] byArray3 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n2, n)];
                                    by2 = byArray3[(this.transparentPixel & n2) >> n];
                                    int n14 = 31744;
                                    int n15 = ImageData.getChannelShift(n14);
                                    byte[] byArray4 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n14, n15)];
                                    by = byArray4[(this.transparentPixel & n14) >> n15];
                                    break;
                                }
                                case 24: {
                                    by3 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by2 = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    by = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    by3 = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    by2 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                    }
                    OS.SelectObject(n7, n8);
                    OS.SelectObject(n9, n11);
                    OS.DeleteObject(n7);
                    OS.DeleteObject(n9);
                    byArray = new byte[n12];
                    OS.MoveMemory(byArray, bITMAP2.bmBits, n12);
                    OS.DeleteObject(n10);
                    this.device.internal_dispose_GC(n6, null);
                    if (this.alpha != -1) {
                        n3 = 0;
                        int n16 = 0;
                        while (n3 < n5) {
                            n2 = 0;
                            while (n2 < n4) {
                                byArray[n16 + 3] = (byte)this.alpha;
                                n16 += 4;
                                ++n2;
                            }
                            ++n3;
                        }
                    } else if (this.alphaData != null) {
                        n3 = 0;
                        int n17 = 0;
                        n2 = 0;
                        while (n3 < n5) {
                            n = 0;
                            while (n < n4) {
                                byArray[n17 + 3] = this.alphaData[n2++];
                                n17 += 4;
                                ++n;
                            }
                            ++n3;
                        }
                    } else if (this.transparentPixel != -1) {
                        n3 = 0;
                        int n18 = 0;
                        while (n3 < n5) {
                            n2 = 0;
                            while (n2 < n4) {
                                byArray[n18 + 3] = byArray[n18] == by3 && byArray[n18 + 1] == by2 && byArray[n18 + 2] == by ? 0 : -1;
                                n18 += 4;
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    n3 = OS.GetProcessHeap();
                    int n19 = OS.HeapAlloc(n3, 8, byArray.length);
                    if (n19 == 0) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(n19, byArray, n12);
                    return new int[]{Gdip.Bitmap_new(n4, n5, bITMAP2.bmWidthBytes, 2498570, n19), n19};
                }
                int[] nArray = new int[2];
                nArray[0] = Gdip.Bitmap_new(this.handle, 0);
                return nArray;
            }
            case 1: {
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    Image.GetIconInfo(this, iCONINFO);
                } else {
                    OS.GetIconInfo(this.handle, iCONINFO);
                }
                int n = iCONINFO.hbmColor;
                if (n == 0) {
                    n = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n, BITMAP.sizeof, bITMAP);
                int n20 = bITMAP.bmWidth;
                int n21 = n == iCONINFO.hbmMask ? bITMAP.bmHeight / 2 : bITMAP.bmHeight;
                int n22 = 0;
                int n23 = 0;
                if (n20 > n21 || bITMAP.bmBitsPixel == 32) {
                    int n24 = this.device.internal_new_GC(null);
                    int n25 = OS.CreateCompatibleDC(n24);
                    int n26 = OS.SelectObject(n25, n);
                    int n27 = OS.CreateCompatibleDC(n24);
                    int n28 = Image.createDIB(n20, n21, 32);
                    if (n28 == 0) {
                        SWT.error(2);
                    }
                    int n29 = OS.SelectObject(n27, n28);
                    BITMAP bITMAP3 = new BITMAP();
                    OS.GetObject(n28, BITMAP.sizeof, bITMAP3);
                    OS.BitBlt(n27, 0, 0, n20, n21, n25, 0, n == iCONINFO.hbmMask ? n21 : 0, 0xCC0020);
                    OS.SelectObject(n27, n29);
                    OS.DeleteObject(n27);
                    byte[] byArray = new byte[bITMAP3.bmWidthBytes * bITMAP3.bmHeight];
                    OS.MoveMemory(byArray, bITMAP3.bmBits, byArray.length);
                    OS.DeleteObject(n28);
                    OS.SelectObject(n25, iCONINFO.hbmMask);
                    int n30 = 0;
                    int n31 = 3;
                    while (n30 < n21) {
                        int n32 = 0;
                        while (n32 < n20) {
                            if (byArray[n31] == 0) {
                                byArray[n31] = OS.GetPixel(n25, n32, n30) != 0 ? 0 : -1;
                            }
                            n31 += 4;
                            ++n32;
                        }
                        ++n30;
                    }
                    OS.SelectObject(n25, n26);
                    OS.DeleteObject(n25);
                    this.device.internal_dispose_GC(n24, null);
                    n30 = OS.GetProcessHeap();
                    n23 = OS.HeapAlloc(n30, 8, byArray.length);
                    if (n23 == 0) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(n23, byArray, byArray.length);
                    n22 = Gdip.Bitmap_new(n20, n21, bITMAP3.bmWidthBytes, 2498570, n23);
                } else {
                    n22 = Gdip.Bitmap_new(this.handle);
                }
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                return new int[]{n22, n23};
            }
        }
        SWT.error(40);
        return null;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            if (OS.IsWinCE) {
                this.data = null;
            }
            OS.DestroyIcon(this.handle);
        } else {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        int n2 = OS.CreateCompatibleDC(n);
        int n3 = OS.SelectObject(n2, this.handle);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bITMAP.bmBitsPixel <= 8) {
            if (OS.IsWinCE) {
                byte[] byArray = new byte[1];
                OS.MoveMemory(byArray, bITMAP.bmBits, 1);
                byte by = byArray[0];
                int n7 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                byArray[0] = (byte)(this.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray[0] & ~n7);
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                int n8 = OS.GetPixel(n2, 0, 0);
                byArray[0] = by;
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                n6 = (n8 & 0xFF0000) >> 16;
                n5 = (n8 & 0xFF00) >> 8;
                n4 = n8 & 0xFF;
            } else {
                byte[] byArray = new byte[4];
                OS.GetDIBColorTable(n2, this.transparentPixel, 1, byArray);
                n6 = byArray[0] & 0xFF;
                n5 = byArray[1] & 0xFF;
                n4 = byArray[2] & 0xFF;
            }
        } else {
            switch (bITMAP.bmBitsPixel) {
                case 16: {
                    n6 = (this.transparentPixel & 0x1F) << 3;
                    n5 = (this.transparentPixel & 0x3E0) >> 2;
                    n4 = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    n6 = (this.transparentPixel & 0xFF0000) >> 16;
                    n5 = (this.transparentPixel & 0xFF00) >> 8;
                    n4 = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    n6 = (this.transparentPixel & 0xFF000000) >>> 24;
                    n5 = (this.transparentPixel & 0xFF0000) >> 16;
                    n4 = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(n2, n3);
        OS.DeleteDC(n2);
        this.device.internal_dispose_GC(n, null);
        return Color.win32_new(this.device, n6 << 16 | n5 << 8 | n4);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        switch (this.type) {
            case 0: {
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
            case 1: {
                if (OS.IsWinCE) {
                    this.width = this.data.width;
                    this.height = this.data.height;
                    return new Rectangle(0, 0, this.width, this.height);
                }
                ICONINFO iCONINFO = new ICONINFO();
                OS.GetIconInfo(this.handle, iCONINFO);
                int n = iCONINFO.hbmColor;
                if (n == 0) {
                    n = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n, BITMAP.sizeof, bITMAP);
                if (n == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
        }
        SWT.error(40);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int n;
                int n2;
                Object[] objectArray;
                int n3;
                if (OS.IsWinCE) {
                    return this.data;
                }
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetIconInfo(this.handle, iCONINFO);
                int n4 = iCONINFO.hbmColor;
                if (n4 == 0) {
                    n4 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n4, BITMAP.sizeof, bITMAP);
                int n5 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n6 = bITMAP.bmWidth;
                if (n4 == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                int n7 = bITMAP.bmHeight;
                int n8 = 0;
                if (n5 <= 8) {
                    n8 = 1 << n5;
                }
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                bITMAPINFOHEADER.biWidth = n6;
                bITMAPINFOHEADER.biHeight = -n7;
                bITMAPINFOHEADER.biPlanes = 1;
                bITMAPINFOHEADER.biBitCount = (short)n5;
                bITMAPINFOHEADER.biCompression = 0;
                byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n8 * 4];
                OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                int n9 = this.device.internal_new_GC(null);
                int n10 = OS.CreateCompatibleDC(n9);
                int n11 = OS.SelectObject(n10, n4);
                int n12 = 0;
                if (n5 <= 8 && (n3 = this.device.hPalette) != 0) {
                    n12 = OS.SelectPalette(n10, n3, false);
                    OS.RealizePalette(n10);
                }
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n10, n4, 0, n7, null, byArray, 0);
                OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                n3 = bITMAPINFOHEADER.biSizeImage;
                byte[] byArray2 = new byte[n3];
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n10, n4, 0, n7, byArray2, byArray, 0);
                PaletteData paletteData = null;
                if (n5 <= 8) {
                    objectArray = new RGB[n8];
                    n2 = 40;
                    n = 0;
                    while (n < n8) {
                        objectArray[n] = new RGB(byArray[n2 + 2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2] & 0xFF);
                        n2 += 4;
                        ++n;
                    }
                    paletteData = new PaletteData((RGB[])objectArray);
                } else if (n5 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n5 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n5 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                objectArray = null;
                if (iCONINFO.hbmColor == 0) {
                    objectArray = new byte[n3];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, n4, n7, n7, (byte[])objectArray, byArray, 0);
                } else {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n6;
                    bITMAPINFOHEADER.biHeight = -n7;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = 1;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + 8];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    n2 = BITMAPINFOHEADER.sizeof;
                    byArray[n2 + 6] = -1;
                    byArray[n2 + 5] = -1;
                    byArray[n2 + 4] = -1;
                    byArray[n2 + 7] = 0;
                    OS.SelectObject(n10, iCONINFO.hbmMask);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, iCONINFO.hbmMask, 0, n7, null, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n3 = bITMAPINFOHEADER.biSizeImage;
                    objectArray = new byte[n3];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, iCONINFO.hbmMask, 0, n7, (byte[])objectArray, byArray, 0);
                    n = 0;
                    while (n < objectArray.length) {
                        int n13 = n++;
                        objectArray[n13] = (RGB)((byte)(~objectArray[n13]));
                    }
                    int n14 = n3 / n7;
                    n = 1;
                    while (n < 128) {
                        int n15 = ((n6 + 7) / 8 + (n - 1)) / n * n;
                        if (n15 == n14) break;
                        ++n;
                    }
                    objectArray = ImageData.convertPad((byte[])objectArray, n6, n7, 1, n, 2);
                }
                OS.SelectObject(n10, n11);
                if (n12 != 0) {
                    OS.SelectPalette(n10, n12, false);
                    OS.RealizePalette(n10);
                }
                OS.DeleteDC(n10);
                this.device.internal_dispose_GC(n9, null);
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                ImageData imageData = new ImageData(n6, n7, n5, paletteData, 4, byArray2);
                imageData.maskData = (byte[])objectArray;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                Object object;
                int n;
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                int n16 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n17 = bITMAP.bmWidth;
                int n18 = bITMAP.bmHeight;
                boolean bl = bITMAP.bmBits != 0;
                int n19 = this.device.internal_new_GC(null);
                int n20 = this.handle;
                if (OS.IsWinCE && !bl) {
                    boolean bl2 = false;
                    if (this.memGC != null && !this.memGC.isDisposed()) {
                        this.memGC.flush();
                        bl2 = true;
                        GCData gCData = this.memGC.data;
                        if (gCData.hNullBitmap != 0) {
                            OS.SelectObject(this.memGC.handle, gCData.hNullBitmap);
                            gCData.hNullBitmap = 0;
                        }
                    }
                    n20 = this.createDIBFromDDB(n19, this.handle, n17, n18);
                    if (bl2) {
                        int n21;
                        this.memGC.data.hNullBitmap = n21 = OS.SelectObject(this.memGC.handle, this.handle);
                    }
                    bl = true;
                }
                DIBSECTION dIBSECTION = null;
                if (bl) {
                    dIBSECTION = new DIBSECTION();
                    OS.GetObject(n20, DIBSECTION.sizeof, dIBSECTION);
                }
                int n22 = 0;
                if (n16 <= 8) {
                    n22 = bl ? dIBSECTION.biClrUsed : 1 << n16;
                }
                byte[] byArray = null;
                BITMAPINFOHEADER bITMAPINFOHEADER = null;
                if (!bl) {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n17;
                    bITMAPINFOHEADER.biHeight = -n18;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)n16;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + n22 * 4];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                }
                int n23 = OS.CreateCompatibleDC(n19);
                int n24 = OS.SelectObject(n23, n20);
                int n25 = 0;
                if (!bl && n16 <= 8 && (n = this.device.hPalette) != 0) {
                    n25 = OS.SelectPalette(n23, n, false);
                    OS.RealizePalette(n23);
                }
                if (bl) {
                    n = dIBSECTION.biSizeImage;
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n23, n20, 0, n18, null, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n = bITMAPINFOHEADER.biSizeImage;
                }
                byte[] byArray3 = new byte[n];
                if (bl) {
                    if (OS.IsWinCE && this.handle != n20) {
                        OS.MoveMemory(byArray3, dIBSECTION.bmBits, n);
                    } else {
                        OS.MoveMemory(byArray3, bITMAP.bmBits, n);
                    }
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n23, n20, 0, n18, byArray3, byArray, 0);
                }
                PaletteData paletteData = null;
                if (n16 <= 8) {
                    object = new RGB[n22];
                    if (bl) {
                        if (OS.IsWinCE) {
                            int n26 = 0;
                            int n27 = 0;
                            int n28 = 0;
                            byte[] byArray4 = new byte[1];
                            OS.MoveMemory(byArray4, bITMAP.bmBits, 1);
                            byte by = byArray4[0];
                            int n29 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                            int n30 = 0;
                            while (n30 < n22) {
                                byArray4[0] = (byte)(n30 << 8 - bITMAP.bmBitsPixel | byArray4[0] & ~n29);
                                OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                                int n31 = OS.GetPixel(n23, 0, 0);
                                n28 = (n31 & 0xFF0000) >> 16;
                                n27 = (n31 & 0xFF00) >> 8;
                                n26 = n31 & 0xFF;
                                object[n30] = new RGB(n26, n27, n28);
                                ++n30;
                            }
                            byArray4[0] = by;
                            OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                        } else {
                            byte[] byArray5 = new byte[n22 * 4];
                            OS.GetDIBColorTable(n23, 0, n22, byArray5);
                            int n32 = 0;
                            int n33 = 0;
                            while (n33 < ((RGB[])object).length) {
                                object[n33] = new RGB(byArray5[n32 + 2] & 0xFF, byArray5[n32 + 1] & 0xFF, byArray5[n32] & 0xFF);
                                n32 += 4;
                                ++n33;
                            }
                        }
                    } else {
                        int n34 = BITMAPINFOHEADER.sizeof;
                        int n35 = 0;
                        while (n35 < n22) {
                            object[n35] = new RGB(byArray[n34 + 2] & 0xFF, byArray[n34 + 1] & 0xFF, byArray[n34] & 0xFF);
                            n34 += 4;
                            ++n35;
                        }
                    }
                    paletteData = new PaletteData((RGB[])object);
                } else if (n16 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n16 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n16 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject(n23, n24);
                if (n25 != 0) {
                    OS.SelectPalette(n23, n25, false);
                    OS.RealizePalette(n23);
                }
                if (OS.IsWinCE && n20 != this.handle) {
                    OS.DeleteObject(n20);
                }
                OS.DeleteDC(n23);
                this.device.internal_dispose_GC(n19, null);
                object = new ImageData(n17, n18, n16, paletteData, 4, byArray3);
                object.transparentPixel = this.transparentPixel;
                object.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    object.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, object.alphaData, 0, this.alphaData.length);
                }
                return object;
            }
        }
        SWT.error(40);
        return null;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int n, int n2) {
        int n3;
        int n4;
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        int n5 = this.device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap(n5, n, n2);
        if (this.handle == 0) {
            n4 = OS.GetDeviceCaps(n5, 12);
            int n6 = n4 * (n3 = OS.GetDeviceCaps(n5, 14));
            if (n6 < 16) {
                n6 = 16;
            }
            this.handle = Image.createDIB(n, n2, n6);
        }
        if (this.handle != 0) {
            n4 = OS.CreateCompatibleDC(n5);
            n3 = OS.SelectObject(n4, this.handle);
            OS.PatBlt(n4, 0, 0, n, n2, 15728673);
            OS.SelectObject(n4, n3);
            OS.DeleteDC(n4);
        }
        this.device.internal_dispose_GC(n5, null);
        if (this.handle == 0) {
            SWT.error(2, null, this.device.getLastError());
        }
    }

    static int createDIB(int n, int n2, int n3) {
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n;
        bITMAPINFOHEADER.biHeight = -n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)n3;
        bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        if (OS.IsWinCE) {
            int n4 = 65280;
            int n5 = 0xFF0000;
            int n6 = -16777216;
            int n7 = BITMAPINFOHEADER.sizeof;
            byArray[n7] = (byte)((n4 & 0xFF000000) >> 24);
            byArray[n7 + 1] = (byte)((n4 & 0xFF0000) >> 16);
            byArray[n7 + 2] = (byte)((n4 & 0xFF00) >> 8);
            byArray[n7 + 3] = (byte)((n4 & 0xFF) >> 0);
            byArray[n7 + 4] = (byte)((n5 & 0xFF000000) >> 24);
            byArray[n7 + 5] = (byte)((n5 & 0xFF0000) >> 16);
            byArray[n7 + 6] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n7 + 7] = (byte)((n5 & 0xFF) >> 0);
            byArray[n7 + 8] = (byte)((n6 & 0xFF000000) >> 24);
            byArray[n7 + 9] = (byte)((n6 & 0xFF0000) >> 16);
            byArray[n7 + 10] = (byte)((n6 & 0xFF00) >> 8);
            byArray[n7 + 11] = (byte)((n6 & 0xFF) >> 0);
        }
        int[] nArray = new int[1];
        return OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
    }

    static void GetIconInfo(Image image, ICONINFO iCONINFO) {
        int[] nArray = Image.init(image.device, null, image.data);
        iCONINFO.hbmColor = nArray[0];
        iCONINFO.hbmMask = nArray[1];
    }

    static int[] init(Device device, Image image, ImageData object) {
        int[] nArray;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4;
        Object object3;
        if (OS.IsWin95 && ((ImageData)object).depth == 1 && ((ImageData)object).getTransparencyType() != 2 || ((ImageData)object).depth == 2) {
            object3 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 4, ((ImageData)object).palette);
            ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, null, null, null, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, null, null, null, false, false);
            ((ImageData)object3).transparentPixel = ((ImageData)object).transparentPixel;
            ((ImageData)object3).maskPad = ((ImageData)object).maskPad;
            ((ImageData)object3).maskData = ((ImageData)object).maskData;
            ((ImageData)object3).alpha = ((ImageData)object).alpha;
            ((ImageData)object3).alphaData = ((ImageData)object).alphaData;
            object = object3;
        }
        if (((ImageData)object).palette.isDirect) {
            object3 = ((ImageData)object).palette;
            n4 = ((PaletteData)object3).redMask;
            int n5 = ((PaletteData)object3).greenMask;
            int n6 = ((PaletteData)object3).blueMask;
            n3 = ((ImageData)object).depth;
            n2 = 1;
            PaletteData paletteData = null;
            switch (((ImageData)object).depth) {
                case 8: {
                    n3 = 16;
                    n2 = 0;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    n2 = 0;
                    if (n4 == 31744 && n5 == 992 && n6 == 31) break;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (n4 == 255 && n5 == 65280 && n6 == 0xFF0000) break;
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (n4 == 65280 && n5 == 0xFF0000 && n6 == -16777216) break;
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (paletteData != null) {
                object2 = new ImageData(((ImageData)object).width, ((ImageData)object).height, n3, paletteData);
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, n4, n5, n6, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, n2, 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
                if (((ImageData)object).transparentPixel != -1) {
                    ((ImageData)object2).transparentPixel = paletteData.getPixel(((PaletteData)object3).getRGB(((ImageData)object).transparentPixel));
                }
                ((ImageData)object2).maskPad = ((ImageData)object).maskPad;
                ((ImageData)object2).maskData = ((ImageData)object).maskData;
                ((ImageData)object2).alpha = ((ImageData)object).alpha;
                ((ImageData)object2).alphaData = ((ImageData)object).alphaData;
                object = object2;
            }
        }
        object3 = ((ImageData)object).palette.getRGBs();
        n4 = OS.IsWinCE && (((ImageData)object).depth == 16 || ((ImageData)object).depth == 32) ? 1 : 0;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = ((ImageData)object).width;
        bITMAPINFOHEADER.biHeight = -((ImageData)object).height;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)((ImageData)object).depth;
        bITMAPINFOHEADER.biCompression = n4 != 0 ? 3 : 0;
        int n7 = bITMAPINFOHEADER.biClrUsed = object3 == null ? 0 : ((RGB[])object3).length;
        byte[] byArray = ((ImageData)object).palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof + (n4 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + ((RGB[])object3).length * 4];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        n3 = BITMAPINFOHEADER.sizeof;
        if (((ImageData)object).palette.isDirect) {
            if (n4 != 0) {
                PaletteData paletteData = ((ImageData)object).palette;
                int n8 = paletteData.redMask;
                int n9 = paletteData.greenMask;
                int n10 = paletteData.blueMask;
                if (((ImageData)object).getByteOrder() == 0) {
                    byArray[n3] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n3 + 1] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n3 + 2] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n3 + 3] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n3 + 4] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n3 + 5] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n3 + 6] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n3 + 7] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n3 + 8] = (byte)((n10 & 0xFF) >> 0);
                    byArray[n3 + 9] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n3 + 10] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n3 + 11] = (byte)((n10 & 0xFF000000) >> 24);
                } else {
                    byArray[n3] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n3 + 1] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n3 + 2] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n3 + 3] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n3 + 4] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n3 + 5] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n3 + 6] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n3 + 7] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n3 + 8] = (byte)((n10 & 0xFF000000) >> 24);
                    byArray[n3 + 9] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n3 + 10] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n3 + 11] = (byte)((n10 & 0xFF) >> 0);
                }
            }
        } else {
            n2 = 0;
            while (n2 < ((RGB[])object3).length) {
                byArray[n3] = (byte)object3[n2].blue;
                byArray[n3 + 1] = (byte)((RGB)object3[n2]).green;
                byArray[n3 + 2] = (byte)((RGB)object3[n2]).red;
                byArray[n3 + 3] = 0;
                n3 += 4;
                ++n2;
            }
        }
        if ((n = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        object2 = ((ImageData)object).data;
        if (((ImageData)object).scanlinePad != 4 && ((ImageData)object).bytesPerLine % 4 != 0) {
            object2 = ImageData.convertPad((byte[])object2, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 4);
        }
        OS.MoveMemory(nArray[0], (byte[])object2, ((Object)object2).length);
        int[] nArray2 = null;
        if (((ImageData)object).getTransparencyType() == 2) {
            int n11 = device.internal_new_GC(null);
            int n12 = OS.CreateCompatibleDC(n11);
            OS.SelectObject(n12, n);
            int n13 = OS.CreateCompatibleBitmap(n11, ((ImageData)object).width, ((ImageData)object).height);
            if (n13 == 0) {
                SWT.error(2);
            }
            int n14 = OS.CreateCompatibleDC(n11);
            OS.SelectObject(n14, n13);
            OS.BitBlt(n14, 0, 0, ((ImageData)object).width, ((ImageData)object).height, n12, 0, 0, 0xCC0020);
            device.internal_dispose_GC(n11, null);
            byte[] byArray2 = ImageData.convertPad(((ImageData)object).maskData, ((ImageData)object).width, ((ImageData)object).height, 1, ((ImageData)object).maskPad, 2);
            int n15 = OS.CreateBitmap(((ImageData)object).width, ((ImageData)object).height, 1, 1, byArray2);
            if (n15 == 0) {
                SWT.error(2);
            }
            OS.SelectObject(n12, n15);
            OS.PatBlt(n12, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0x550009);
            OS.DeleteDC(n12);
            OS.DeleteDC(n14);
            OS.DeleteObject(n);
            if (image == null) {
                nArray2 = new int[]{n13, n15};
            } else {
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                iCONINFO.hbmColor = n13;
                iCONINFO.hbmMask = n15;
                int n16 = OS.CreateIconIndirect(iCONINFO);
                if (n16 == 0) {
                    SWT.error(2);
                }
                OS.DeleteObject(n13);
                OS.DeleteObject(n15);
                image.handle = n16;
                image.type = 1;
                if (OS.IsWinCE) {
                    image.data = object;
                }
            }
        } else if (image == null) {
            nArray2 = new int[]{n};
        } else {
            image.handle = n;
            image.type = 0;
            image.transparentPixel = ((ImageData)object).transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = ((ImageData)object).alpha;
                if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData != null) {
                    int n17 = ((ImageData)object).alphaData.length;
                    image.alphaData = new byte[n17];
                    System.arraycopy(((ImageData)object).alphaData, 0, image.alphaData, 0, n17);
                }
            }
        }
        return nArray2;
    }

    /*
     * Unable to fully structure code
     */
    static int[] init(Device var0, Image var1_1, ImageData var2_2, ImageData var3_3) {
        block13: {
            block12: {
                var5_4 = 0;
                if (!var2_2.palette.isDirect) break block12;
                var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, var2_2.palette);
                break block13;
            }
            var6_6 = new RGB(0, 0, 0);
            var7_7 = var2_2.getRGBs();
            if (var2_2.transparentPixel == -1) ** GOTO lbl27
            var8_8 = new RGB[var7_7.length];
            System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
            if (var2_2.transparentPixel >= var8_8.length) {
                var7_7 = new RGB[var2_2.transparentPixel + 1];
                System.arraycopy(var8_8, 0, var7_7, 0, var8_8.length);
                var9_10 = var8_8.length;
                while (var9_10 <= var2_2.transparentPixel) {
                    var7_7[var9_10] = new RGB(0, 0, 0);
                    ++var9_10;
                }
            } else {
                var8_8[var2_2.transparentPixel] = var6_6;
                var7_7 = var8_8;
            }
            var5_4 = var2_2.transparentPixel;
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
            break block13;
            while (!var7_7[var5_4].equals(var6_6)) {
                ++var5_4;
lbl27:
                // 2 sources

                if (var5_4 < var7_7.length) continue;
            }
            if (var5_4 == var7_7.length) {
                if (1 << var2_2.depth > var7_7.length) {
                    var8_8 = new RGB[var7_7.length + 1];
                    System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
                    var8_8[var7_7.length] = var6_6;
                    var7_7 = var8_8;
                } else {
                    var5_4 = -1;
                }
            }
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
        }
        if (var5_4 == -1) {
            System.arraycopy(var2_2.data, 0, var4_5.data, 0, var4_5.data.length);
        } else {
            var6_6 = new int[var4_5.width];
            var7_7 = (RGB[])new int[var3_3.width];
            var8_9 = 0;
            while (var8_9 < var4_5.height) {
                var2_2.getPixels(0, var8_9, var4_5.width, (int[])var6_6, 0);
                var3_3.getPixels(0, var8_9, var3_3.width, (int[])var7_7, 0);
                var9_10 = 0;
                while (var9_10 < ((Object)var6_6).length) {
                    if (var7_7[var9_10] == false) {
                        var6_6[var9_10] = var5_4;
                    }
                    ++var9_10;
                }
                var4_5.setPixels(0, var8_9, var2_2.width, (int[])var6_6, 0);
                ++var8_9;
            }
        }
        var4_5.maskPad = var3_3.scanlinePad;
        var4_5.maskData = var3_3.data;
        return Image.init(var0, var1_1, var4_5);
    }

    void init(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        Image.init(this.device, this, imageData);
    }

    public int internal_new_GC(GCData gCData) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int n = this.device.internal_new_GC(null);
        int n2 = OS.CreateCompatibleDC(n);
        this.device.internal_dispose_GC(n, null);
        if (n2 == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.image = this;
            gCData.font = this.device.systemFont;
        }
        return n2;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.DeleteDC(n);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        this.transparentColor = -1;
        int n = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        int n2 = OS.CreateCompatibleDC(n);
        OS.SelectObject(n2, this.handle);
        int n3 = 1 << bITMAP.bmBitsPixel;
        byte[] byArray = new byte[n3 * 4];
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n4 = OS.GetDIBColorTable(n2, 0, n3, byArray);
        int n5 = this.transparentPixel * 4;
        byArray[n5] = (byte)color.getBlue();
        byArray[n5 + 1] = (byte)color.getGreen();
        byArray[n5 + 2] = (byte)color.getRed();
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        OS.SetDIBColorTable(n2, 0, n4, byArray);
        OS.DeleteDC(n2);
        this.device.internal_dispose_GC(n, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int n, int n2) {
        Image image = new Image(device);
        image.type = n;
        image.handle = n2;
        return image;
    }
}

