/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSToolbarItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    NSView view;
    NSButton button;
    NSToolbarItem nsItem;
    NSMenuItem nsMenuRep;
    NSString id;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int INSET = 3;
    static final int ARROW_WIDTH = 5;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, n2);
    }

    int accessibleHandle() {
        if (this.button != null && this.button.cell() != null) {
            return this.button.cell().id;
        }
        if (this.view != null) {
            return this.view.id;
        }
        return 0;
    }

    int accessibilityActionNames(int n, int n2) {
        int n3 = super.accessibilityActionNames(n, n2);
        if (n == this.accessibleHandle()) {
            if ((this.style & 4) != 0) {
                NSArray nSArray = new NSArray(n3);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityShowMenuAction);
                n3 = nSMutableArray.id;
            }
        } else {
            n3 = super.accessibilityActionNames(n, n2);
        }
        return n3;
    }

    int accessibilityAttributeNames(int n, int n2) {
        int n3 = super.accessibilityAttributeNames(n, n2);
        if (n == this.accessibleHandle()) {
            if ((this.style & 0x30) != 0) {
                NSArray nSArray = new NSArray(n3);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
                n3 = nSMutableArray.id;
            } else if ((this.style & 4) != 0) {
                NSArray nSArray = new NSArray(n3);
                NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() + 1);
                nSMutableArray.addObjectsFromArray(nSArray);
                nSMutableArray.addObject(OS.NSAccessibilityChildrenAttribute);
                n3 = nSMutableArray.id;
            }
        } else {
            n3 = super.accessibilityAttributeNames(n, n2);
        }
        return n3;
    }

    int accessibilityAttributeValue(int n, int n2, int n3) {
        NSString nSString = new NSString(n3);
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString nSString2;
            NSString nSString3 = (this.style & 8) != 0 ? OS.NSAccessibilityButtonRole : ((this.style & 0x10) != 0 ? OS.NSAccessibilityRadioButtonRole : ((this.style & 0x20) != 0 ? OS.NSAccessibilityCheckBoxRole : (nSString2 = (this.style & 4) != 0 ? OS.NSAccessibilityMenuButtonRole : null)));
            if (nSString2 != null) {
                if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                    return nSString2.id;
                }
                int n4 = OS.NSAccessibilityRoleDescription(nSString2.id, 0);
                return n4;
            }
        } else {
            if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
                String string;
                String string2 = string = this.text.length() > 0 ? this.text : this.toolTipText;
                if (string != null) {
                    return NSString.stringWith((String)string).id;
                }
                return NSString.string().id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
                String string = this.toolTipText;
                if (string != null) {
                    return NSString.stringWith((String)string).id;
                }
                return NSString.string().id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute) && (this.style & 0x30) != 0) {
                NSNumber nSNumber = NSNumber.numberWithInt(this.selection ? 1 : 0);
                return nSNumber.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
                NSNumber nSNumber = NSNumber.numberWithBool(this.getEnabled());
                return nSNumber.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
                NSArray nSArray = NSArray.array();
                return nSArray.id;
            }
            if (nSString.isEqualToString(OS.NSAccessibilityParentAttribute)) {
                return this.parent.view.id;
            }
        }
        return super.accessibilityAttributeValue(n, n2, n3);
    }

    boolean accessibilityIsIgnored(int n, int n2) {
        if (n == this.accessibleHandle()) {
            return false;
        }
        return super.accessibilityIsIgnored(n, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean handleKeyDown() {
        if ((this.style & 4) != 0) {
            NSRect nSRect = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)nSRect.x;
            event.y = (int)(nSRect.y + nSRect.height);
            this.sendSelectionEvent(13, event, false);
            return true;
        }
        return false;
    }

    Point computeSize() {
        this.checkWidget();
        int n = 0;
        int n2 = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                n = this.getWidth();
                if (n <= 0) {
                    n = 6;
                }
                n2 = 22;
            } else {
                n = 24;
                n2 = this.getWidth();
                if (n2 <= 0) {
                    n2 = 6;
                }
            }
            if (this.control != null) {
                n2 = Math.max(n2, this.control.getMininumHeight());
            }
        } else {
            if (this.text.length() != 0 || this.image != null) {
                NSSize nSSize = this.button.cell().cellSize();
                n = (int)Math.ceil(nSSize.width);
                n2 = (int)Math.ceil(nSSize.height);
            } else {
                n = 24;
                n2 = 22;
            }
            if ((this.style & 4) != 0) {
                n += 8;
            }
            if (this.parent.nsToolbar == null || this.image != null) {
                n += 6;
                n2 += 6;
            } else {
                n2 -= 2;
            }
        }
        return new Point(n, n2);
    }

    void createHandle() {
        if (this.parent.nsToolbar != null) {
            this.id = NSString.stringWith(String.valueOf(ToolBar.NEXT_ID++));
            this.id.retain();
            this.nsItem = ((NSToolbarItem)new NSToolbarItem().alloc()).initWithItemIdentifier(this.id);
            this.nsItem.setAction(OS.sel_sendSelection);
            this.nsMenuRep = ((NSMenuItem)new SWTMenuItem().alloc()).initWithTitle(NSString.string(), OS.sel_sendSelection, NSString.string());
            this.nsItem.setMenuFormRepresentation(this.nsMenuRep);
        }
        if ((this.style & 2) != 0) {
            if (this.parent.nsToolbar != null) {
                this.view = (NSView)new SWTView().alloc();
                this.view.init();
            } else {
                NSBox nSBox = (NSBox)new SWTBox().alloc();
                nSBox.init();
                nSBox.setBoxType(2);
                nSBox.setBorderWidth(0.0f);
                this.view = nSBox;
            }
        } else {
            NSView nSView = (NSView)new SWTView().alloc();
            nSView.init();
            this.button = (NSButton)new SWTButton().alloc();
            this.button.init();
            NSButtonCell nSButtonCell = (NSButtonCell)new SWTButtonCell().alloc().init();
            this.button.setCell(nSButtonCell);
            nSButtonCell.release();
            nSButtonCell.setHighlightsBy(1);
            nSButtonCell.setBackgroundStyle(2);
            this.button.setBordered(false);
            this.button.setAction(OS.sel_sendSelection);
            this.button.setTarget(this.button);
            if (this.nsMenuRep != null) {
                this.nsMenuRep.setTarget(this.button);
            }
            Font font = this.parent.font != null ? this.parent.font : this.parent.defaultFont();
            this.button.setFont(font.handle);
            this.button.setImagePosition(6);
            this.button.setTitle(NSString.string());
            this.button.setEnabled(this.parent.getEnabled());
            nSView.addSubview(this.button);
            this.view = nSView;
        }
    }

    NSAttributedString createString() {
        NSAttributedString nSAttributedString = this.parent.createString(this.text, null, this.parent.foreground, 0x1000000, false, true, true);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        if (this.button != null) {
            this.display.removeWidget(this.button);
            this.display.removeWidget(this.button.cell());
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawImageWithFrameInView(int n, int n2, int n3, NSRect nSRect, int n4) {
        boolean bl;
        if (this.text.length() > 0) {
            if ((this.parent.style & 0x20000) != 0) {
                nSRect.x += 3.0f;
            } else {
                nSRect.y += 3.0f;
            }
        }
        int n5 = NSGraphicsContext.currentContext().graphicsPort();
        NSCell nSCell = new NSCell(n);
        boolean bl2 = bl = this.parent.nsToolbar != null && this.getSelection() && (this.style & 0x20) != 0 && !nSCell.isHighlighted();
        if (bl) {
            NSGraphicsContext.currentContext().saveGraphicsState();
            CGRect cGRect = new CGRect();
            cGRect.origin.x = nSRect.x;
            cGRect.origin.y = nSRect.y;
            cGRect.size.width = nSRect.width;
            cGRect.size.height = nSRect.height;
            OS.CGContextBeginTransparencyLayerWithRect(n5, cGRect, 0);
        }
        super.drawImageWithFrameInView(n, n2, n3, nSRect, n4);
        if (bl) {
            NSColor.colorWithDeviceRed(0.0f, 0.0f, 0.0f, 0.3f).setFill();
            OS.NSRectFillUsingOperation(nSRect, 5);
            OS.CGContextEndTransparencyLayer(n5);
            NSGraphicsContext.currentContext().restoreGraphicsState();
        }
    }

    NSRect drawTitleWithFrameInView(int n, int n2, int n3, NSRect nSRect, int n4) {
        boolean bl;
        boolean bl2 = bl = new NSButtonCell(n).isHighlighted() && this.text.length() > 0 && this.image == null;
        if (bl) {
            NSColor nSColor = NSColor.colorWithDeviceRed(1.0f, 1.0f, 1.0f, 0.8f);
            NSAttributedString nSAttributedString = new NSAttributedString(n3);
            NSMutableAttributedString nSMutableAttributedString = new NSMutableAttributedString(nSAttributedString.mutableCopy());
            NSRange nSRange = new NSRange();
            nSRange.location = 0;
            nSRange.length = nSAttributedString.length();
            nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, nSColor, nSRange);
            nSMutableAttributedString.autorelease();
            n3 = nSMutableAttributedString.id;
        }
        return super.drawTitleWithFrameInView(n, n2, n3, nSRect, n4);
    }

    void drawWidget(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n == this.view.id) {
            NSRect nSRect2;
            boolean bl;
            boolean bl2 = bl = this.getSelection() && this.parent.nsToolbar == null;
            if (bl) {
                nSRect2 = this.view.bounds();
                nSGraphicsContext.saveGraphicsState();
                NSColor.colorWithDeviceRed(0.1f, 0.1f, 0.1f, 0.1f).setFill();
                NSColor.colorWithDeviceRed(0.2f, 0.2f, 0.2f, 0.2f).setStroke();
                NSBezierPath.fillRect(nSRect2);
                nSRect2.x += 0.5f;
                nSRect2.y += 0.5f;
                nSRect2.width -= 1.0f;
                nSRect2.height -= 1.0f;
                NSBezierPath.strokeRect(nSRect2);
                nSGraphicsContext.restoreGraphicsState();
            }
            if ((this.style & 4) != 0) {
                nSRect2 = this.view.bounds();
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                NSPoint nSPoint = new NSPoint();
                nSBezierPath.moveToPoint(nSPoint);
                nSPoint.x += 5.0f;
                nSBezierPath.lineToPoint(nSPoint);
                nSPoint.y += 4.0f;
                nSPoint.x -= 2.5f;
                nSBezierPath.lineToPoint(nSPoint);
                nSBezierPath.closePath();
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.translateXBy((int)nSRect2.width - 5 - 3, (int)(nSRect2.height - 2.0f) / 2);
                nSAffineTransform.concat();
                NSColor nSColor = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
                nSColor.set();
                nSBezierPath.fill();
                nSGraphicsContext.restoreGraphicsState();
            }
        }
    }

    void enableWidget(boolean bl) {
        if (this.parent.nsToolbar != null) {
            this.nsItem.setEnabled(bl);
        }
        if ((this.style & 2) == 0) {
            this.button.setEnabled(bl);
            this.updateImage(true);
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.parent.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            nSRect = this.parent.view.convertRect_fromView_(nSRect, this.view);
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
        }
        NSRect nSRect = this.view.frame();
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    void setClipRegion(NSView nSView) {
        this.parent.setClipRegion(nSView);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    NSString getItemID() {
        NSString nSString = this.id;
        if ((this.style & 2) != 0 && this.control == null) {
            if (this.width == 6 || this.width == 0) {
                if (OS.VERSION < 4208) {
                    nSString = OS.NSToolbarSeparatorItemIdentifier;
                }
            } else if (this.width == -1) {
                nSString = OS.NSToolbarSpaceItemIdentifier;
            } else if (this.width == -2) {
                nSString = OS.NSToolbarFlexibleSpaceItemIdentifier;
            }
        }
        return nSString;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    int menuForEvent(int n, int n2, int n3) {
        return this.parent.menuForEvent(n, n2, n3);
    }

    void mouseDown(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 3)) {
            return;
        }
        Display display = this.display;
        display.trackingControl = this.parent;
        super.mouseDown(n, n2, n3);
        display.trackingControl = null;
        if ((this.style & 4) != 0 && n == this.view.id) {
            NSRect nSRect = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)nSRect.x;
            event.y = (int)(nSRect.y + nSRect.height);
            this.sendSelectionEvent(13, event, false);
        }
    }

    boolean mouseDownCanMoveWindow(int n, int n2) {
        if (n == this.view.id) {
            return false;
        }
        return super.mouseDownCanMoveWindow(n, n2);
    }

    void mouseUp(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 4)) {
            return;
        }
        super.mouseUp(n, n2, n3);
    }

    void mouseDragged(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 5)) {
            return;
        }
        super.mouseDragged(n, n2, n3);
    }

    void rightMouseDown(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 3)) {
            return;
        }
        super.rightMouseDown(n, n2, n3);
    }

    void rightMouseUp(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 4)) {
            return;
        }
        super.rightMouseUp(n, n2, n3);
    }

    void rightMouseDragged(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 5)) {
            return;
        }
        super.rightMouseDragged(n, n2, n3);
    }

    void otherMouseDown(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 3)) {
            return;
        }
        super.otherMouseDown(n, n2, n3);
    }

    void otherMouseUp(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 4)) {
            return;
        }
        super.otherMouseUp(n, n2, n3);
    }

    void otherMouseDragged(int n, int n2, int n3) {
        if (!this.parent.mouseEvent(this.parent.view.id, n2, n3, 5)) {
            return;
        }
        super.otherMouseDragged(n, n2, n3);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        if (this.button != null) {
            this.display.addWidget(this.button, this);
            this.display.addWidget(this.button.cell(), this);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        if (this.button != null) {
            this.button.release();
        }
        this.button = null;
        this.view = null;
        if (this.nsItem != null) {
            this.nsItem.release();
            this.nsItem = null;
        }
        if (this.id != null) {
            this.id.release();
            this.id = null;
        }
        if (this.nsMenuRep != null) {
            this.nsMenuRep.release();
            this.nsMenuRep = null;
        }
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    void selectRadio() {
        int n = 0;
        ToolItem[] toolItemArray = this.parent.getItems();
        while (n < toolItemArray.length && toolItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && toolItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < toolItemArray.length && toolItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.sendSelectionEvent(13);
    }

    void setBounds(int n, int n2, int n3, int n4) {
        NSRect nSRect = new NSRect();
        if (this.parent.nsToolbar == null) {
            nSRect.x = n;
            nSRect.y = n2;
            nSRect.width = n3;
            nSRect.height = n4;
            this.view.setFrame(nSRect);
            if (this.button != null) {
                nSRect.x = 0.0f;
                nSRect.y = 0.0f;
                nSRect.width = n3;
                nSRect.height = n4;
                if ((this.style & 4) != 0) {
                    nSRect.width -= 8.0f;
                }
                this.button.setFrame(nSRect);
            }
        } else {
            NSSize nSSize = new NSSize();
            nSSize.height = n4;
            nSSize.width = n3;
            this.nsItem.setView(null);
            this.view.setFrameSize(nSSize);
            if ((this.style & 4) != 0) {
                nSSize.width -= 8.0f;
            }
            if (this.button != null) {
                this.button.setFrameSize(nSSize);
            }
            if ((this.style & 4) != 0) {
                nSSize.width += 8.0f;
            }
            this.nsItem.setMinSize(nSSize);
            this.nsItem.setMaxSize(nSSize);
            this.nsItem.setView(this.view);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        if (this.parent.nsToolbar == null) {
            NSBox nSBox = (NSBox)this.view;
            if (control == null) {
                nSBox.setBoxType(2);
            } else {
                nSBox.setBoxType(4);
            }
        } else {
            this.nsItem.setMenuFormRepresentation(control == null ? this.nsMenuRep : NSMenuItem.separatorItem());
        }
        this.control = control;
        this.view.setHidden(control != null);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 && bl) {
            return;
        }
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(bl);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    boolean setFocus() {
        if (this.button == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        NSWindow nSWindow = this.view.window();
        if (nSWindow == null) {
            return false;
        }
        return nSWindow.makeFirstResponder(this.button);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = bl;
        if (this.parent.nsToolbar != null && (this.style & 0x10) != 0 && this.selection) {
            this.parent.nsToolbar.setSelectedItemIdentifier(this.nsItem.itemIdentifier());
        }
        this.view.setNeedsDisplay(true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        NSButton nSButton = this.button;
        if (this.parent.nsToolbar != null) {
            char[] cArray = new char[this.text.length()];
            this.text.getChars(0, cArray.length, cArray, 0);
            int n = this.fixMnemonic(cArray);
            this.nsMenuRep.setTitle(NSString.stringWithCharacters(cArray, n));
        }
        nSButton.setAttributedTitle(this.createString());
        if (this.text.length() != 0 && this.image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                nSButton.setImagePosition(2);
            } else {
                nSButton.setImagePosition(5);
            }
        } else {
            nSButton.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.toolTipText == null) {
            return;
        }
        if (string != null && string.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = string;
        if (this.parent.nsToolbar != null) {
            char[] cArray = new char[this.toolTipText.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n = this.fixMnemonic(cArray);
            this.nsItem.setToolTip(NSString.stringWithCharacters(cArray, n));
        } else {
            this.parent.checkToolTip(this);
        }
    }

    void setVisible(boolean bl) {
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.view.setHidden(!bl);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < -2 || this.width == n) {
            return;
        }
        this.width = n;
        if (this.parent.nsToolbar != null) {
            NSToolbar nSToolbar = this.parent.nsToolbar;
            int n2 = this.parent.indexOf(this);
            nSToolbar.removeItemAtIndex(n2);
            nSToolbar.insertItemWithItemIdentifier(this.getItemID(), n2);
        }
        this.parent.relayout();
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void updateImage(boolean bl) {
        if ((this.style & 2) != 0) {
            return;
        }
        Image image = null;
        image = (this.state & 8) == 8 && this.disabledImage != null ? this.disabledImage : ((this.state & 0x20) == 32 && this.hotImage != null ? this.hotImage : this.image);
        NSButton nSButton = this.button;
        nSButton.setImage(image != null ? image.handle : null);
        nSButton.setNeedsDisplay(true);
        if (this.text.length() != 0 && image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                nSButton.setImagePosition(2);
            } else {
                nSButton.setImagePosition(5);
            }
        } else {
            nSButton.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }

    boolean validateMenuItem(int n, int n2, int n3) {
        return this.isEnabled();
    }
}

