/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.engine;

import bl.radio.ConfigBox;
import bl.radio.channel.ChannelModel;
import bl.radio.config.MessageFactory;
import bl.radio.engine.PlayerEvent;
import bl.radio.engine.PlayerListener;
import bl.radio.engine.meta.MetaEvent;
import bl.radio.task.FeadInTask;
import bl.radio.util.UrlHelper;
import bl.radio.util.WebClientUtil;
import bl.radio.vu.VUMeterTask;
import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;

public class PlayerStreamer
implements MediaPlayerEventListener,
Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = (Logger)LoggerFactory.getLogger(PlayerStreamer.class);
    private PlayerListener listener;
    private boolean isDjMode;
    private boolean isPlay;
    private boolean isSoundless;
    private MediaPlayer audioPlayer;
    private ChannelModel channelModel;
    private VUMeterTask meter;

    public PlayerStreamer(ChannelModel channelModel, PlayerListener playerListener) throws Exception {
        this(channelModel, playerListener, false);
    }

    public PlayerStreamer(ChannelModel channelModel, PlayerListener playerListener, boolean bl) throws Exception {
        this.channelModel = channelModel;
        this.listener = playerListener;
        this.isDjMode = bl;
        this.isSoundless = false;
        ConfigBox configBox = ConfigBox.getInstance();
        MediaPlayerFactory mediaPlayerFactory = configBox.getMediaPlayerFactory();
        this.audioPlayer = mediaPlayerFactory.newHeadlessMediaPlayer();
        this.audioPlayer.addMediaPlayerEventListener((MediaPlayerEventListener)this);
    }

    public boolean isSoundless() {
        return this.isSoundless;
    }

    @Override
    public void run() {
        try {
            List<String> list = this.channelModel.getUrls();
            String string = list.get(0);
            this.doPlay(string);
        }
        catch (Exception exception) {
            logger.error(MessageFactory.getMessage("Error.PlayThread"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPlay(String string) throws Exception {
        this.isPlay = false;
        logger.debug("Play start...");
        try {
            UrlHelper urlHelper = new UrlHelper(string);
            if (!WebClientUtil.chkStream(urlHelper)) {
                this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, -1));
                return;
            }
            int n = this.audioPlayer.getVolume();
            this.audioPlayer.setVolume(0);
            if (!this.audioPlayer.startMedia(string, new String[0])) {
                this.isPlay = false;
                logger.error(MessageFactory.getMessage("Error.PlayThread"));
                this.audioPlayer.release();
                this.audioPlayer = null;
                return;
            }
            this.isPlay = true;
            Timer timer = null;
            FeadInTask feadInTask = null;
            timer = new Timer("start.timer");
            if (this.isDjMode) {
                feadInTask = new FeadInTask(this.audioPlayer, timer, 10, n);
                timer.schedule((TimerTask)feadInTask, 200L);
            } else {
                feadInTask = new FeadInTask(this.audioPlayer, timer, 20, n);
                timer.schedule((TimerTask)feadInTask, 50L);
            }
            while (this.isPlay) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!feadInTask.isFinish()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.audioPlayer.stop();
            this.audioPlayer.release();
            if (this.meter != null) {
                this.meter.stop();
            }
            System.gc();
        }
    }

    public void stop() {
        if (this.isPlay) {
            this.isPlay = false;
        } else {
            this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, 2));
        }
    }

    public void setVolume(int n) {
        this.audioPlayer.setVolume(n);
    }

    public int getVolume() {
        return this.audioPlayer.getVolume();
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void backward(MediaPlayer mediaPlayer) {
    }

    public void buffering(MediaPlayer mediaPlayer, float f) {
    }

    public void endOfSubItems(MediaPlayer mediaPlayer) {
    }

    public void error(MediaPlayer mediaPlayer) {
        this.stop();
        logger.error("Failed to play media");
        this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, -1));
    }

    public void finished(MediaPlayer mediaPlayer) {
        if (this.isSoundless) {
            this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, 8));
        } else {
            this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, 3));
        }
    }

    public void forward(MediaPlayer mediaPlayer) {
    }

    public void lengthChanged(MediaPlayer mediaPlayer, long l) {
    }

    public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2, String string) {
    }

    public void mediaDurationChanged(MediaPlayer mediaPlayer, long l) {
    }

    public void mediaFreed(MediaPlayer mediaPlayer) {
    }

    public void mediaMetaChanged(MediaPlayer mediaPlayer, int n) {
        MediaMeta mediaMeta;
        if (n == 15 && (mediaMeta = mediaPlayer.getMediaMeta()).getNowPlaying() != null) {
            List<String> list = this.channelModel.getUrls();
            String string = list.get(0);
            this.listener.notifyMetadata(new MetaEvent(mediaMeta.getNowPlaying(), string, this.channelModel));
        }
    }

    public void mediaParsedChanged(MediaPlayer mediaPlayer, int n) {
    }

    public void mediaStateChanged(MediaPlayer mediaPlayer, int n) {
    }

    public void mediaSubItemAdded(MediaPlayer mediaPlayer, libvlc_media_t libvlc_media_t2) {
    }

    public void newMedia(MediaPlayer mediaPlayer) {
    }

    public void opening(MediaPlayer mediaPlayer) {
        this.listener.notifyPlayer(new PlayerEvent(this.channelModel, true, this.isDjMode, 0));
    }

    public void pausableChanged(MediaPlayer mediaPlayer, int n) {
    }

    public void paused(MediaPlayer mediaPlayer) {
    }

    public void playing(MediaPlayer mediaPlayer) {
        this.listener.notifyPlayer(new PlayerEvent(this.channelModel, true, this.isDjMode, 1));
    }

    public void positionChanged(MediaPlayer mediaPlayer, float f) {
    }

    public void seekableChanged(MediaPlayer mediaPlayer, int n) {
    }

    public void snapshotTaken(MediaPlayer mediaPlayer, String string) {
    }

    public void stopped(MediaPlayer mediaPlayer) {
        mediaPlayer.release();
        if (this.isSoundless) {
            this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, 8));
        } else {
            this.listener.notifyPlayer(new PlayerEvent(this.channelModel, false, this.isDjMode, 2));
        }
    }

    public void subItemFinished(MediaPlayer mediaPlayer, int n) {
    }

    public void subItemPlayed(MediaPlayer mediaPlayer, int n) {
    }

    public void timeChanged(MediaPlayer mediaPlayer, long l) {
    }

    public void titleChanged(MediaPlayer mediaPlayer, int n) {
    }

    public void videoOutput(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.setVolume(mediaPlayer.getVolume());
    }
}

