/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void drawBand(int n, int n2, int n3, int n4) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int n5 = this.parent.handle;
        byte[] byArray = new byte[16];
        byArray[0] = -86;
        byArray[2] = 85;
        byArray[4] = -86;
        byArray[6] = 85;
        byArray[8] = -86;
        byArray[10] = 85;
        byArray[12] = -86;
        byArray[14] = 85;
        byte[] byArray2 = byArray;
        int n6 = OS.CreateBitmap(8, 8, 1, 1, byArray2);
        int n7 = OS.CreatePatternBrush(n6);
        int n8 = OS.GetDCEx(n5, 0, 2);
        int n9 = OS.SelectObject(n8, n7);
        OS.PatBlt(n8, n, n2, n3, n4, 5898313);
        OS.SelectObject(n8, n9);
        OS.ReleaseDC(n5, n8);
        OS.DeleteObject(n7);
        OS.DeleteObject(n6);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        super.WM_ERASEBKGND(n, n2);
        this.drawBackground(n);
        return LRESULT.ONE;
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                int n3;
                if (OS.GetKeyState(1) < 0) {
                    return lRESULT;
                }
                int n4 = n3 = OS.GetKeyState(17) < 0 ? 1 : 9;
                if ((this.style & 0x200) != 0) {
                    if (n == 38 || n == 40) break;
                    if (n == 37) {
                        n3 = -n3;
                    }
                    if ((this.parent.style & 0x8000000) != 0) {
                        n3 = -n3;
                    }
                } else {
                    if (n == 37 || n == 39) break;
                    if (n == 38) {
                        n3 = -n3;
                    }
                }
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n5 = rECT.right - rECT.left;
                int n6 = rECT.bottom - rECT.top;
                int n7 = this.parent.handle;
                RECT rECT2 = new RECT();
                OS.GetClientRect(n7, rECT2);
                int n8 = rECT2.right - rECT2.left;
                int n9 = rECT2.bottom - rECT2.top;
                OS.MapWindowPoints(0, n7, rECT, 2);
                POINT pOINT = new POINT();
                int n10 = rECT.left;
                int n11 = rECT.top;
                if ((this.style & 0x200) != 0) {
                    pOINT.x = n10 = Math.min(Math.max(rECT2.left, n10 + n3), n8 - n5);
                    pOINT.y = rECT.top + n6 / 2;
                } else {
                    pOINT.x = rECT.left + n5 / 2;
                    pOINT.y = n11 = Math.min(Math.max(rECT2.top, n11 + n3), n9 - n6);
                }
                if (n10 == rECT.left && n11 == rECT.top) {
                    return lRESULT;
                }
                OS.ClientToScreen(n7, pOINT);
                OS.SetCursorPos(pOINT.x, pOINT.y);
                Event event = new Event();
                event.x = n10;
                event.y = n11;
                event.width = n5;
                event.height = n6;
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                if (event.doit && (this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n5, n6);
                }
                return lRESULT;
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        return new LRESULT(256);
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        int n3 = this.parent.handle;
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, n2);
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        OS.MapWindowPoints(this.handle, 0, pOINT, 1);
        this.startX = pOINT.x - rECT.left;
        this.startY = pOINT.y - rECT.top;
        OS.MapWindowPoints(0, n3, rECT, 2);
        this.lastX = rECT.left;
        this.lastY = rECT.top;
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n4;
        event.height = n5;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.menuShell().bringToTop();
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            if (OS.IsWinCE) {
                OS.UpdateWindow(n3);
            } else {
                int n6 = 384;
                OS.RedrawWindow(n3, null, 0, n6);
            }
            this.drawBand(event.x, event.y, n4, n5);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n4, n5);
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!this.dragging) {
            return lRESULT;
        }
        this.dragging = false;
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n3;
        event.height = n4;
        this.drawBand(event.x, event.y, n3, n4);
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n3, n4);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_MOUSEMOVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.dragging || (n & 1) == 0) {
            return lRESULT;
        }
        POINT pOINT = new POINT();
        OS.POINTSTOPOINT(pOINT, n2);
        int n4 = this.parent.handle;
        OS.MapWindowPoints(this.handle, n4, pOINT, 1);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        OS.GetClientRect(n4, rECT2);
        int n7 = this.lastX;
        int n8 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n3 = rECT2.right - rECT2.left;
            n7 = Math.min(Math.max(0, pOINT.x - this.startX), n3 - n5);
        } else {
            n3 = rECT2.bottom - rECT2.top;
            n8 = Math.min(Math.max(0, pOINT.y - this.startY), n3 - n6);
        }
        if (n7 == this.lastX && n8 == this.lastY) {
            return lRESULT;
        }
        this.drawBand(this.lastX, this.lastY, n5, n6);
        Event event = new Event();
        event.x = n7;
        event.y = n8;
        event.width = n5;
        event.height = n6;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
        if (OS.IsWinCE) {
            OS.UpdateWindow(n4);
        } else {
            int n9 = 384;
            OS.RedrawWindow(n4, null, 0, n9);
        }
        this.drawBand(this.lastX, this.lastY, n5, n6);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(this.lastX, this.lastY, n5, n6);
        }
        return lRESULT;
    }

    LRESULT WM_SETCURSOR(int n, int n2) {
        LRESULT lRESULT = super.WM_SETCURSOR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s = (short)OS.LOWORD(n2);
        if (s == 1) {
            int n3 = 0;
            n3 = (this.style & 0x100) != 0 ? OS.LoadCursor(0, 32645) : OS.LoadCursor(0, 32644);
            OS.SetCursor(n3);
            return LRESULT.ONE;
        }
        return lRESULT;
    }
}

