/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui.notify.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorCache {
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static Map<RGB, Color> _colorTable = new HashMap<RGB, Color>();
    private static ColorCache _instance;

    private ColorCache() {
        _instance = this;
    }

    public static ColorCache getInstance() {
        return _instance;
    }

    public static void disposeColors() {
        Iterator<Color> iterator = _colorTable.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        _colorTable.clear();
    }

    public static Color getWhite() {
        return ColorCache.getColorFromRGB(new RGB(255, 255, 255));
    }

    public static Color getBlack() {
        return ColorCache.getColorFromRGB(new RGB(0, 0, 0));
    }

    public static Color getColorFromRGB(RGB rGB) {
        Color color = _colorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            _colorTable.put(rGB, color);
        }
        return color;
    }

    public static Color getColor(int n, int n2, int n3) {
        RGB rGB = new RGB(n, n2, n3);
        Color color = _colorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            _colorTable.put(rGB, color);
        }
        return color;
    }

    static {
        new ColorCache();
    }
}

