/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long handle;
    int transparentPixel = -1;
    int transparentColor = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    ImageData data;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        device = this.device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBounds();
        this.type = image.type;
        block0 : switch (n) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        long l = device.internal_new_GC(null);
                        long l2 = OS.CreateCompatibleDC(l);
                        long l3 = OS.CreateCompatibleDC(l);
                        long l4 = OS.SelectObject(l2, image.handle);
                        BITMAP bITMAP = new BITMAP();
                        OS.GetObject(image.handle, BITMAP.sizeof, bITMAP);
                        this.handle = OS.CreateCompatibleBitmap(l2, rectangle.width, bITMAP.bmBits != 0L ? -rectangle.height : rectangle.height);
                        if (this.handle == 0L) {
                            SWT.error(2);
                        }
                        long l5 = OS.SelectObject(l3, this.handle);
                        OS.BitBlt(l3, 0, 0, rectangle.width, rectangle.height, l2, 0, 0, 0xCC0020);
                        OS.SelectObject(l2, l4);
                        OS.SelectObject(l3, l5);
                        OS.DeleteDC(l2);
                        OS.DeleteDC(l3);
                        device.internal_dispose_GC(l, null);
                        this.transparentPixel = image.transparentPixel;
                        this.alpha = image.alpha;
                        if (image.alphaData == null) break block0;
                        this.alphaData = new byte[image.alphaData.length];
                        System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        if (OS.IsWinCE) {
                            this.init(image.data);
                            break;
                        }
                        this.handle = OS.CopyImage(image.handle, 1, rectangle.width, rectangle.height, 0);
                        if (this.handle != 0L) break block0;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                RGB[] rGBArray = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData imageData2 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                imageData2.alpha = imageData.alpha;
                imageData2.alphaData = imageData.alphaData;
                imageData2.maskData = imageData.maskData;
                imageData2.maskPad = imageData.maskPad;
                if (imageData.transparentPixel != -1) {
                    imageData2.transparentPixel = 0;
                }
                int[] nArray = new int[rectangle.width];
                int[] nArray2 = null;
                ImageData imageData3 = null;
                if (imageData.maskData != null) {
                    imageData3 = imageData.getTransparencyMask();
                }
                if (imageData3 != null) {
                    nArray2 = new int[rectangle.width];
                }
                int n2 = paletteData.redMask;
                int n3 = paletteData.greenMask;
                int n4 = paletteData.blueMask;
                int n5 = paletteData.redShift;
                int n6 = paletteData.greenShift;
                int n7 = paletteData.blueShift;
                int n8 = 0;
                while (n8 < rectangle.height) {
                    int n9 = n8 * imageData2.bytesPerLine;
                    imageData.getPixels(0, n8, rectangle.width, nArray, 0);
                    if (imageData3 != null) {
                        imageData3.getPixels(0, n8, rectangle.width, nArray2, 0);
                    }
                    int n10 = 0;
                    while (n10 < rectangle.width) {
                        int n11 = nArray[n10];
                        if (!(imageData.transparentPixel != -1 && n11 == imageData.transparentPixel || imageData3 != null && nArray2[n10] == 0)) {
                            int n12;
                            int n13;
                            int n14;
                            if (paletteData.isDirect) {
                                n14 = n11 & n2;
                                n14 = n5 < 0 ? n14 >>> -n5 : n14 << n5;
                                n13 = n11 & n3;
                                n13 = n6 < 0 ? n13 >>> -n6 : n13 << n6;
                                n12 = n11 & n4;
                                n12 = n7 < 0 ? n12 >>> -n7 : n12 << n7;
                            } else {
                                n14 = paletteData.colors[n11].red;
                                n13 = paletteData.colors[n11].green;
                                n12 = paletteData.colors[n11].blue;
                            }
                            int n15 = n14 * n14 + n13 * n13 + n12 * n12;
                            imageData2.data[n9] = n15 < 98304 ? 1 : 2;
                        }
                        ++n9;
                        ++n10;
                    }
                    ++n8;
                }
                this.init(imageData2);
                break;
            }
            case 2: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                ImageData imageData4 = imageData;
                if (!paletteData.isDirect) {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n16 = 0;
                    while (n16 < rGBArray.length) {
                        if (imageData.transparentPixel != n16) {
                            int n17;
                            RGB rGB = rGBArray[n16];
                            int n18 = rGB.red;
                            int n19 = rGB.green;
                            int n20 = rGB.blue;
                            rGB.green = rGB.blue = (n17 = n18 + n18 + n19 + n19 + n19 + n19 + n19 + n20 >> 3);
                            rGB.red = rGB.blue;
                        }
                        ++n16;
                    }
                    imageData4.palette = new PaletteData(rGBArray);
                } else {
                    RGB[] rGBArray = new RGB[256];
                    int n21 = 0;
                    while (n21 < rGBArray.length) {
                        rGBArray[n21] = new RGB(n21, n21, n21);
                        ++n21;
                    }
                    imageData4 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                    imageData4.alpha = imageData.alpha;
                    imageData4.alphaData = imageData.alphaData;
                    imageData4.maskData = imageData.maskData;
                    imageData4.maskPad = imageData.maskPad;
                    if (imageData.transparentPixel != -1) {
                        imageData4.transparentPixel = 254;
                    }
                    int[] nArray = new int[rectangle.width];
                    int n22 = paletteData.redMask;
                    int n23 = paletteData.greenMask;
                    int n24 = paletteData.blueMask;
                    int n25 = paletteData.redShift;
                    int n26 = paletteData.greenShift;
                    int n27 = paletteData.blueShift;
                    int n28 = 0;
                    while (n28 < rectangle.height) {
                        int n29 = n28 * imageData4.bytesPerLine;
                        imageData.getPixels(0, n28, rectangle.width, nArray, 0);
                        int n30 = 0;
                        while (n30 < rectangle.width) {
                            int n31 = nArray[n30];
                            if (n31 != imageData.transparentPixel) {
                                int n32 = n31 & n22;
                                n32 = n25 < 0 ? n32 >>> -n25 : n32 << n25;
                                int n33 = n31 & n23;
                                n33 = n26 < 0 ? n33 >>> -n26 : n33 << n26;
                                int n34 = n31 & n24;
                                n34 = n27 < 0 ? n34 >>> -n27 : n34 << n27;
                                int n35 = n32 + n32 + n33 + n33 + n33 + n33 + n33 + n34 >> 3;
                                if (imageData4.transparentPixel == n35) {
                                    n35 = 255;
                                }
                                imageData4.data[n29] = (byte)n35;
                            } else {
                                imageData4.data[n29] = -2;
                            }
                            ++n29;
                            ++n30;
                        }
                        ++n28;
                    }
                }
                this.init(imageData4);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        Image.init(this.device, this, imageData, imageData2);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        this.initNative(string);
        if (this.handle == 0L) {
            this.init(new ImageData(string));
        }
        this.init();
    }

    void initNative(String string) {
        boolean bl = true;
        try {
            this.device.checkGDIP();
        }
        catch (SWTException sWTException) {
            bl = false;
        }
        if (bl && OS.PTR_SIZEOF == 8 && string.toLowerCase().endsWith(".gif")) {
            bl = false;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1) && string.toLowerCase().endsWith(".gif")) {
            bl = false;
        }
        if (bl) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            long l = Gdip.Bitmap_new(cArray, false);
            if (l != 0L) {
                int n2 = 2;
                int n3 = Gdip.Image_GetLastStatus(l);
                if (n3 == 0) {
                    if (string.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        long[] lArray = new long[1];
                        n3 = Gdip.Bitmap_GetHICON(l, lArray);
                        this.handle = lArray[0];
                    } else {
                        this.type = 0;
                        int n4 = Gdip.Image_GetWidth(l);
                        int n5 = Gdip.Image_GetHeight(l);
                        int n6 = Gdip.Image_GetPixelFormat(l);
                        switch (n6) {
                            case 135173: 
                            case 135174: {
                                this.handle = Image.createDIB(n4, n5, 16);
                                break;
                            }
                            case 8207: 
                            case 137224: {
                                this.handle = Image.createDIB(n4, n5, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                this.handle = Image.createDIB(n4, n5, 32);
                            }
                        }
                        if (this.handle != 0L) {
                            long l2 = this.device.internal_new_GC(null);
                            long l3 = OS.CreateCompatibleDC(l2);
                            long l4 = OS.SelectObject(l3, this.handle);
                            long l5 = Gdip.Graphics_new(l3);
                            if (l5 != 0L) {
                                Rect rect = new Rect();
                                rect.Width = n4;
                                rect.Height = n5;
                                n3 = Gdip.Graphics_DrawImage(l5, l, rect, 0, 0, n4, n5, 2, 0L, 0L, 0L);
                                if (n3 != 0) {
                                    n2 = 40;
                                    OS.DeleteObject(this.handle);
                                    this.handle = 0L;
                                }
                                Gdip.Graphics_delete(l5);
                            }
                            OS.SelectObject(l3, l4);
                            OS.DeleteDC(l3);
                            this.device.internal_dispose_GC(l2, null);
                        } else {
                            long l6 = Gdip.BitmapData_new();
                            if (l6 != 0L) {
                                n3 = Gdip.Bitmap_LockBits(l, 0L, 0, n6, l6);
                                if (n3 == 0) {
                                    BitmapData bitmapData = new BitmapData();
                                    Gdip.MoveMemory(bitmapData, l6);
                                    int n7 = bitmapData.Stride;
                                    long l7 = bitmapData.Scan0;
                                    int n8 = 0;
                                    int n9 = 4;
                                    int n10 = -1;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: {
                                            n8 = 1;
                                            break;
                                        }
                                        case 197634: {
                                            n8 = 4;
                                            break;
                                        }
                                        case 198659: {
                                            n8 = 8;
                                            break;
                                        }
                                        case 135173: 
                                        case 135174: 
                                        case 397319: {
                                            n8 = 16;
                                            break;
                                        }
                                        case 137224: {
                                            n8 = 24;
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            n8 = 32;
                                        }
                                    }
                                    if (n8 != 0) {
                                        PaletteData paletteData = null;
                                        switch (bitmapData.PixelFormat) {
                                            case 196865: 
                                            case 197634: 
                                            case 198659: {
                                                int n11 = Gdip.Image_GetPaletteSize(l);
                                                long l8 = OS.GetProcessHeap();
                                                long l9 = OS.HeapAlloc(l8, 8, n11);
                                                if (l9 == 0L) {
                                                    SWT.error(2);
                                                }
                                                Gdip.Image_GetPalette(l, l9, n11);
                                                ColorPalette colorPalette = new ColorPalette();
                                                Gdip.MoveMemory(colorPalette, l9, ColorPalette.sizeof);
                                                int[] nArray = new int[colorPalette.Count];
                                                OS.MoveMemory(nArray, l9 + 8L, nArray.length * 4);
                                                OS.HeapFree(l8, 0, l9);
                                                RGB[] rGBArray = new RGB[colorPalette.Count];
                                                paletteData = new PaletteData(rGBArray);
                                                int n12 = 0;
                                                while (n12 < nArray.length) {
                                                    if ((nArray[n12] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                        n10 = n12;
                                                    }
                                                    rGBArray[n12] = new RGB((nArray[n12] & 0xFF0000) >> 16, (nArray[n12] & 0xFF00) >> 8, (nArray[n12] & 0xFF) >> 0);
                                                    ++n12;
                                                }
                                                break;
                                            }
                                            case 135173: 
                                            case 397319: {
                                                paletteData = new PaletteData(31744, 992, 31);
                                                break;
                                            }
                                            case 135174: {
                                                paletteData = new PaletteData(63488, 2016, 31);
                                                break;
                                            }
                                            case 137224: {
                                                paletteData = new PaletteData(255, 65280, 0xFF0000);
                                                break;
                                            }
                                            case 139273: 
                                            case 2498570: {
                                                paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                            }
                                        }
                                        byte[] byArray = new byte[n7 * n5];
                                        byte[] byArray2 = null;
                                        OS.MoveMemory(byArray, l7, byArray.length);
                                        switch (bitmapData.PixelFormat) {
                                            case 397319: {
                                                byArray2 = new byte[n4 * n5];
                                                int n13 = 1;
                                                int n14 = 0;
                                                while (n13 < byArray.length) {
                                                    byArray2[n14] = (byte)((byArray[n13] & 0x80) != 0 ? 255 : 0);
                                                    n13 += 2;
                                                    ++n14;
                                                }
                                                break;
                                            }
                                            case 2498570: {
                                                byArray2 = new byte[n4 * n5];
                                                int n13 = 3;
                                                int n15 = 0;
                                                while (n13 < byArray.length) {
                                                    byArray2[n15] = byArray[n13];
                                                    n13 += 4;
                                                    ++n15;
                                                }
                                                break;
                                            }
                                        }
                                        ImageData imageData = new ImageData(n4, n5, n8, paletteData, n9, byArray);
                                        imageData.transparentPixel = n10;
                                        imageData.alphaData = byArray2;
                                        this.init(imageData);
                                    }
                                    Gdip.Bitmap_UnlockBits(l, l6);
                                } else {
                                    n2 = 40;
                                }
                                Gdip.BitmapData_delete(l6);
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete(l);
                if (n3 == 0 && this.handle == 0L) {
                    SWT.error(n2);
                }
            }
        }
    }

    long createDIBFromDDB(long l, long l2, int n, int n2) {
        long[] lArray;
        long l3;
        int n3;
        Object object;
        int n4;
        int n5;
        int n6 = OS.GetDeviceCaps(l, 12);
        int n7 = n6 * (n5 = OS.GetDeviceCaps(l, 14));
        boolean bl = n7 > 8;
        RGB[] rGBArray = null;
        if (!bl) {
            n4 = 1 << n7;
            object = new byte[4 * n4];
            OS.GetPaletteEntries(this.device.hPalette, 0, n4, (byte[])object);
            rGBArray = new RGB[n4];
            int n8 = 0;
            while (n8 < n4) {
                rGBArray[n8] = new RGB((int)(object[n8] & 0xFF), (int)(object[n8 + 1] & 0xFF), (int)(object[n8 + 2] & 0xFF));
                ++n8;
            }
        }
        n4 = OS.IsWinCE && (n7 == 16 || n7 == 32) ? 1 : 0;
        object = new BITMAPINFOHEADER();
        ((BITMAPINFOHEADER)object).biSize = BITMAPINFOHEADER.sizeof;
        ((BITMAPINFOHEADER)object).biWidth = n;
        ((BITMAPINFOHEADER)object).biHeight = -n2;
        ((BITMAPINFOHEADER)object).biPlanes = 1;
        ((BITMAPINFOHEADER)object).biBitCount = (short)n7;
        ((BITMAPINFOHEADER)object).biCompression = n4 != 0 ? 3 : 0;
        byte[] byArray = bl ? new byte[BITMAPINFOHEADER.sizeof + (n4 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + rGBArray.length * 4];
        OS.MoveMemory(byArray, (BITMAPINFOHEADER)object, BITMAPINFOHEADER.sizeof);
        int n9 = BITMAPINFOHEADER.sizeof;
        if (bl) {
            if (n4 != 0) {
                n3 = 0;
                int n10 = 0;
                int n11 = 0;
                switch (n7) {
                    case 16: {
                        n3 = 31744;
                        n10 = 992;
                        n11 = 31;
                        byArray[n9] = (byte)((n3 & 0xFF) >> 0);
                        byArray[n9 + 1] = (byte)((n3 & 0xFF00) >> 8);
                        byArray[n9 + 2] = (byte)((n3 & 0xFF0000) >> 16);
                        byArray[n9 + 3] = (byte)((n3 & 0xFF000000) >> 24);
                        byArray[n9 + 4] = (byte)((n10 & 0xFF) >> 0);
                        byArray[n9 + 5] = (byte)((n10 & 0xFF00) >> 8);
                        byArray[n9 + 6] = (byte)((n10 & 0xFF0000) >> 16);
                        byArray[n9 + 7] = (byte)((n10 & 0xFF000000) >> 24);
                        byArray[n9 + 8] = (byte)((n11 & 0xFF) >> 0);
                        byArray[n9 + 9] = (byte)((n11 & 0xFF00) >> 8);
                        byArray[n9 + 10] = (byte)((n11 & 0xFF0000) >> 16);
                        byArray[n9 + 11] = (byte)((n11 & 0xFF000000) >> 24);
                        break;
                    }
                    case 32: {
                        n3 = 65280;
                        n10 = 0xFF0000;
                        n11 = -16777216;
                        byArray[n9] = (byte)((n3 & 0xFF000000) >> 24);
                        byArray[n9 + 1] = (byte)((n3 & 0xFF0000) >> 16);
                        byArray[n9 + 2] = (byte)((n3 & 0xFF00) >> 8);
                        byArray[n9 + 3] = (byte)((n3 & 0xFF) >> 0);
                        byArray[n9 + 4] = (byte)((n10 & 0xFF000000) >> 24);
                        byArray[n9 + 5] = (byte)((n10 & 0xFF0000) >> 16);
                        byArray[n9 + 6] = (byte)((n10 & 0xFF00) >> 8);
                        byArray[n9 + 7] = (byte)((n10 & 0xFF) >> 0);
                        byArray[n9 + 8] = (byte)((n11 & 0xFF000000) >> 24);
                        byArray[n9 + 9] = (byte)((n11 & 0xFF0000) >> 16);
                        byArray[n9 + 10] = (byte)((n11 & 0xFF00) >> 8);
                        byArray[n9 + 11] = (byte)((n11 & 0xFF) >> 0);
                        break;
                    }
                    default: {
                        SWT.error(38);
                        break;
                    }
                }
            }
        } else {
            n3 = 0;
            while (n3 < rGBArray.length) {
                byArray[n9] = (byte)rGBArray[n3].blue;
                byArray[n9 + 1] = (byte)rGBArray[n3].green;
                byArray[n9 + 2] = (byte)rGBArray[n3].red;
                byArray[n9 + 3] = 0;
                n9 += 4;
                ++n3;
            }
        }
        if ((l3 = OS.CreateDIBSection(0L, byArray, 0, lArray = new long[1], 0L, 0)) == 0L) {
            SWT.error(2);
        }
        long l4 = OS.CreateCompatibleDC(l);
        long l5 = OS.CreateCompatibleDC(l);
        long l6 = OS.SelectObject(l4, l2);
        long l7 = OS.SelectObject(l5, l3);
        OS.BitBlt(l5, 0, 0, n, n2, l4, 0, 0, 0xCC0020);
        OS.SelectObject(l4, l6);
        OS.SelectObject(l5, l7);
        OS.DeleteDC(l4);
        OS.DeleteDC(l5);
        return l3;
    }

    long[] createGdipImage() {
        switch (this.type) {
            case 0: {
                if (this.alpha != -1 || this.alphaData != null || this.transparentPixel != -1) {
                    int n;
                    int n2;
                    int n3;
                    byte[] byArray;
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                    int n4 = bITMAP.bmWidth;
                    int n5 = bITMAP.bmHeight;
                    long l = this.device.internal_new_GC(null);
                    long l2 = OS.CreateCompatibleDC(l);
                    long l3 = OS.SelectObject(l2, this.handle);
                    long l4 = OS.CreateCompatibleDC(l);
                    long l5 = Image.createDIB(n4, n5, 32);
                    if (l5 == 0L) {
                        SWT.error(2);
                    }
                    long l6 = OS.SelectObject(l4, l5);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(l5, BITMAP.sizeof, bITMAP2);
                    int n6 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(l4, 0, 0, n4, n5, l2, 0, 0, 0xCC0020);
                    byte by = 0;
                    byte by2 = 0;
                    byte by3 = 0;
                    if (this.transparentPixel != -1) {
                        if (bITMAP.bmBitsPixel <= 8) {
                            byArray = new byte[4];
                            OS.GetDIBColorTable(l2, this.transparentPixel, 1, byArray);
                            by3 = byArray[0];
                            by2 = byArray[1];
                            by = byArray[2];
                        } else {
                            switch (bITMAP.bmBitsPixel) {
                                case 16: {
                                    int n7 = 31;
                                    n3 = ImageData.getChannelShift(n7);
                                    byte[] byArray2 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n7, n3)];
                                    by3 = byArray2[(this.transparentPixel & n7) >> n3];
                                    n2 = 992;
                                    n = ImageData.getChannelShift(n2);
                                    byte[] byArray3 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n2, n)];
                                    by2 = byArray3[(this.transparentPixel & n2) >> n];
                                    int n8 = 31744;
                                    int n9 = ImageData.getChannelShift(n8);
                                    byte[] byArray4 = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(n8, n9)];
                                    by = byArray4[(this.transparentPixel & n8) >> n9];
                                    break;
                                }
                                case 24: {
                                    by3 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by2 = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    by = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    by3 = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    by2 = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    by = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                    }
                    OS.SelectObject(l2, l3);
                    OS.SelectObject(l4, l6);
                    OS.DeleteObject(l2);
                    OS.DeleteObject(l4);
                    byArray = new byte[n6];
                    OS.MoveMemory(byArray, bITMAP2.bmBits, n6);
                    OS.DeleteObject(l5);
                    this.device.internal_dispose_GC(l, null);
                    if (this.alpha != -1) {
                        n3 = 0;
                        int n10 = 0;
                        while (n3 < n5) {
                            n2 = 0;
                            while (n2 < n4) {
                                byArray[n10 + 3] = (byte)this.alpha;
                                n10 += 4;
                                ++n2;
                            }
                            ++n3;
                        }
                    } else if (this.alphaData != null) {
                        n3 = 0;
                        int n11 = 0;
                        n2 = 0;
                        while (n3 < n5) {
                            n = 0;
                            while (n < n4) {
                                byArray[n11 + 3] = this.alphaData[n2++];
                                n11 += 4;
                                ++n;
                            }
                            ++n3;
                        }
                    } else if (this.transparentPixel != -1) {
                        n3 = 0;
                        int n12 = 0;
                        while (n3 < n5) {
                            n2 = 0;
                            while (n2 < n4) {
                                byArray[n12 + 3] = byArray[n12] == by3 && byArray[n12 + 1] == by2 && byArray[n12 + 2] == by ? 0 : -1;
                                n12 += 4;
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    long l7 = OS.GetProcessHeap();
                    long l8 = OS.HeapAlloc(l7, 8, byArray.length);
                    if (l8 == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(l8, byArray, n6);
                    return new long[]{Gdip.Bitmap_new(n4, n5, bITMAP2.bmWidthBytes, 2498570, l8), l8};
                }
                long[] lArray = new long[2];
                lArray[0] = Gdip.Bitmap_new(this.handle, 0L);
                return lArray;
            }
            case 1: {
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    Image.GetIconInfo(this, iCONINFO);
                } else {
                    OS.GetIconInfo(this.handle, iCONINFO);
                }
                long l = iCONINFO.hbmColor;
                if (l == 0L) {
                    l = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(l, BITMAP.sizeof, bITMAP);
                int n = bITMAP.bmWidth;
                int n13 = l == iCONINFO.hbmMask ? bITMAP.bmHeight / 2 : bITMAP.bmHeight;
                long l9 = 0L;
                long l10 = 0L;
                if (n > n13 || bITMAP.bmBitsPixel == 32) {
                    long l11 = this.device.internal_new_GC(null);
                    long l12 = OS.CreateCompatibleDC(l11);
                    long l13 = OS.SelectObject(l12, l);
                    long l14 = OS.CreateCompatibleDC(l11);
                    long l15 = Image.createDIB(n, n13, 32);
                    if (l15 == 0L) {
                        SWT.error(2);
                    }
                    long l16 = OS.SelectObject(l14, l15);
                    BITMAP bITMAP3 = new BITMAP();
                    OS.GetObject(l15, BITMAP.sizeof, bITMAP3);
                    OS.BitBlt(l14, 0, 0, n, n13, l12, 0, l == iCONINFO.hbmMask ? n13 : 0, 0xCC0020);
                    OS.SelectObject(l14, l16);
                    OS.DeleteObject(l14);
                    byte[] byArray = new byte[bITMAP3.bmWidthBytes * bITMAP3.bmHeight];
                    OS.MoveMemory(byArray, bITMAP3.bmBits, byArray.length);
                    OS.DeleteObject(l15);
                    OS.SelectObject(l12, iCONINFO.hbmMask);
                    int n14 = 0;
                    int n15 = 3;
                    while (n14 < n13) {
                        int n16 = 0;
                        while (n16 < n) {
                            if (byArray[n15] == 0) {
                                byArray[n15] = OS.GetPixel(l12, n16, n14) != 0 ? 0 : -1;
                            }
                            n15 += 4;
                            ++n16;
                        }
                        ++n14;
                    }
                    OS.SelectObject(l12, l13);
                    OS.DeleteObject(l12);
                    this.device.internal_dispose_GC(l11, null);
                    long l17 = OS.GetProcessHeap();
                    l10 = OS.HeapAlloc(l17, 8, byArray.length);
                    if (l10 == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(l10, byArray, byArray.length);
                    l9 = Gdip.Bitmap_new(n, n13, bITMAP3.bmWidthBytes, 2498570, l10);
                } else {
                    l9 = Gdip.Bitmap_new(this.handle);
                }
                if (iCONINFO.hbmColor != 0L) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0L) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                return new long[]{l9, l10};
            }
        }
        SWT.error(40);
        return null;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            if (OS.IsWinCE) {
                this.data = null;
            }
            OS.DestroyIcon(this.handle);
        } else {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        long l = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        long l2 = OS.CreateCompatibleDC(l);
        long l3 = OS.SelectObject(l2, this.handle);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (bITMAP.bmBitsPixel <= 8) {
            if (OS.IsWinCE) {
                byte[] byArray = new byte[1];
                OS.MoveMemory(byArray, bITMAP.bmBits, 1);
                byte by = byArray[0];
                int n4 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                byArray[0] = (byte)(this.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray[0] & ~n4);
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                int n5 = OS.GetPixel(l2, 0, 0);
                byArray[0] = by;
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                n3 = (n5 & 0xFF0000) >> 16;
                n2 = (n5 & 0xFF00) >> 8;
                n = n5 & 0xFF;
            } else {
                byte[] byArray = new byte[4];
                OS.GetDIBColorTable(l2, this.transparentPixel, 1, byArray);
                n3 = byArray[0] & 0xFF;
                n2 = byArray[1] & 0xFF;
                n = byArray[2] & 0xFF;
            }
        } else {
            switch (bITMAP.bmBitsPixel) {
                case 16: {
                    n3 = (this.transparentPixel & 0x1F) << 3;
                    n2 = (this.transparentPixel & 0x3E0) >> 2;
                    n = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    n3 = (this.transparentPixel & 0xFF0000) >> 16;
                    n2 = (this.transparentPixel & 0xFF00) >> 8;
                    n = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    n3 = (this.transparentPixel & 0xFF000000) >>> 24;
                    n2 = (this.transparentPixel & 0xFF0000) >> 16;
                    n = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(l2, l3);
        OS.DeleteDC(l2);
        this.device.internal_dispose_GC(l, null);
        return Color.win32_new(this.device, n3 << 16 | n2 << 8 | n);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        switch (this.type) {
            case 0: {
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
            case 1: {
                if (OS.IsWinCE) {
                    this.width = this.data.width;
                    this.height = this.data.height;
                    return new Rectangle(0, 0, this.width, this.height);
                }
                ICONINFO iCONINFO = new ICONINFO();
                OS.GetIconInfo(this.handle, iCONINFO);
                long l = iCONINFO.hbmColor;
                if (l == 0L) {
                    l = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(l, BITMAP.sizeof, bITMAP);
                if (l == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                if (iCONINFO.hbmColor != 0L) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0L) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                this.width = bITMAP.bmWidth;
                this.height = bITMAP.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
        }
        SWT.error(40);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int n;
                int n2;
                Object[] objectArray;
                long l;
                if (OS.IsWinCE) {
                    return this.data;
                }
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetIconInfo(this.handle, iCONINFO);
                long l2 = iCONINFO.hbmColor;
                if (l2 == 0L) {
                    l2 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(l2, BITMAP.sizeof, bITMAP);
                int n3 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n4 = bITMAP.bmWidth;
                if (l2 == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                int n5 = bITMAP.bmHeight;
                int n6 = 0;
                if (n3 <= 8) {
                    n6 = 1 << n3;
                }
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                bITMAPINFOHEADER.biWidth = n4;
                bITMAPINFOHEADER.biHeight = -n5;
                bITMAPINFOHEADER.biPlanes = 1;
                bITMAPINFOHEADER.biBitCount = (short)n3;
                bITMAPINFOHEADER.biCompression = 0;
                byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n6 * 4];
                OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                long l3 = this.device.internal_new_GC(null);
                long l4 = OS.CreateCompatibleDC(l3);
                long l5 = OS.SelectObject(l4, l2);
                long l6 = 0L;
                if (n3 <= 8 && (l = this.device.hPalette) != 0L) {
                    l6 = OS.SelectPalette(l4, l, false);
                    OS.RealizePalette(l4);
                }
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(l4, l2, 0, n5, null, byArray, 0);
                OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                int n7 = bITMAPINFOHEADER.biSizeImage;
                byte[] byArray2 = new byte[n7];
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(l4, l2, 0, n5, byArray2, byArray, 0);
                PaletteData paletteData = null;
                if (n3 <= 8) {
                    objectArray = new RGB[n6];
                    n2 = 40;
                    n = 0;
                    while (n < n6) {
                        objectArray[n] = new RGB(byArray[n2 + 2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2] & 0xFF);
                        n2 += 4;
                        ++n;
                    }
                    paletteData = new PaletteData((RGB[])objectArray);
                } else if (n3 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n3 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n3 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                objectArray = null;
                if (iCONINFO.hbmColor == 0L) {
                    objectArray = new byte[n7];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(l4, l2, n5, n5, (byte[])objectArray, byArray, 0);
                } else {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n4;
                    bITMAPINFOHEADER.biHeight = -n5;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = 1;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + 8];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    n2 = BITMAPINFOHEADER.sizeof;
                    byArray[n2 + 6] = -1;
                    byArray[n2 + 5] = -1;
                    byArray[n2 + 4] = -1;
                    byArray[n2 + 7] = 0;
                    OS.SelectObject(l4, iCONINFO.hbmMask);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(l4, iCONINFO.hbmMask, 0, n5, null, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n7 = bITMAPINFOHEADER.biSizeImage;
                    objectArray = new byte[n7];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(l4, iCONINFO.hbmMask, 0, n5, (byte[])objectArray, byArray, 0);
                    n = 0;
                    while (n < objectArray.length) {
                        int n8 = n++;
                        objectArray[n8] = (RGB)((byte)(~objectArray[n8]));
                    }
                    int n9 = n7 / n5;
                    n = 1;
                    while (n < 128) {
                        int n10 = ((n4 + 7) / 8 + (n - 1)) / n * n;
                        if (n10 == n9) break;
                        ++n;
                    }
                    objectArray = ImageData.convertPad((byte[])objectArray, n4, n5, 1, n, 2);
                }
                OS.SelectObject(l4, l5);
                if (l6 != 0L) {
                    OS.SelectPalette(l4, l6, false);
                    OS.RealizePalette(l4);
                }
                OS.DeleteDC(l4);
                this.device.internal_dispose_GC(l3, null);
                if (iCONINFO.hbmColor != 0L) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0L) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                ImageData imageData = new ImageData(n4, n5, n3, paletteData, 4, byArray2);
                imageData.maskData = (byte[])objectArray;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                Object object;
                int n;
                long l;
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
                int n11 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n12 = bITMAP.bmWidth;
                int n13 = bITMAP.bmHeight;
                boolean bl = bITMAP.bmBits != 0L;
                long l7 = this.device.internal_new_GC(null);
                long l8 = this.handle;
                if (OS.IsWinCE && !bl) {
                    boolean bl2 = false;
                    if (this.memGC != null && !this.memGC.isDisposed()) {
                        this.memGC.flush();
                        bl2 = true;
                        GCData gCData = this.memGC.data;
                        if (gCData.hNullBitmap != 0L) {
                            OS.SelectObject(this.memGC.handle, gCData.hNullBitmap);
                            gCData.hNullBitmap = 0L;
                        }
                    }
                    l8 = this.createDIBFromDDB(l7, this.handle, n12, n13);
                    if (bl2) {
                        long l9;
                        this.memGC.data.hNullBitmap = l9 = OS.SelectObject(this.memGC.handle, this.handle);
                    }
                    bl = true;
                }
                DIBSECTION dIBSECTION = null;
                if (bl) {
                    dIBSECTION = new DIBSECTION();
                    OS.GetObject(l8, DIBSECTION.sizeof, dIBSECTION);
                }
                int n14 = 0;
                if (n11 <= 8) {
                    n14 = bl ? dIBSECTION.biClrUsed : 1 << n11;
                }
                byte[] byArray = null;
                BITMAPINFOHEADER bITMAPINFOHEADER = null;
                if (!bl) {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n12;
                    bITMAPINFOHEADER.biHeight = -n13;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)n11;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[BITMAPINFOHEADER.sizeof + n14 * 4];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                }
                long l10 = OS.CreateCompatibleDC(l7);
                long l11 = OS.SelectObject(l10, l8);
                long l12 = 0L;
                if (!bl && n11 <= 8 && (l = this.device.hPalette) != 0L) {
                    l12 = OS.SelectPalette(l10, l, false);
                    OS.RealizePalette(l10);
                }
                if (bl) {
                    n = dIBSECTION.biSizeImage;
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(l10, l8, 0, n13, null, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, BITMAPINFOHEADER.sizeof);
                    n = bITMAPINFOHEADER.biSizeImage;
                }
                byte[] byArray3 = new byte[n];
                if (bl) {
                    if (OS.IsWinCE && this.handle != l8) {
                        OS.MoveMemory(byArray3, dIBSECTION.bmBits, n);
                    } else {
                        OS.MoveMemory(byArray3, bITMAP.bmBits, n);
                    }
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(l10, l8, 0, n13, byArray3, byArray, 0);
                }
                PaletteData paletteData = null;
                if (n11 <= 8) {
                    object = new RGB[n14];
                    if (bl) {
                        if (OS.IsWinCE) {
                            int n15 = 0;
                            int n16 = 0;
                            int n17 = 0;
                            byte[] byArray4 = new byte[1];
                            OS.MoveMemory(byArray4, bITMAP.bmBits, 1);
                            byte by = byArray4[0];
                            int n18 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                            int n19 = 0;
                            while (n19 < n14) {
                                byArray4[0] = (byte)(n19 << 8 - bITMAP.bmBitsPixel | byArray4[0] & ~n18);
                                OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                                int n20 = OS.GetPixel(l10, 0, 0);
                                n17 = (n20 & 0xFF0000) >> 16;
                                n16 = (n20 & 0xFF00) >> 8;
                                n15 = n20 & 0xFF;
                                object[n19] = new RGB(n15, n16, n17);
                                ++n19;
                            }
                            byArray4[0] = by;
                            OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                        } else {
                            byte[] byArray5 = new byte[n14 * 4];
                            OS.GetDIBColorTable(l10, 0, n14, byArray5);
                            int n21 = 0;
                            int n22 = 0;
                            while (n22 < ((RGB[])object).length) {
                                object[n22] = new RGB(byArray5[n21 + 2] & 0xFF, byArray5[n21 + 1] & 0xFF, byArray5[n21] & 0xFF);
                                n21 += 4;
                                ++n22;
                            }
                        }
                    } else {
                        int n23 = BITMAPINFOHEADER.sizeof;
                        int n24 = 0;
                        while (n24 < n14) {
                            object[n24] = new RGB(byArray[n23 + 2] & 0xFF, byArray[n23 + 1] & 0xFF, byArray[n23] & 0xFF);
                            n23 += 4;
                            ++n24;
                        }
                    }
                    paletteData = new PaletteData((RGB[])object);
                } else if (n11 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n11 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n11 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject(l10, l11);
                if (l12 != 0L) {
                    OS.SelectPalette(l10, l12, false);
                    OS.RealizePalette(l10);
                }
                if (OS.IsWinCE && l8 != this.handle) {
                    OS.DeleteObject(l8);
                }
                OS.DeleteDC(l10);
                this.device.internal_dispose_GC(l7, null);
                object = new ImageData(n12, n13, n11, paletteData, 4, byArray3);
                object.transparentPixel = this.transparentPixel;
                object.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    object.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, object.alphaData, 0, this.alphaData.length);
                }
                return object;
            }
        }
        SWT.error(40);
        return null;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        long l = this.device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap(l, n, n2);
        if (this.handle == 0L) {
            int n3;
            int n4 = OS.GetDeviceCaps(l, 12);
            int n5 = n4 * (n3 = OS.GetDeviceCaps(l, 14));
            if (n5 < 16) {
                n5 = 16;
            }
            this.handle = Image.createDIB(n, n2, n5);
        }
        if (this.handle != 0L) {
            long l2 = OS.CreateCompatibleDC(l);
            long l3 = OS.SelectObject(l2, this.handle);
            OS.PatBlt(l2, 0, 0, n, n2, 15728673);
            OS.SelectObject(l2, l3);
            OS.DeleteDC(l2);
        }
        this.device.internal_dispose_GC(l, null);
        if (this.handle == 0L) {
            SWT.error(2, null, this.device.getLastError());
        }
    }

    static long createDIB(int n, int n2, int n3) {
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n;
        bITMAPINFOHEADER.biHeight = -n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)n3;
        bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        if (OS.IsWinCE) {
            int n4 = 65280;
            int n5 = 0xFF0000;
            int n6 = -16777216;
            int n7 = BITMAPINFOHEADER.sizeof;
            byArray[n7] = (byte)((n4 & 0xFF000000) >> 24);
            byArray[n7 + 1] = (byte)((n4 & 0xFF0000) >> 16);
            byArray[n7 + 2] = (byte)((n4 & 0xFF00) >> 8);
            byArray[n7 + 3] = (byte)((n4 & 0xFF) >> 0);
            byArray[n7 + 4] = (byte)((n5 & 0xFF000000) >> 24);
            byArray[n7 + 5] = (byte)((n5 & 0xFF0000) >> 16);
            byArray[n7 + 6] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n7 + 7] = (byte)((n5 & 0xFF) >> 0);
            byArray[n7 + 8] = (byte)((n6 & 0xFF000000) >> 24);
            byArray[n7 + 9] = (byte)((n6 & 0xFF0000) >> 16);
            byArray[n7 + 10] = (byte)((n6 & 0xFF00) >> 8);
            byArray[n7 + 11] = (byte)((n6 & 0xFF) >> 0);
        }
        long[] lArray = new long[1];
        return OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
    }

    static void GetIconInfo(Image image, ICONINFO iCONINFO) {
        long[] lArray = Image.init(image.device, null, image.data);
        iCONINFO.hbmColor = lArray[0];
        iCONINFO.hbmMask = lArray[1];
    }

    static long[] init(Device device, Image image, ImageData object) {
        long[] lArray;
        long l;
        int n;
        int n2;
        int n3;
        Object object2;
        if (OS.IsWin95 && ((ImageData)object).depth == 1 && ((ImageData)object).getTransparencyType() != 2 || ((ImageData)object).depth == 2) {
            object2 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 4, ((ImageData)object).palette);
            ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, null, null, null, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, null, null, null, false, false);
            ((ImageData)object2).transparentPixel = ((ImageData)object).transparentPixel;
            ((ImageData)object2).maskPad = ((ImageData)object).maskPad;
            ((ImageData)object2).maskData = ((ImageData)object).maskData;
            ((ImageData)object2).alpha = ((ImageData)object).alpha;
            ((ImageData)object2).alphaData = ((ImageData)object).alphaData;
            object = object2;
        }
        if (((ImageData)object).palette.isDirect) {
            object2 = ((ImageData)object).palette;
            n3 = ((PaletteData)object2).redMask;
            int n4 = ((PaletteData)object2).greenMask;
            int n5 = ((PaletteData)object2).blueMask;
            n2 = ((ImageData)object).depth;
            n = 1;
            PaletteData paletteData = null;
            switch (((ImageData)object).depth) {
                case 8: {
                    n2 = 16;
                    n = 0;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    n = 0;
                    if (n3 == 31744 && n4 == 992 && n5 == 31) break;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (n3 == 255 && n4 == 65280 && n5 == 0xFF0000) break;
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (n3 == 65280 && n4 == 0xFF0000 && n5 == -16777216) break;
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (paletteData != null) {
                ImageData imageData = new ImageData(((ImageData)object).width, ((ImageData)object).height, n2, paletteData);
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, n3, n4, n5, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, n, 0, 0, imageData.width, imageData.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
                if (((ImageData)object).transparentPixel != -1) {
                    imageData.transparentPixel = paletteData.getPixel(((PaletteData)object2).getRGB(((ImageData)object).transparentPixel));
                }
                imageData.maskPad = ((ImageData)object).maskPad;
                imageData.maskData = ((ImageData)object).maskData;
                imageData.alpha = ((ImageData)object).alpha;
                imageData.alphaData = ((ImageData)object).alphaData;
                object = imageData;
            }
        }
        object2 = ((ImageData)object).palette.getRGBs();
        n3 = OS.IsWinCE && (((ImageData)object).depth == 16 || ((ImageData)object).depth == 32) ? 1 : 0;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = ((ImageData)object).width;
        bITMAPINFOHEADER.biHeight = -((ImageData)object).height;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)((ImageData)object).depth;
        bITMAPINFOHEADER.biCompression = n3 != 0 ? 3 : 0;
        int n6 = bITMAPINFOHEADER.biClrUsed = object2 == null ? 0 : ((RGB[])object2).length;
        byte[] byArray = ((ImageData)object).palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof + (n3 != 0 ? 12 : 0)] : new byte[BITMAPINFOHEADER.sizeof + ((RGB[])object2).length * 4];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        n2 = BITMAPINFOHEADER.sizeof;
        if (((ImageData)object).palette.isDirect) {
            if (n3 != 0) {
                PaletteData paletteData = ((ImageData)object).palette;
                int n7 = paletteData.redMask;
                int n8 = paletteData.greenMask;
                int n9 = paletteData.blueMask;
                if (((ImageData)object).getByteOrder() == 0) {
                    byArray[n2] = (byte)((n7 & 0xFF) >> 0);
                    byArray[n2 + 1] = (byte)((n7 & 0xFF00) >> 8);
                    byArray[n2 + 2] = (byte)((n7 & 0xFF0000) >> 16);
                    byArray[n2 + 3] = (byte)((n7 & 0xFF000000) >> 24);
                    byArray[n2 + 4] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n2 + 5] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n2 + 6] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n2 + 7] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n2 + 8] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n2 + 9] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n2 + 10] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n2 + 11] = (byte)((n9 & 0xFF000000) >> 24);
                } else {
                    byArray[n2] = (byte)((n7 & 0xFF000000) >> 24);
                    byArray[n2 + 1] = (byte)((n7 & 0xFF0000) >> 16);
                    byArray[n2 + 2] = (byte)((n7 & 0xFF00) >> 8);
                    byArray[n2 + 3] = (byte)((n7 & 0xFF) >> 0);
                    byArray[n2 + 4] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n2 + 5] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n2 + 6] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n2 + 7] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n2 + 8] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n2 + 9] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n2 + 10] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n2 + 11] = (byte)((n9 & 0xFF) >> 0);
                }
            }
        } else {
            n = 0;
            while (n < ((RGB[])object2).length) {
                byArray[n2] = (byte)object2[n].blue;
                byArray[n2 + 1] = (byte)((RGB)object2[n]).green;
                byArray[n2 + 2] = (byte)((RGB)object2[n]).red;
                byArray[n2 + 3] = 0;
                n2 += 4;
                ++n;
            }
        }
        if ((l = OS.CreateDIBSection(0L, byArray, 0, lArray = new long[1], 0L, 0)) == 0L) {
            SWT.error(2);
        }
        byte[] byArray2 = ((ImageData)object).data;
        if (((ImageData)object).scanlinePad != 4 && ((ImageData)object).bytesPerLine % 4 != 0) {
            byArray2 = ImageData.convertPad(byArray2, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 4);
        }
        OS.MoveMemory(lArray[0], byArray2, byArray2.length);
        long[] lArray2 = null;
        if (((ImageData)object).getTransparencyType() == 2) {
            long l2 = device.internal_new_GC(null);
            long l3 = OS.CreateCompatibleDC(l2);
            OS.SelectObject(l3, l);
            long l4 = OS.CreateCompatibleBitmap(l2, ((ImageData)object).width, ((ImageData)object).height);
            if (l4 == 0L) {
                SWT.error(2);
            }
            long l5 = OS.CreateCompatibleDC(l2);
            OS.SelectObject(l5, l4);
            OS.BitBlt(l5, 0, 0, ((ImageData)object).width, ((ImageData)object).height, l3, 0, 0, 0xCC0020);
            device.internal_dispose_GC(l2, null);
            byte[] byArray3 = ImageData.convertPad(((ImageData)object).maskData, ((ImageData)object).width, ((ImageData)object).height, 1, ((ImageData)object).maskPad, 2);
            long l6 = OS.CreateBitmap(((ImageData)object).width, ((ImageData)object).height, 1, 1, byArray3);
            if (l6 == 0L) {
                SWT.error(2);
            }
            OS.SelectObject(l3, l6);
            OS.PatBlt(l3, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0x550009);
            OS.DeleteDC(l3);
            OS.DeleteDC(l5);
            OS.DeleteObject(l);
            if (image == null) {
                lArray2 = new long[]{l4, l6};
            } else {
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                iCONINFO.hbmColor = l4;
                iCONINFO.hbmMask = l6;
                long l7 = OS.CreateIconIndirect(iCONINFO);
                if (l7 == 0L) {
                    SWT.error(2);
                }
                OS.DeleteObject(l4);
                OS.DeleteObject(l6);
                image.handle = l7;
                image.type = 1;
                if (OS.IsWinCE) {
                    image.data = object;
                }
            }
        } else if (image == null) {
            lArray2 = new long[]{l};
        } else {
            image.handle = l;
            image.type = 0;
            image.transparentPixel = ((ImageData)object).transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = ((ImageData)object).alpha;
                if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData != null) {
                    int n10 = ((ImageData)object).alphaData.length;
                    image.alphaData = new byte[n10];
                    System.arraycopy(((ImageData)object).alphaData, 0, image.alphaData, 0, n10);
                }
            }
        }
        return lArray2;
    }

    /*
     * Unable to fully structure code
     */
    static long[] init(Device var0, Image var1_1, ImageData var2_2, ImageData var3_3) {
        block13: {
            block12: {
                var5_4 = 0;
                if (!var2_2.palette.isDirect) break block12;
                var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, var2_2.palette);
                break block13;
            }
            var6_6 = new RGB(0, 0, 0);
            var7_7 = var2_2.getRGBs();
            if (var2_2.transparentPixel == -1) ** GOTO lbl27
            var8_8 = new RGB[var7_7.length];
            System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
            if (var2_2.transparentPixel >= var8_8.length) {
                var7_7 = new RGB[var2_2.transparentPixel + 1];
                System.arraycopy(var8_8, 0, var7_7, 0, var8_8.length);
                var9_10 = var8_8.length;
                while (var9_10 <= var2_2.transparentPixel) {
                    var7_7[var9_10] = new RGB(0, 0, 0);
                    ++var9_10;
                }
            } else {
                var8_8[var2_2.transparentPixel] = var6_6;
                var7_7 = var8_8;
            }
            var5_4 = var2_2.transparentPixel;
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
            break block13;
            while (!var7_7[var5_4].equals(var6_6)) {
                ++var5_4;
lbl27:
                // 2 sources

                if (var5_4 < var7_7.length) continue;
            }
            if (var5_4 == var7_7.length) {
                if (1 << var2_2.depth > var7_7.length) {
                    var8_8 = new RGB[var7_7.length + 1];
                    System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
                    var8_8[var7_7.length] = var6_6;
                    var7_7 = var8_8;
                } else {
                    var5_4 = -1;
                }
            }
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
        }
        if (var5_4 == -1) {
            System.arraycopy(var2_2.data, 0, var4_5.data, 0, var4_5.data.length);
        } else {
            var6_6 = new int[var4_5.width];
            var7_7 = (RGB[])new int[var3_3.width];
            var8_9 = 0;
            while (var8_9 < var4_5.height) {
                var2_2.getPixels(0, var8_9, var4_5.width, (int[])var6_6, 0);
                var3_3.getPixels(0, var8_9, var3_3.width, (int[])var7_7, 0);
                var9_10 = 0;
                while (var9_10 < ((Object)var6_6).length) {
                    if (var7_7[var9_10] == false) {
                        var6_6[var9_10] = var5_4;
                    }
                    ++var9_10;
                }
                var4_5.setPixels(0, var8_9, var2_2.width, (int[])var6_6, 0);
                ++var8_9;
            }
        }
        var4_5.maskPad = var3_3.scanlinePad;
        var4_5.maskData = var3_3.data;
        return Image.init(var0, var1_1, var4_5);
    }

    void init(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        Image.init(this.device, this, imageData);
    }

    public long internal_new_GC(GCData gCData) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long l = this.device.internal_new_GC(null);
        long l2 = OS.CreateCompatibleDC(l);
        this.device.internal_dispose_GC(l, null);
        if (l2 == 0L) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.image = this;
            gCData.font = this.device.systemFont;
        }
        return l2;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        OS.DeleteDC(l);
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void setBackground(Color color) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        this.transparentColor = -1;
        long l = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bITMAP);
        long l2 = OS.CreateCompatibleDC(l);
        OS.SelectObject(l2, this.handle);
        int n = 1 << bITMAP.bmBitsPixel;
        byte[] byArray = new byte[n * 4];
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n2 = OS.GetDIBColorTable(l2, 0, n, byArray);
        int n3 = this.transparentPixel * 4;
        byArray[n3] = (byte)color.getBlue();
        byArray[n3 + 1] = (byte)color.getGreen();
        byArray[n3 + 2] = (byte)color.getRed();
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        OS.SetDIBColorTable(l2, 0, n2, byArray);
        OS.DeleteDC(l2);
        this.device.internal_dispose_GC(l, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int n, long l) {
        Image image = new Image(device);
        image.type = n;
        image.handle = l;
        return image;
    }
}

