/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    static PrinterData[] printerList;
    static long findPrinter;
    static PrinterData findData;
    PrinterData data;
    long printer;
    long printJob;
    long settings;
    long pageSetup;
    long surface;
    long cairo;
    boolean isGCCreated = false;
    Font systemFont;
    static byte[] settingsData;
    static int start;
    static int end;
    static final String GTK_LPR_BACKEND = "GtkPrintBackendLpr";
    static final String GTK_FILE_BACKEND = "GtkPrintBackendFile";
    static boolean disablePrinting;
    static /* synthetic */ Class class$0;

    static {
        disablePrinting = System.getProperty("org.eclipse.swt.internal.gtk.disablePrinting") != null;
    }

    static void gtk_init() {
        if (!OS.g_thread_supported()) {
            OS.g_thread_init(0L);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 24, 0)) {
            OS.gtk_set_locale();
        }
        if (!OS.gtk_init_check(new long[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
    }

    public static PrinterData[] getPrinterList() {
        Callback callback;
        long l;
        printerList = new PrinterData[0];
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            return printerList;
        }
        Printer.gtk_init();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.Printer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((l = (callback = new Callback(clazz, "GtkPrinterFunc_List", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(l, 0L, 0L, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return printerList;
    }

    static long GtkPrinterFunc_List(long l, long l2) {
        int n = printerList.length;
        PrinterData[] printerDataArray = new PrinterData[n + 1];
        System.arraycopy(printerList, 0, printerDataArray, 0, n);
        printerList = printerDataArray;
        Printer.printerList[n] = Printer.printerDataFromGtkPrinter(l);
        if (Printer.printerList[n].driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    public static PrinterData getDefaultPrinterData() {
        Callback callback;
        long l;
        findData = null;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            return null;
        }
        Printer.gtk_init();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.Printer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((l = (callback = new Callback(clazz, "GtkPrinterFunc_Default", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(l, 0L, 0L, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return findData;
    }

    static long GtkPrinterFunc_Default(long l, long l2) {
        if (OS.gtk_printer_is_default(l)) {
            findData = Printer.printerDataFromGtkPrinter(l);
            return 1L;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && Printer.printerDataFromGtkPrinter((long)l).driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    static long gtkPrinterFromPrinterData(PrinterData printerData) {
        Callback callback;
        long l;
        Printer.gtk_init();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.Printer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((l = (callback = new Callback(clazz, "GtkPrinterFunc_FindNamedPrinter", 2)).getAddress()) == 0L) {
            SWT.error(3);
        }
        findPrinter = 0L;
        findData = printerData;
        OS.gtk_enumerate_printers(l, 0L, 0L, true);
        OS.gdk_threads_leave();
        callback.dispose();
        return findPrinter;
    }

    static long GtkPrinterFunc_FindNamedPrinter(long l, long l2) {
        PrinterData printerData = Printer.printerDataFromGtkPrinter(l);
        if (printerData.driver.equals(Printer.findData.driver) && printerData.name.equals(Printer.findData.name) || printerData.driver.equals(GTK_FILE_BACKEND) && Printer.findData.printToFile && Printer.findData.driver == null && Printer.findData.name == null) {
            findPrinter = l;
            OS.g_object_ref(l);
            return 1L;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 12) && printerData.driver.equals(GTK_LPR_BACKEND)) {
            return 1L;
        }
        return 0L;
    }

    static PrinterData printerDataFromGtkPrinter(long l) {
        long l2 = OS.gtk_printer_get_backend(l);
        long l3 = OS.G_OBJECT_TYPE_NAME(l2);
        int n = OS.strlen(l3);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string = new String(Converter.mbcsToWcs(null, byArray));
        l3 = OS.gtk_printer_get_name(l);
        n = OS.strlen(l3);
        byArray = new byte[n];
        OS.memmove(byArray, l3, (long)n);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        return new PrinterData(string, string2);
    }

    static void restore(byte[] byArray, long l, long l2) {
        byte[] byArray2;
        byte[] byArray3;
        settingsData = byArray;
        end = 0;
        start = 0;
        while (end < settingsData.length && settingsData[end] != 0) {
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byArray3 = new byte[++end - start];
            System.arraycopy(settingsData, start, byArray3, 0, byArray3.length);
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byArray2 = new byte[++end - start];
            System.arraycopy(settingsData, start, byArray2, 0, byArray2.length);
            OS.gtk_print_settings_set(l, byArray3, byArray2);
            if (!DEBUG) continue;
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, byArray3))) + ": " + new String(Converter.mbcsToWcs(null, byArray2)));
        }
        ++end;
        OS.gtk_page_setup_set_orientation(l2, Printer.restoreInt("orientation"));
        OS.gtk_page_setup_set_top_margin(l2, Printer.restoreDouble("top_margin"), 3);
        OS.gtk_page_setup_set_bottom_margin(l2, Printer.restoreDouble("bottom_margin"), 3);
        OS.gtk_page_setup_set_left_margin(l2, Printer.restoreDouble("left_margin"), 3);
        OS.gtk_page_setup_set_right_margin(l2, Printer.restoreDouble("right_margin"), 3);
        byArray3 = Printer.restoreBytes("paper_size_name", true);
        byArray2 = Printer.restoreBytes("paper_size_display_name", true);
        byte[] byArray4 = Printer.restoreBytes("paper_size_ppd_name", true);
        double d = Printer.restoreDouble("paper_size_width");
        double d2 = Printer.restoreDouble("paper_size_height");
        boolean bl = Printer.restoreBoolean("paper_size_is_custom");
        long l3 = 0L;
        l3 = bl ? (byArray4.length > 0 ? OS.gtk_paper_size_new_from_ppd(byArray4, byArray2, d, d2) : OS.gtk_paper_size_new_custom(byArray3, byArray2, d, d2, 3)) : OS.gtk_paper_size_new(byArray3);
        OS.gtk_page_setup_set_paper_size(l2, l3);
        OS.gtk_paper_size_free(l3);
    }

    static byte[] uriFromFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        long[] lArray = new long[1];
        long l = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, lArray);
        if (lArray[0] != 0L || l == 0L) {
            return null;
        }
        long l2 = OS.g_filename_from_utf8(l, -1L, null, null, lArray);
        OS.g_free(l);
        if (lArray[0] != 0L || l2 == 0L) {
            return null;
        }
        long l3 = OS.g_filename_to_uri(l2, 0L, lArray);
        OS.g_free(l2);
        if (lArray[0] != 0L || l3 == 0L) {
            return null;
        }
        n = OS.strlen(l3);
        byte[] byArray = new byte[n + 1];
        OS.memmove(byArray, l3, (long)n);
        OS.g_free(l3);
        return byArray;
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            long l;
            PrinterData printerData2 = null;
            if (printerData.printToFile && (l = Printer.gtkPrinterFromPrinterData(printerData)) != 0L) {
                printerData2 = Printer.printerDataFromGtkPrinter(l);
                OS.g_object_unref(l);
            }
            if (printerData2 == null && (printerData2 = Printer.getDefaultPrinterData()) == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    static int restoreInt(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Integer.parseInt(new String(byArray));
    }

    static double restoreDouble(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Double.parseDouble(new String(byArray));
    }

    static boolean restoreBoolean(String string) {
        byte[] byArray = Printer.restoreBytes(string, false);
        return Boolean.valueOf(new String(byArray));
    }

    static byte[] restoreBytes(String string, boolean bl) {
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        byte[] byArray = new byte[++end - start];
        System.arraycopy(settingsData, start, byArray, 0, byArray.length);
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        int n = end - start;
        ++end;
        if (bl) {
            ++n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(settingsData, start, byArray2, 0, n);
        if (DEBUG) {
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, byArray))) + ": " + new String(Converter.mbcsToWcs(null, byArray2)));
        }
        return byArray2;
    }

    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        long l = OS.gtk_widget_get_default_style();
        long l2 = OS.pango_font_description_copy(OS.gtk_style_get_font_desc(l));
        int n = OS.pango_font_description_get_size(l2);
        Point point = this.getDPI();
        Point point2 = super.getDPI();
        OS.pango_font_description_set_size(l2, n * point.y / point2.y);
        this.systemFont = Font.gtk_new(this, l2);
        return this.systemFont;
    }

    public long internal_new_GC(GCData gCData) {
        long l;
        long l2 = 0L;
        if (OS.USE_CAIRO) {
            l = this.cairo;
        } else {
            GdkVisual gdkVisual = new GdkVisual();
            OS.memmove(gdkVisual, OS.gdk_visual_get_system());
            l2 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), 1, 1, gdkVisual.depth);
            l = OS.gdk_gc_new(l2);
        }
        if (l == 0L) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((gCData.style & (n = 0x6000000)) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = l2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
            Point point = this.getDPI();
            Point point2 = this.getIndependentDPI();
            gCData.width = (int)(OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x);
            gCData.height = (int)(OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y);
            if (this.cairo == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_identity_matrix(this.cairo);
            double d = OS.gtk_page_setup_get_left_margin(this.pageSetup, 1);
            double d2 = OS.gtk_page_setup_get_top_margin(this.pageSetup, 1);
            Cairo.cairo_translate(this.cairo, d, d2);
            Cairo.cairo_scale(this.cairo, (float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(this.cairo, dArray);
            gCData.identity = dArray;
            gCData.cairo = this.cairo;
            this.isGCCreated = true;
        }
        return l;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        long l2 = l;
        if (gCData != null) {
            this.isGCCreated = false;
        }
        if (OS.USE_CAIRO) {
            return;
        }
        OS.g_object_unref(l2);
        if (gCData != null) {
            if (gCData.drawable != 0L) {
                OS.g_object_unref(gCData.drawable);
            }
            gCData.cairo = 0L;
            gCData.drawable = 0L;
        }
    }

    protected void release() {
        super.release();
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
    }

    public boolean startJob(String string) {
        this.checkDevice();
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        this.printJob = OS.gtk_print_job_new(byArray, this.printer, this.settings, this.pageSetup);
        if (this.printJob == 0L) {
            return false;
        }
        this.surface = OS.gtk_print_job_get_surface(this.printJob, null);
        if (this.surface == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0L;
            return false;
        }
        return true;
    }

    protected void destroy() {
        if (this.printer != 0L) {
            OS.g_object_unref(this.printer);
        }
        if (this.settings != 0L) {
            OS.g_object_unref(this.settings);
        }
        if (this.pageSetup != 0L) {
            OS.g_object_unref(this.pageSetup);
        }
        if (this.cairo != 0L) {
            Cairo.cairo_destroy(this.cairo);
        }
        if (this.printJob != 0L) {
            OS.g_object_unref(this.printJob);
        }
        this.printJob = 0L;
        this.cairo = 0L;
        this.pageSetup = 0L;
        this.settings = 0L;
        this.printer = 0L;
    }

    public void endJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.gtk_print_job_send(this.printJob, 0L, 0L, 0L);
        OS.g_object_unref(this.printJob);
        this.printJob = 0L;
    }

    public void cancelJob() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.g_object_unref(this.printJob);
        this.printJob = 0L;
    }

    public boolean startPage() {
        this.checkDevice();
        if (this.printJob == 0L) {
            return false;
        }
        double d = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double d2 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        int n = Cairo.cairo_surface_get_type(this.surface);
        switch (n) {
            case 2: {
                Cairo.cairo_ps_surface_set_size(this.surface, d, d2);
                break;
            }
            case 1: {
                Cairo.cairo_pdf_surface_set_size(this.surface, d, d2);
            }
        }
        return true;
    }

    public void endPage() {
        this.checkDevice();
        if (this.cairo != 0L) {
            Cairo.cairo_show_page(this.cairo);
        }
    }

    public Point getDPI() {
        this.checkDevice();
        int n = OS.gtk_print_settings_get_resolution(this.settings);
        if (DEBUG) {
            System.out.println("print_settings.resolution=" + n);
        }
        if (n == 0) {
            return new Point(72, 72);
        }
        return new Point(n, n);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        return new Rectangle(0, 0, (int)d, (int)d2);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        return new Rectangle(0, 0, (int)d, (int)d2);
    }

    Point getIndependentDPI() {
        return new Point(72, 72);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkDevice();
        Point point = this.getDPI();
        Point point2 = this.getIndependentDPI();
        double d = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d2 = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d3 = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d4 = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d5 = -OS.gtk_page_setup_get_left_margin(this.pageSetup, 1) * (double)point.x / (double)point2.x;
        double d6 = -OS.gtk_page_setup_get_top_margin(this.pageSetup, 1) * (double)point.y / (double)point2.y;
        double d7 = d3 - d;
        double d8 = d4 - d2;
        return new Rectangle(n + (int)d5, n2 + (int)d6, n3 + (int)d7, n4 + (int)d8);
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || disablePrinting) {
            SWT.error(2);
        }
        this.printer = Printer.gtkPrinterFromPrinterData(this.data);
        if (this.printer == 0L) {
            SWT.error(2);
        }
    }

    protected void init() {
        byte[] byArray;
        this.settings = OS.gtk_print_settings_new();
        this.pageSetup = OS.gtk_page_setup_new();
        if (this.data.otherData != null) {
            Printer.restore(this.data.otherData, this.settings, this.pageSetup);
        }
        if (this.data.printToFile && this.data.fileName != null && (byArray = Printer.uriFromFilename(this.data.fileName)) != null) {
            OS.gtk_print_settings_set(this.settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, byArray);
        }
        OS.gtk_print_settings_set_n_copies(this.settings, this.data.copyCount);
        OS.gtk_print_settings_set_collate(this.settings, this.data.collate);
        if (this.data.duplex != -1) {
            int n = this.data.duplex == 1 ? 1 : (this.data.duplex == 2 ? 2 : 0);
            OS.gtk_print_settings_set_duplex(this.settings, n);
            String string = null;
            if (n == 1) {
                string = "DuplexNoTumble";
            } else if (n == 2) {
                string = "DuplexTumble";
            }
            if (string != null) {
                byte[] byArray2 = Converter.wcsToMbcs(null, "cups-Duplex", true);
                byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
                OS.gtk_print_settings_set(this.settings, byArray2, byArray3);
            }
        }
        int n = this.data.orientation == 2 ? 1 : 0;
        OS.gtk_page_setup_set_orientation(this.pageSetup, n);
        OS.gtk_print_settings_set_orientation(this.settings, n);
        super.init();
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

