/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.components.URL;

import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeUtil;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: LocalUrl.java 3 2009-07-04 07:27:13Z takahashikzn $
 */
public class LocalUrl
    extends URL {

    /**
     * @param stack
     * stack
     * @param req
     * req
     * @param res
     * res
     */
    public LocalUrl(
        final ValueStack stack, final HttpServletRequest req,
        final HttpServletResponse res) {
        super(stack, req, res);
    }

    /** {@inheritDoc} */
    @Override
    protected void putInContext(final Object value) {
        this.getEnclosingLocalVariableScope().setVar(this.getVar(), value);
    }

    /**
     * 現在のset-localタグを囲っているblockタグを取得する。
     * 
     * @return Block
     */
    protected LocalVariableScope getEnclosingLocalVariableScope() {
        return LocalVariableScopeUtil.getEnclosingLocalVariableScope(this);
    }
}
