// OggReader.h
// 2008/11/18

#pragma once

using namespace System;
using namespace System::IO;

namespace QOgg {

// Header
public value struct Header {

	Byte Version;
	Byte HeaderType;

	UInt64 GranulePosition;

	UInt32 BitStreamSerialNumber;
	UInt32 PageSequenceNumber;

	UInt32 CRC32;

	array<Int32>^ Packets;

	Int32 PendingPacketSize;

	/* */

	static const Byte HT_Continue = 0x01;
	static const Byte HT_BOS      = 0x02;
	static const Byte HT_EOS      = 0x04;

}; // Header

// InvalidStream
public ref class InvalidStream : public Exception {

public:

	InvalidStream()
	{
	}

	InvalidStream(String ^ msg) : Exception(msg)
	{
	}

}; // InvalidStream

// Reader
public ref class Reader {

	Stream^ m_s;

public:

	Reader(Stream^ s) : m_s(s)
	{
	}

	Header ReadPageHeader()
	{
		Header header;

		array<Byte>^ buf = gcnew array<Byte>(26+1);
		Int32 blen = m_s->Read(buf, 0, buf->Length);
		if (blen == 0) {
			return header;
		}

		if (blen != buf->Length) {
			throw gcnew InvalidStream("Read.Header");
		}

		if (buf[0] != 'O' ||
			buf[1] != 'g' ||
			buf[2] != 'g' ||
			buf[3] != 'S') {
			throw gcnew InvalidStream("OggS.Signature");
		}

		header.Version    = buf[4];
		header.HeaderType = buf[5];

		header.GranulePosition = BitConverter::ToUInt64(buf, 6);

		header.BitStreamSerialNumber = BitConverter::ToUInt32(buf, 14);
		header.PageSequenceNumber    = BitConverter::ToUInt32(buf, 18);

		header.CRC32 = BitConverter::ToUInt32(buf, 22);

		Int32 sgs = buf[26];
		array<Byte>^ seg = gcnew array<Byte>(sgs);
		blen = m_s->Read(seg, 0, seg->Length);
		if (blen != seg->Length) {
			throw gcnew InvalidStream("Read.Segments");
		}

		Int32 packets = 0;
		for (Int32 i = 0; i < sgs; i++) {
			if (seg[i] < 0xff) {
				packets += 1;
			}
		}

		header.Packets = gcnew array<Int32>(packets);

		Int32 idx = 0;
		Int32 len = 0;
		for (Int32 i = 0; i < sgs; i++) {
			len += (Int32)seg[i];

			if (seg[i] < 0xff) {
				header.Packets[idx] = len;

				idx += 1;
				len  = 0;
			}
		}

		header.PendingPacketSize = len;

		return header;
	}

	array<Byte>^ ReadPacketPayload(Int32 length)
	{
		array<Byte>^ buf = gcnew array<Byte>(length);

		Int32 len = m_s->Read(buf, 0, buf->Length);
		if (len != buf->Length) {
			throw gcnew InvalidStream("Read.Packets");
		}

		return buf;
	}

}; // Reader

} // namespace QOgg

