/* Utils.c    */
/* 2009/07/22 */

#include "StdAfx.h"

#include "Utils.h"

/* */

static VOID* s_allocate(VOID* ctx, SIZE_T sz)
{
	return _aligned_malloc(sz, 0x10);
}

static VOID* s_reallocate(VOID* ctx, VOID* pv, SIZE_T sz)
{
	return _aligned_realloc(pv, sz, 0x10);
}

static VOID s_free(VOID* ctx, VOID* pv)
{
	_aligned_free(pv);
}

QO_Allocator_t* Allocator_Get()
{
	static QO_Allocator_t s_allocator = {
		0,
		s_allocate,
		s_reallocate,
		s_free
	};

	return &s_allocator;
}

/* */

static INT32 s_read(VOID* ctx, VOID* pv, INT32 sz)
{
	return fread(pv, 1, sz, (FILE*)ctx);
}

static BOOL  s_seek(VOID* ctx, INT64 pos)
{
	if (_fseeki64((FILE*)ctx, pos, SEEK_SET) != 0) {
		return FALSE;
	}
	return TRUE;
}

static INT64 s_size(VOID* ctx)
{
	int fd = _fileno((FILE*)ctx);
	return _filelengthi64(fd);
}

void QO_StreamReader_Init(
	QO_StreamReader_t* t,
	FILE*              fp)
{
	t->Context = fp;

	t->Read = s_read;
	t->Seek = s_seek;
	t->Size = s_size;
}

/* */

static INT32 s_reads(VOID* ctx, VOID* pv, INT32 sz)
{
	IStream* p = (IStream*)ctx;
	ULONG cb = 0;
	HRESULT hRslt = p->lpVtbl->Read(p, pv, sz, &cb);
	if (FAILED(hRslt)) {
		return 0;
	}
	return cb;
}

static BOOL  s_seeks(VOID* ctx, INT64 pos)
{
	IStream* p = (IStream*)ctx;
	LARGE_INTEGER  li;
	ULARGE_INTEGER np;
	HRESULT hRslt;
	li.QuadPart = pos;
	hRslt = p->lpVtbl->Seek(p, li, STREAM_SEEK_SET, &np);
	if (FAILED(hRslt)) {
		return FALSE;
	}
	return TRUE;
}

static INT64 s_sizes(VOID* ctx)
{
	IStream* p = (IStream*)ctx;
	STATSTG ss = { 0 };
	HRESULT hRslt = p->lpVtbl->Stat(p, &ss, STATFLAG_NONAME);
	if (FAILED(hRslt)) {
		return 0;
	}
	return ss.cbSize.QuadPart;
}

void QO_StreamReader_IStream(
	QO_StreamReader_t* t,
	IStream*           p)
{
	t->Context = p;

	t->Read = s_reads;
	t->Seek = s_seeks;
	t->Size = s_sizes;
}

/* */

struct MemoryBlock;

typedef struct MemoryBlock MemoryBlock_t;

struct MemoryBlock {

	MemoryBlock_t* Next;

	SIZE_T Size;

	UINT32 Padding[2];

};

/* */

void QO_MemoryPool_Init(
	QO_MemoryPool_t* t)
{
	t->Block     = NULL;
	t->TotalSize = 0;
}

void QO_MemoryPool_Release(
	QO_MemoryPool_t* t,
	QO_Allocator_t*  alloc)
{
	MemoryBlock_t* p = (MemoryBlock_t*)(t->Block);
	while (p != NULL) {
		MemoryBlock_t* n = p->Next;
		alloc->Free(alloc->Context, p);
		p = n;
	}

	t->Block     = NULL;
	t->TotalSize = 0;
}

VOID* QO_MemoryPool_Allocate(
	QO_MemoryPool_t* t,
	QO_Allocator_t*  alloc,
	SIZE_T           cb)
{
	MemoryBlock_t* b = (MemoryBlock_t*)alloc->Allocate(
		alloc->Context,
		sizeof(MemoryBlock_t) + cb);
	if (b == NULL) {
		return NULL;
	}

	b->Next = t->Block;
	b->Size = cb;

	t->Block      = b;
	t->TotalSize += cb;

	return b + 1;
}

/* */

