// Decoder.h
// 2008/12/16

#pragma once

using namespace System;

namespace QVorbis {

// Decoder
public ref class Decoder : IDisposable {

	QVorbisDecoder_t* m_decoder;

public:

	Decoder() : m_decoder(0)
	{
		m_decoder = QV_CreateDecoder();
		if (m_decoder == 0) {
			throw gcnew OutOfMemoryException();
		}
	}

	~Decoder()
	{
		if (m_decoder != 0) {
			QV_ReleaseDecoder(m_decoder);
			m_decoder = 0;
		}
	}

	void Create(
		Setup^ setup,
		Int32  size)
	{
		QVorbisDecoderSetup_t* s = setup->DecoderSetup;

		if (!QV_SetupDecoder(
			m_decoder,
			s,
			size)) {
			throw gcnew Error("QV_SetupDecoder");
		}
	}

	array<array<Single>^>^ Decode(
		array<Byte>^ packet)
	{
		QV_Output_t output;

		{
			pin_ptr<Byte> p = &(packet[0]);

			if (!QV_DecodeFrame(
				m_decoder,
				p,
				packet->Length,
				&output)) {
				throw gcnew Error("QV_DecodeFrame");
			}
		}

		if (output.Length == 0) {
			return nullptr;
		}

		array<array<Single>^>^ o = gcnew array<array<Single>^>(output.Channels);

		for (Int32 i = 0; i < output.Channels; i++) {
			o[i] = gcnew array<Single>(output.Length);

			pin_ptr<Single> d = &(o[i][0]);
			CopyMemory(d, output.Output[i], output.Length * sizeof(FLOAT));
		}

		return o;
	}

	array<Int16>^ DecodePCM(
		array<Byte>^ packet)
	{
		QV_Output_t output;

		{
			pin_ptr<Byte> p = &(packet[0]);

			if (!QV_DecodeFrame(
				m_decoder,
				p,
				packet->Length,
				&output)) {
				throw gcnew Error("QV_DecodeFrame");
			}
		}

		if (output.Length == 0) {
			return nullptr;
		}

		QV_Convert_t convert;

		if (!QV_ConvertFrame(
			m_decoder,
			&output,
			&convert)) {
			throw gcnew Error("QV_ConvertFrame");
		}

		array<Int16>^ o = gcnew array<Int16>(convert.Samples);
		{
			pin_ptr<Int16> d = &(o[0]);
			CopyMemory(d, convert.Sample, convert.Samples * sizeof(Int16));
		}

		return o;
	}

	void Reset()
	{
		QV_ResetDecoder(m_decoder);
	}

}; // Decoder

} // namespace QVorbis

