// WuQVorbis.cpp
// 2008/12/10

#include "StdAfx.h"

#include "QAXDecoder.h"

#include "OggVorbis.h"

#include "WuQVorbis.h"

/* */

extern "C"
HRESULT STDCALL GetModuleInstance(
	ITSSModule**         out,
	ITSSStorageProvider* provider,
	IStream*             config,
	HWND                 mainwin)
{
	static bool s_init = false;
	if (!s_init) {
		if (!QAX::Initialize()) {
			return E_OUTOFMEMORY;
		}
		s_init = true;
	}

	if (out == 0) {
		return E_INVALIDARG;
	}

	QModule* mod = new QModule(provider);

	*out = static_cast<ITSSModule*>(mod);

	return S_OK;
}

/* */

STDMETHODIMP QModule::GetMediaInstance(
	LPWSTR     url,
	IUnknown** instance)
{
	if (url == 0 || instance == 0) {
		return E_INVALIDARG;
	}

	*instance = 0;

	INT32 len = wcslen(url);
	if (len < 4) {
		return E_INVALIDARG;
	}

	LPCWSTR ext = url + len - 4;;
	if (_wcsicmp(ext, L".qas") == 0) {
		return CreateQASOutput(url, instance);

	} else if (_wcsicmp(ext, L".qax") == 0) {
		return CreateQAXOutput(url, instance);

	} else if (_wcsicmp(ext, L".ogg") == 0) {
		return CreateOggOutput(url, instance);
	}

	return E_INVALIDARG;
}

/* */

HRESULT QModule::CreateQASOutput(
	LPWSTR     url,
	IUnknown** instance)
{
	*instance = 0;

	IStream* pStream = 0;
	HRESULT hRslt = m_Provider->GetStreamForRead(
		url,
		(IUnknown**)&pStream);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	QDecoder* obj = 0;

	try {
		QAX::QDecoderOutput* output = QAX::QASDecoderOutputCreate(
			m_Factory,
			pStream);
		if (output != 0) {
			obj = new QDecoder(output);
		}

	} catch (QAX::Exception&) {

	}

	pStream->Release();

	if (obj == 0) {
		return E_FAIL;
	}

	*instance = static_cast<IUnknown*>(obj);

	return S_OK;
}

/* */

HRESULT QModule::CreateQAXOutput(
	LPWSTR     url,
	IUnknown** instance)
{
	LPCWSTR p = url;

	std::wstring rename;

	if (_wcsnicmp(p, L"file://./", 9) == 0) {
		p += 10;

		WCHAR drive[2];
		drive[0] = p[-1];
		drive[1] = L':';

		rename = std::wstring(drive, 2) + p;

		p = rename.c_str();
	}

	std::wstring path;
	std::wstring name;

	LPCWSTR dim = wcsstr(p, L">");
	if (dim != 0) {
		path = std::wstring(p, dim - p);
		name = std::wstring(dim + 1);

	} else {
		path = std::wstring(p);
	}

	QAX::QDecoder* decoder = SetupDecoder(path);
	if (decoder == 0) {
		return E_FAIL;
	}

	QDecoder* obj = 0;

	try {
		std::string id;
		if (name.empty()) {
			QAX::QItem item = decoder->GetItem(0);
			id = item.Name;

		} else {
			INT32 blen = WideCharToMultiByte(
				CP_UTF8,
				0,
				name.c_str(),
				name.size(),
				0,
				0,
				0,
				0);
			if (blen > 0) {
				CHAR* bid = new CHAR[blen];
				blen = WideCharToMultiByte(
					CP_UTF8,
					0,
					name.c_str(),
					name.size(),
					bid,
					blen,
					0,
					0);

				id = std::string(bid, blen);

				delete[] bid;
			}
		}

		QAX::QDecoderOutput* output = decoder->CreateOutput(
			id.c_str());
		if (output != 0) {
			obj = new QDecoder(output);
		}

	} catch (QAX::Exception&) {

	}

	if (obj == 0) {
		return E_FAIL;
	}

	*instance = static_cast<IUnknown*>(obj);

	return S_OK;
}

/* */

HRESULT QModule::CreateOggOutput(
	LPWSTR     url,
	IUnknown** instance)
{
	*instance = 0;

	IStream* pStream = 0;
	HRESULT hRslt = m_Provider->GetStreamForRead(
		url,
		(IUnknown**)&pStream);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	QOggDecoder* obj = 0;

	QOV_Reader_t* reader = QOV_CreateReader();
	if (reader != 0) {
		if (QOV_OpenReader_IStream(reader, pStream)) {
			obj = new QOggDecoder(reader);
		}
	}

	pStream->Release();

	if (obj == 0) {
		return E_FAIL;
	}

	*instance = static_cast<IUnknown*>(obj);

	return S_OK;
}

/* */

