/* TransformDecoder.h */
/* 2008/11/07         */

#pragma once

#include "TransformIMDCT.h"

/* */

struct TransformDecoder;

typedef struct TransformDecoder TransformDecoder_t;

typedef void (*Transform_t)(TransformDecoder_t*, const FLOAT*, FLOAT*);

/* TransformDecoder */
struct TransformDecoder {

	Transform_t Transform;

}; /* TransformDecoder */

/* */

struct WindowingDecoder;

typedef struct WindowingDecoder WindowingDecoder_t;

typedef void (*Windowing_t)(WindowingDecoder_t*, FLOAT*, const FLOAT*, const FLOAT*);

/* WindowingDecoder */
struct WindowingDecoder {

	Windowing_t Windowing;

}; /* WindowingDecoder */

/* */

void TransformDecoder_Init(MemoryPool_t* pool);
void TransformDecoder_Uninit(void);

TransformDecoder_t* GetTransformDecoder(INT32 n);
WindowingDecoder_t* GetWindowingDecoder(INT32 n);

/* */

TransformDecoder_t* CreateTransformDecoder(
	MemoryPool_t* pool,
	INT32         n);

/* */

