/* SamplesChecker.c */
/* 2008/11/18       */

#include "StdAfx.h"

#include "SamplesChecker.h"

/* */

BOOL SamplesChecker_Setup(
	const DecoderSetup_t* setup,
	SamplesChecker_t*     t)
{
	INT32 i;

	t->Channels   = setup->Channels;
	t->SampleRate = setup->SampleRate;

	t->BlockSize0 = setup->BlockSize0;
	t->BlockSize1 = setup->BlockSize1;

	if (setup->ModeCount > 32 || setup->ModeCount <= 0) {
		return FALSE;
	}

	if (setup->ModeSetup == NULL) {
		return FALSE;
	}

	t->ModeCount = setup->ModeCount;
	t->ModeBits  = setup->ModeBits;

	t->BlockFlags = 0;
	for (i = 0; i < t->ModeCount; i++) {
		ModeSetup_t* mode = setup->ModeSetup + i;
		if (mode->BlockFlag != 0) {
			t->BlockFlags |= (UINT32)(1 << i);
		}
	}

	t->BlockSize     = 0;
	t->PrevBlockSize = 0;

	return TRUE;
}

void SamplesChecker_Reset(
	SamplesChecker_t* t)
{
	t->BlockSize     = 0;
	t->PrevBlockSize = 0;
}

BOOL SamplesChecker_CheckFrame(
	SamplesChecker_t* t,
	const VOID*       frame,
	INT32             size,
	INT32*            samples)
{
	UINT8 by, mask;

	INT32 mode;

	UINT32 flag;

	const UINT8* p = (const UINT8*)frame;

	*samples = 0;

	if (size < 1) {
		return FALSE;
	}

	by = p[0];

	if ((by & 1) != 0) {
		return FALSE;
	}

	by >>= 1;

	mask = (1 << t->ModeBits) - 1;

	mode = by & mask;
	if (mode >= t->ModeCount) {
		return FALSE;
	}

	flag = 1 << mode;

	t->PrevBlockSize = t->BlockSize;

	if ((t->BlockFlags & flag) == 0) {
		t->BlockSize = t->BlockSize0;
	} else {
		t->BlockSize = t->BlockSize1;
	}

	if (t->PrevBlockSize > 0) {
		*samples = (t->PrevBlockSize + t->BlockSize) / 4;
	}

	return TRUE;
}

/* */

