/* Floor1Decoder.h */
/* 2008/11/06      */

#pragma once

#include "HuffmanDecoder.h"

/* Floor1Entry */
struct Floor1Entry {

	UINT16 X;
	UINT16 V;
	UINT16 Low;
	UINT16 High;

}; /* Floor1Entry */

typedef struct Floor1Entry Floor1Entry_t;

/* Floor1Setup */
struct Floor1Setup {

	INT32 Partitions;

	UINT8 PartitionClassList[32];

	UINT8 ClassDimensions[16];
	UINT8 ClassSubClasses[16];
	UINT8 ClassMasterBooks[16];
	INT16 SubclassBooks[16][8];

	INT32 Multiplier;
	INT32 Range;
	INT32 RangeBits;

	INT32 Values;

	Floor1Entry_t* List;

}; /* Floor1Setup */

typedef struct Floor1Setup Floor1Setup_t;

/* */

BOOL Floor1Decoder_Setup(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	Floor1Setup_t*    setup);

BOOL Floor1Decoder_Parse(
	DecoderContext_t*       ctx,
	BitDecoder_t*           d,
	const Floor1Setup_t*    setup,
	const HuffmanDecoder_t* huff,
	INT16*                  y);

void Floor1Decoder_Decode(
	const Floor1Setup_t*  setup,
	INT16*                y,
	FLOAT*                z,
	INT32                 count);

/* */

