/* OggVorbisReader.h */
/* 2009/07/23        */

#pragma once

/* */

#include "VorbisDecoder.h"

#include "OggReader.h"

/* */

struct QO_OggVorbisReader {

	QO_OggReader_t Reader;

	INT64 StreamSize;

	INT64 Position;
	INT64 SeekPosition;
	INT64 Duration;

	UINT32 StreamSerialNumber;
	UINT32 PageSequenceNumber;

	QVorbisDecoderSetup_t* Setup;
	QVorbisDecoder_t*      Decoder;

	BOOL EndOfStream;

	INT32 PendingSamples;

	const INT16* SampleBuffer;

	INT32 SampleUnit;

	UINT8* PacketBuffer;
	INT32  PacketIndex;

}; /* QO_OggVorbisReader */

typedef struct QO_OggVorbisReader QO_OggVorbisReader_t;

/* */

BOOL QO_OggVorbisReader_Init(
	QO_OggVorbisReader_t* t,
	QO_MemoryPool_t*      pool,
	QO_Allocator_t*       allocator,
	QO_StreamReader_t*    reader);

void QO_OggVorbisReader_Release(
	QO_OggVorbisReader_t* t);

/* */

BOOL QO_OggVorbisReader_Setup(
	QO_OggVorbisReader_t* t);

BOOL QO_OggVorbisReader_DetectSamples(
	QO_OggVorbisReader_t* t,
	INT64*                samples);

/* */

struct QO_OggVorbisRange {

	INT64 Start;
	INT64 End;

}; /* QO_OggVorbisRange */

typedef struct QO_OggVorbisRange QO_OggVorbisRange_t;

BOOL QO_OggVorbisReader_QuerySampleRange(
	QO_OggVorbisReader_t* t,
	INT64                 pos,
	QO_OggVorbisRange_t*  range);

/* */

BOOL QO_OggVorbisReader_SeekPage(
	QO_OggVorbisReader_t* t,
	INT64                 pos);

/* */

BOOL QO_OggVorbisReader_Seek(
	QO_OggVorbisReader_t* t,
	INT64                 sample);

/* */

BOOL QO_OggVorbisReader_Decode(
	QO_OggVorbisReader_t* t,
	VOID*                 buffer,
	INT32                 samples,
	INT32*                output);

/* */

