<?php
class review_list_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 0; // this value set by review_base.list_records

function get_pager_option($add_condition='',$cond='AND') {
	$where_condition = $this->make_where_condition($add_condition,$cond);
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition($add_condition='',$cond='AND') {
	$search_system_file = $this->page->home_dir.'/etc/search_view/review.sys';
	if(file_exists($search_system_file)) {
		$search_system = read_data_array($search_system_file);
	} else {
		$search_system = array(
			'keyword'=>array('name'=>'review.name',), // keyword search target column
			'condition'=>array('id'=>'review.id',), // id search target column
			//'period'=>array('start_date'=>array('column'=>'date','end'=>'end_date'))
			);
	}
	return $this->list->make_condition($search_system,$add_condition,$cond);
}

function make_join_condition() {
	$joins = array();
	//$this->list->real_count = true; // set this flag if join other table
	$joins[] = "LEFT JOIN item ON review.item_id=item.id";
	$joins[] = "LEFT JOIN userauth ON review.user_id=userauth.id";
	if(count($this->page->add_joins)>0) {
		$joins = array_merge($joins,$this->page->add_joins);
	}
	if(count($joins)) $join_condition = implode(' ',$joins);
	return $join_condition;
}

function make_select_fields() {
	$this->select_system = array(
		'review'=>'*', 
		'item'=>array('name'=>'item_name'), 
		'userauth'=>array('handle'=>'handle'),
		);
	if(count($this->page->add_fields)>0) {
		$this->select_system = array_merge($this->select_system,$this->page->add_fields);
	}
	return $this->list->make_select_fields($this->select_system);
}

function make_grouping_condition() {
	$grouping_condition = 'GROUP BY '.$this->list->make_grouping_fields($this->select_system);
	return $grouping_condition;
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by review.id',
		// sort keys
		'columns'=>array('id'=>'review.id','item_id'=>'item.name','update_datetime'=>'review.update_datetime'),
		);
	if($this->page->sort_option) {
		$this->list->set_sort_option($this->page->sort_option,$this->page->order_option);
	}
	return $this->list->make_order($sort_system);
}

function set_batch_list_option() {
	$this->list->hide_in_batch_list(
		array(
			// write hide field list ex) 'properties','memo'...
		)
	);
	$this->list->freeze_in_batch_list(
		array(
			// write freeze display field list ex) 'name','url'...
		)
	);
}


} // end of class review_list_options
?>